/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd.monitor;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.bff.javampd.Server;
import org.bff.javampd.events.ConnectionChangeEvent;
import org.bff.javampd.events.ConnectionChangeListener;
import org.bff.javampd.exception.MPDException;
import org.bff.javampd.monitor.ConnectionMonitor;

@Singleton
public class MPDConnectionMonitor
implements ConnectionMonitor {
    private List<ConnectionChangeListener> connectionListeners = new ArrayList<ConnectionChangeListener>();
    private Server server;
    private boolean connected = true;

    @Override
    public synchronized void addConnectionChangeListener(ConnectionChangeListener ccl) {
        this.connectionListeners.add(ccl);
    }

    @Override
    public synchronized void removeConnectionChangeListener(ConnectionChangeListener ccl) {
        this.connectionListeners.remove(ccl);
    }

    protected synchronized void fireConnectionChangeEvent(boolean isConnected, String msg) {
        ConnectionChangeEvent cce = new ConnectionChangeEvent(this, isConnected, msg);
        for (ConnectionChangeListener ccl : this.connectionListeners) {
            ccl.connectionChangeEventReceived(cce);
        }
    }

    @Override
    public void checkStatus() throws MPDException {
        boolean conn = this.server.isConnected();
        if (this.connected != conn) {
            this.connected = conn;
            this.fireConnectionChangeEvent(conn, "Connection Changed");
        }
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }
}

