/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd;

import org.bff.javampd.events.PlayerChangeListener;
import org.bff.javampd.events.VolumeChangeListener;
import org.bff.javampd.exception.MPDPlayerException;
import org.bff.javampd.objects.MPDAudioInfo;
import org.bff.javampd.objects.MPDSong;

public interface Player {
    public MPDSong getCurrentSong() throws MPDPlayerException;

    public void addPlayerChangeListener(PlayerChangeListener var1);

    public void removePlayerChangedListener(PlayerChangeListener var1);

    public void addVolumeChangeListener(VolumeChangeListener var1);

    public void removeVolumeChangedListener(VolumeChangeListener var1);

    public void play() throws MPDPlayerException;

    public void playId(MPDSong var1) throws MPDPlayerException;

    public void seek(long var1) throws MPDPlayerException;

    public void seekId(MPDSong var1, long var2) throws MPDPlayerException;

    public void stop() throws MPDPlayerException;

    public void pause() throws MPDPlayerException;

    public void playNext() throws MPDPlayerException;

    public void playPrev() throws MPDPlayerException;

    public void mute() throws MPDPlayerException;

    public void unMute() throws MPDPlayerException;

    public int getBitrate() throws MPDPlayerException;

    public int getVolume() throws MPDPlayerException;

    public void setVolume(int var1) throws MPDPlayerException;

    public boolean isRepeat() throws MPDPlayerException;

    public void setRepeat(boolean var1) throws MPDPlayerException;

    public boolean isRandom() throws MPDPlayerException;

    public void setRandom(boolean var1) throws MPDPlayerException;

    public void randomizePlay() throws MPDPlayerException;

    public void unRandomizePlay() throws MPDPlayerException;

    public int getXFade() throws MPDPlayerException;

    public void setXFade(int var1) throws MPDPlayerException;

    public long getElapsedTime() throws MPDPlayerException;

    public MPDAudioInfo getAudioDetails() throws MPDPlayerException;

    public Status getStatus() throws MPDPlayerException;

    public static enum Status {
        STATUS_STOPPED("stop"),
        STATUS_PLAYING("play"),
        STATUS_PAUSED("pause");

        private String prefix;

        private Status(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

