/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bff.javampd.objects.MPDSong;
import org.bff.javampd.processor.SongProcessor;

public class MPDSongConverter {
    private static String PREFIX_FILE = SongProcessor.FILE.getPrefix().getPrefix();

    private MPDSongConverter() {
    }

    public static List<MPDSong> convertResponseToSong(List<String> list) {
        ArrayList<MPDSong> songList = new ArrayList<MPDSong>();
        Iterator<String> iterator = list.iterator();
        String line = null;
        while (iterator.hasNext()) {
            if (line == null || !line.startsWith(PREFIX_FILE)) {
                line = iterator.next();
            }
            if (!line.startsWith(PREFIX_FILE)) continue;
            MPDSong song = new MPDSong();
            song.setFile(line.substring(PREFIX_FILE.length()).trim());
            line = iterator.next();
            while (!line.startsWith(PREFIX_FILE)) {
                MPDSongConverter.processLine(song, line);
                if (!iterator.hasNext()) break;
                line = iterator.next();
            }
            songList.add(song);
        }
        return songList;
    }

    private static void processLine(MPDSong song, String line) {
        for (SongProcessor songProcessor : SongProcessor.values()) {
            songProcessor.getPrefix().processSong(song, line);
        }
    }

    public static List<String> getSongNameList(List<String> fileList) {
        ArrayList<String> names = new ArrayList<String>();
        for (String s : fileList) {
            if (!s.startsWith(PREFIX_FILE)) continue;
            names.add(s.substring(PREFIX_FILE.length()).trim());
        }
        return names;
    }
}

