/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bff.javampd.MPDCommand;
import org.bff.javampd.exception.MPDConnectionException;
import org.bff.javampd.exception.MPDResponseException;
import org.bff.javampd.exception.MPDTimeoutException;
import org.bff.javampd.properties.ResponseProperties;
import org.bff.javampd.properties.ServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPDSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPDSocket.class);
    private Socket socket;
    private ResponseProperties responseProperties;
    private ServerProperties commandProperties;
    private String encoding;
    private String lastError;
    private String version;
    private String server;
    private int port;
    private static final int TRIES = 3;

    MPDSocket(InetAddress server, int port, int timeout) throws MPDConnectionException {
        this.server = server.getHostAddress();
        this.port = port;
        this.responseProperties = new ResponseProperties();
        this.commandProperties = new ServerProperties();
        this.encoding = this.commandProperties.getEncoding();
        this.version = this.connect(timeout);
    }

    private synchronized String connect(int timeout) throws MPDConnectionException {
        this.connectSocket(timeout);
        return this.readVersion();
    }

    private String readVersion() throws MPDConnectionException {
        String line;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), this.encoding));
            line = in.readLine();
        }
        catch (IOException e) {
            throw new MPDConnectionException(e);
        }
        if (this.isResponseOK(line)) {
            return this.stripResponse(this.responseProperties.getOk(), line).trim();
        }
        throw new MPDConnectionException("Command from server: " + (line == null ? "null" : this.stripResponse(this.responseProperties.getError(), line)));
    }

    private void connectSocket(int timeout) throws MPDTimeoutException {
        this.socket = new Socket();
        InetSocketAddress socketAddress = new InetSocketAddress(this.server, this.port);
        try {
            this.socket.connect(socketAddress, timeout);
        }
        catch (IOException ioe) {
            throw new MPDTimeoutException(ioe);
        }
    }

    public synchronized Collection<String> sendCommand(MPDCommand command) throws MPDResponseException {
        this.checkConnection();
        int count = 0;
        while (count < 3) {
            try {
                return this.sendBytes(this.convertCommand(command.getCommand(), command.getParams()));
            }
            catch (SocketException se) {
                try {
                    this.connect();
                }
                catch (Exception ex) {
                    LOGGER.error("Unable to connect to {} on port {}", new Object[]{this.server, this.port, ex});
                }
                LOGGER.error("Retrying command {} for the {} time", new Object[]{command.getCommand(), ++count, se});
            }
            catch (Exception e) {
                LOGGER.error("Got Error from: {}", (Object)command.getCommand(), (Object)e);
                for (String str : command.getParams()) {
                    LOGGER.error("\tparam: {}", (Object)str);
                }
                throw new MPDResponseException(e);
            }
        }
        return new ArrayList<String>();
    }

    private synchronized String connect() throws MPDConnectionException {
        return this.connect(0);
    }

    private boolean isResponseOK(String line) {
        try {
            if (line.startsWith(this.responseProperties.getOk())) {
                return true;
            }
            if (line.startsWith(this.responseProperties.getListOk())) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not determine if response is ok", (Throwable)e);
        }
        return false;
    }

    private boolean isResponseError(String line) {
        try {
            if (line.startsWith(this.responseProperties.getError())) {
                this.lastError = line.substring(this.responseProperties.getError().length()).trim();
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Could not determine if response is error", (Throwable)e);
        }
        return false;
    }

    private String stripResponse(String response, String line) {
        return line.substring(response.length());
    }

    private String convertCommand(String command) {
        return this.convertCommand(command, new ArrayList<String>());
    }

    private String convertCommand(String command, List<String> params) {
        StringBuilder sb = new StringBuilder(command);
        for (String param : params) {
            param = param.replaceAll("\"", "\\\\\"");
            sb.append(" \"").append(param).append("\"");
        }
        return sb.append("\n").toString();
    }

    public synchronized boolean sendCommands(List<MPDCommand> commandList) throws MPDResponseException {
        StringBuilder sb = new StringBuilder(this.convertCommand(this.commandProperties.getStartBulk()));
        for (MPDCommand command : commandList) {
            sb.append(this.convertCommand(command.getCommand(), command.getParams()));
        }
        sb.append(this.convertCommand(this.commandProperties.getEndBulk()));
        this.checkConnection();
        try {
            this.sendBytes(sb.toString());
        }
        catch (Exception e) {
            throw new MPDResponseException(e.getMessage(), e);
        }
        return true;
    }

    private List<String> sendBytes(String command) throws IOException, MPDResponseException {
        LOGGER.debug("start command: " + command.trim());
        byte[] bytesToSend = command.getBytes(this.commandProperties.getEncoding());
        BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), this.encoding));
        OutputStream outStream = this.socket.getOutputStream();
        outStream.write(bytesToSend);
        ArrayList<String> response = new ArrayList<String>();
        String inLine = in.readLine();
        while (inLine != null && !this.isResponseOK(inLine)) {
            if (this.isResponseError(inLine)) {
                throw new MPDResponseException(this.lastError, command);
            }
            response.add(inLine);
            inLine = in.readLine();
        }
        for (String s : response) {
            LOGGER.debug(s);
        }
        LOGGER.debug("end command: " + command.trim());
        return response;
    }

    private void checkConnection() throws MPDResponseException {
        if (!this.socket.isConnected()) {
            try {
                this.connect();
            }
            catch (Exception e) {
                throw new MPDResponseException("Connection to server lost: " + e.getMessage(), e);
            }
        }
    }

    public String getVersion() {
        return this.version;
    }
}

