/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.bff.javampd.CommandExecutor;
import org.bff.javampd.ServerStatus;
import org.bff.javampd.Status;
import org.bff.javampd.exception.MPDResponseException;
import org.bff.javampd.properties.ServerProperties;

public class MPDServerStatus
implements ServerStatus {
    @Inject
    private ServerProperties serverProperties;
    @Inject
    private CommandExecutor commandExecutor;

    protected String getStatus(Status status) throws MPDResponseException {
        List<String> respList = this.commandExecutor.sendCommand(this.serverProperties.getStatus());
        for (String line : respList) {
            if (!line.startsWith(status.getStatusPrefix())) continue;
            return line.substring(status.getStatusPrefix().length()).trim();
        }
        return null;
    }

    @Override
    public Collection<String> getStatus() throws MPDResponseException {
        return this.commandExecutor.sendCommand(this.serverProperties.getStatus());
    }

    @Override
    public int getPlaylistVersion() throws MPDResponseException {
        return Integer.parseInt(this.getStatus(Status.PLAYLIST));
    }

    @Override
    public String getState() throws MPDResponseException {
        return this.getStatus(Status.STATE);
    }

    @Override
    public String getXFade() throws MPDResponseException {
        return this.getStatus(Status.XFADE);
    }

    @Override
    public String getAudio() throws MPDResponseException {
        return this.getStatus(Status.AUDIO);
    }

    @Override
    public long getTime() throws MPDResponseException {
        String time = this.getStatus(Status.TIME);
        if (time == null || !time.contains(":")) {
            return 0L;
        }
        return Integer.parseInt(time.trim().split(":")[0]);
    }

    @Override
    public int getBitrate() throws MPDResponseException {
        return Integer.parseInt(this.getStatus(Status.BITRATE));
    }

    @Override
    public int getVolume() throws MPDResponseException {
        return Integer.parseInt(this.getStatus(Status.VOLUME));
    }

    @Override
    public boolean isRepeat() throws MPDResponseException {
        return "1".equals(this.getStatus(Status.REPEAT));
    }

    @Override
    public boolean isRandom() throws MPDResponseException {
        return "1".equals(this.getStatus(Status.RANDOM));
    }
}

