/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd;

import com.google.inject.Inject;
import java.util.List;
import org.bff.javampd.CommandExecutor;
import org.bff.javampd.ServerStatistics;
import org.bff.javampd.exception.MPDResponseException;
import org.bff.javampd.properties.ServerProperties;

public class MPDServerStatistics
implements ServerStatistics {
    @Inject
    private ServerProperties serverProperties;
    @Inject
    private CommandExecutor commandExecutor;

    private String getStat(ServerStatistics.StatList stat) throws MPDResponseException {
        List<String> respList = this.sendMPDCommand(this.serverProperties.getStats());
        for (String line : respList) {
            if (!line.startsWith(stat.getStatPrefix())) continue;
            return line.substring(stat.getStatPrefix().length()).trim();
        }
        return null;
    }

    private List<String> sendMPDCommand(String stats) throws MPDResponseException {
        return this.commandExecutor.sendCommand(stats);
    }

    @Override
    public long getPlaytime() throws MPDResponseException {
        return Long.parseLong(this.getStat(ServerStatistics.StatList.PLAYTIME));
    }

    @Override
    public long getUptime() throws MPDResponseException {
        return Long.parseLong(this.getStat(ServerStatistics.StatList.UPTIME));
    }

    @Override
    public int getAlbums() throws MPDResponseException {
        return Integer.parseInt(this.getStat(ServerStatistics.StatList.ALBUMS));
    }

    @Override
    public int getArtists() throws MPDResponseException {
        return Integer.parseInt(this.getStat(ServerStatistics.StatList.ARTISTS));
    }

    @Override
    public int getSongs() throws MPDResponseException {
        return Integer.parseInt(this.getStat(ServerStatistics.StatList.SONGS));
    }

    @Override
    public long getDatabasePlaytime() throws MPDResponseException {
        return Integer.parseInt(this.getStat(ServerStatistics.StatList.DBPLAYTIME));
    }

    @Override
    public long getDatabaseUpdateTime() throws MPDResponseException {
        return Long.parseLong(this.getStat(ServerStatistics.StatList.DBUPDATE));
    }
}

