/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.bff.javampd.CommandExecutor;
import org.bff.javampd.Database;
import org.bff.javampd.MPDCommand;
import org.bff.javampd.MPDFile;
import org.bff.javampd.MPDSongConverter;
import org.bff.javampd.Playlist;
import org.bff.javampd.ServerStatus;
import org.bff.javampd.events.PlaylistChangeEvent;
import org.bff.javampd.events.PlaylistChangeListener;
import org.bff.javampd.exception.MPDPlaylistException;
import org.bff.javampd.exception.MPDResponseException;
import org.bff.javampd.objects.MPDAlbum;
import org.bff.javampd.objects.MPDArtist;
import org.bff.javampd.objects.MPDGenre;
import org.bff.javampd.objects.MPDSavedPlaylist;
import org.bff.javampd.objects.MPDSong;
import org.bff.javampd.properties.PlaylistProperties;

public class MPDPlaylist
implements Playlist {
    private int oldVersion = -1;
    private int version = -1;
    private List<PlaylistChangeListener> listeners = new ArrayList<PlaylistChangeListener>();
    @Inject
    private Database database;
    @Inject
    private ServerStatus serverStatus;
    @Inject
    private PlaylistProperties playlistProperties = new PlaylistProperties();
    @Inject
    private CommandExecutor commandExecutor;

    MPDPlaylist() {
    }

    @Override
    public synchronized void addPlaylistChangeListener(PlaylistChangeListener pcl) {
        this.listeners.add(pcl);
    }

    @Override
    public synchronized void removePlaylistStatusChangedListener(PlaylistChangeListener pcl) {
        this.listeners.remove(pcl);
    }

    protected synchronized void firePlaylistChangeEvent(PlaylistChangeEvent.Event event) {
        PlaylistChangeEvent pce = new PlaylistChangeEvent(this, event);
        for (PlaylistChangeListener pcl : this.listeners) {
            pcl.playlistChanged(pce);
        }
    }

    protected synchronized void firePlaylistChangeEvent(PlaylistChangeEvent.Event event, String msg) {
        PlaylistChangeEvent pce = new PlaylistChangeEvent(this, event, msg);
        for (PlaylistChangeListener pcl : this.listeners) {
            pcl.playlistChanged(pce);
        }
    }

    @Override
    public void loadPlaylist(String playlistName) throws MPDPlaylistException {
        String name = playlistName;
        if (name.endsWith(".m3u")) {
            name = name.substring(name.length() - 4);
        }
        try {
            this.commandExecutor.sendCommand(this.playlistProperties.getLoad(), name);
        }
        catch (MPDResponseException re) {
            throw new MPDPlaylistException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
        this.updatePlaylist();
    }

    @Override
    public void addSong(MPDSong song) throws MPDPlaylistException {
        this.addSong(song, true);
    }

    @Override
    public void addSong(MPDSong song, boolean fireEvent) throws MPDPlaylistException {
        try {
            this.commandExecutor.sendCommand(this.playlistProperties.getAdd(), song.getFile());
        }
        catch (MPDResponseException re) {
            throw new MPDPlaylistException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
        this.updatePlaylist();
        if (fireEvent) {
            this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.SONG_ADDED, song.getName());
        }
    }

    @Override
    public boolean addSongs(List<MPDSong> songList) throws MPDPlaylistException {
        return this.addSongs(songList, true);
    }

    @Override
    public boolean addSongs(List<MPDSong> songList, boolean fireEvent) throws MPDPlaylistException {
        ArrayList<MPDCommand> commandList = new ArrayList<MPDCommand>();
        for (MPDSong song : songList) {
            commandList.add(new MPDCommand(this.playlistProperties.getAdd(), song.getFile()));
        }
        try {
            this.commandExecutor.sendCommands(commandList);
        }
        catch (MPDResponseException re) {
            throw new MPDPlaylistException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
        int oldCount = songList.size();
        this.updatePlaylist();
        if (fireEvent) {
            this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.MULTIPLE_SONGS_ADDED, Integer.toString(songList.size()));
        }
        return oldCount < songList.size();
    }

    @Override
    public void addFileOrDirectory(MPDFile file) throws MPDPlaylistException {
        try {
            this.commandExecutor.sendCommand(this.playlistProperties.getAdd(), file.getPath());
        }
        catch (MPDResponseException re) {
            throw new MPDPlaylistException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
        this.updatePlaylist();
        this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.FILE_ADDED, file.getName());
    }

    @Override
    public void removeSong(MPDSong song) throws MPDPlaylistException {
        try {
            if (song.getId() > -1) {
                this.commandExecutor.sendCommand(this.playlistProperties.getRemoveId(), song.getId());
            } else if (song.getPosition() > -1) {
                this.commandExecutor.sendCommand(this.playlistProperties.getRemove(), song.getPosition());
            }
        }
        catch (MPDResponseException re) {
            throw new MPDPlaylistException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
        this.updatePlaylist();
    }

    @Override
    public MPDSong getCurrentSong() throws MPDPlaylistException {
        try {
            List<MPDSong> songs = this.convertResponseToSong(this.commandExecutor.sendCommand(this.playlistProperties.getCurrentSong()));
            return songs.isEmpty() ? null : songs.get(0);
        }
        catch (MPDResponseException re) {
            throw new MPDPlaylistException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
    }

    private List<MPDSong> convertResponseToSong(List<String> response) {
        return MPDSongConverter.convertResponseToSong(response);
    }

    @Override
    public void clearPlaylist() throws MPDPlaylistException {
        try {
            this.commandExecutor.sendCommand(this.playlistProperties.getClear());
        }
        catch (MPDResponseException re) {
            throw new MPDPlaylistException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
        this.updatePlaylist();
    }

    @Override
    public void deletePlaylist(MPDSavedPlaylist playlist) throws MPDPlaylistException {
        this.deletePlaylist(playlist.getName());
    }

    @Override
    public void deletePlaylist(String playlistName) throws MPDPlaylistException {
        try {
            this.commandExecutor.sendCommand(this.playlistProperties.getDelete(), playlistName);
        }
        catch (MPDResponseException re) {
            throw new MPDPlaylistException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
        this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.PLAYLIST_DELETED);
    }

    @Override
    public void move(MPDSong song, int to) throws MPDPlaylistException {
        String[] paramList = new String[2];
        try {
            paramList[1] = Integer.toString(to);
            if (song.getId() > -1) {
                this.commandExecutor.sendCommand(this.playlistProperties.getMoveId(), song.getId());
            } else if (song.getPosition() > -1) {
                this.commandExecutor.sendCommand(this.playlistProperties.getMoveId(), song.getPosition());
            }
        }
        catch (MPDResponseException re) {
            throw new MPDPlaylistException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
        this.updatePlaylist();
    }

    @Override
    public void shuffle() throws MPDPlaylistException {
        try {
            this.commandExecutor.sendCommand(this.playlistProperties.getShuffle());
        }
        catch (MPDResponseException re) {
            throw new MPDPlaylistException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
        this.updatePlaylist();
    }

    @Override
    public void swap(MPDSong song1, MPDSong song2) throws MPDPlaylistException {
        try {
            if (song1.getId() > -1 && song2.getId() > -1) {
                this.commandExecutor.sendCommand(this.playlistProperties.getSwapId(), song1.getId(), song2.getId());
            } else if (song1.getPosition() > -1 && song2.getPosition() > -1) {
                this.commandExecutor.sendCommand(this.playlistProperties.getSwap(), song1.getPosition(), song2.getPosition());
            }
        }
        catch (MPDResponseException re) {
            throw new MPDPlaylistException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
        this.updatePlaylist();
    }

    @Override
    public boolean savePlaylist(String playlistName) throws MPDPlaylistException {
        if (playlistName != null) {
            try {
                this.commandExecutor.sendCommand(this.playlistProperties.getSave(), playlistName);
                this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.PLAYLIST_SAVED);
            }
            catch (MPDResponseException re) {
                throw new MPDPlaylistException(re.getMessage(), re.getCommand(), re);
            }
            catch (Exception e) {
                throw new MPDPlaylistException(e);
            }
            return true;
        }
        throw new MPDPlaylistException("Playlist name hasn't been set!");
    }

    private void updatePlaylist() throws MPDPlaylistException {
        this.setVersion(this.getPlaylistVersion());
        if (this.getPlaylistVersion() != this.oldVersion) {
            this.oldVersion = this.getVersion();
            this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.PLAYLIST_CHANGED);
        }
    }

    private int getPlaylistVersion() throws MPDPlaylistException {
        try {
            return this.serverStatus.getPlaylistVersion();
        }
        catch (MPDResponseException re) {
            throw new MPDPlaylistException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
    }

    private List<MPDSong> listSongs() throws MPDPlaylistException {
        try {
            return this.convertResponseToSong(this.commandExecutor.sendCommand(this.playlistProperties.getInfo()));
        }
        catch (MPDResponseException re) {
            throw new MPDPlaylistException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
    }

    @Override
    public void insertAlbum(MPDArtist artist, MPDAlbum album) throws MPDPlaylistException {
        try {
            for (MPDSong song : this.getDatabase().findAlbumByArtist(artist, album)) {
                this.addSong(song, false);
            }
            this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.ALBUM_ADDED, album.getName());
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
    }

    @Override
    public void insertAlbum(MPDAlbum album) throws MPDPlaylistException {
        try {
            for (MPDSong song : this.getDatabase().findAlbum(album)) {
                this.addSong(song, false);
            }
            this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.ALBUM_ADDED, album.getName());
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
    }

    @Override
    public void removeAlbum(MPDArtist artist, MPDAlbum album) throws MPDPlaylistException {
        ArrayList<MPDSong> removeList = new ArrayList<MPDSong>();
        for (MPDSong song : this.getSongList()) {
            if (!song.getArtistName().equals(artist.getName()) || !song.getAlbumName().equals(album.getName())) continue;
            removeList.add(song);
        }
        for (MPDSong song : removeList) {
            this.removeSong(song);
        }
    }

    @Override
    public void insertArtist(MPDArtist artist) throws MPDPlaylistException {
        try {
            for (MPDSong song : this.getDatabase().findArtist(artist)) {
                this.addSong(song, false);
            }
            this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.ARTIST_ADDED, artist.getName());
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
    }

    @Override
    public void insertGenre(MPDGenre genre) throws MPDPlaylistException {
        try {
            for (MPDSong song : this.getDatabase().findGenre(genre)) {
                this.addSong(song, false);
            }
            this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.GENRE_ADDED, genre.getName());
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
    }

    @Override
    public void insertYear(String year) throws MPDPlaylistException {
        try {
            for (MPDSong song : this.getDatabase().findYear(year)) {
                this.addSong(song, false);
            }
            this.firePlaylistChangeEvent(PlaylistChangeEvent.Event.YEAR_ADDED, year);
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
    }

    @Override
    public void removeArtist(MPDArtist artist) throws MPDPlaylistException {
        ArrayList<MPDSong> removeList = new ArrayList<MPDSong>();
        for (MPDSong song : this.getSongList()) {
            if (song.getArtistName().equals(artist.getName())) {
                removeList.add(song);
            }
            removeList.add(song);
        }
        for (MPDSong song : removeList) {
            this.removeSong(song);
        }
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(Database database) {
        this.database = database;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    private void setVersion(int version) {
        this.version = version;
    }

    @Override
    public List<MPDSong> getSongList() throws MPDPlaylistException {
        return this.listSongs();
    }

    @Override
    public String toString() {
        return "Version:" + this.getVersion() + "\n";
    }

    @Override
    public void swap(MPDSong song, int i) throws MPDPlaylistException {
        try {
            this.commandExecutor.sendCommand(this.playlistProperties.getSwapId(), song.getId(), i);
        }
        catch (MPDResponseException re) {
            throw new MPDPlaylistException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDPlaylistException(e);
        }
        this.updatePlaylist();
    }
}

