/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.bff.javampd.CommandExecutor;
import org.bff.javampd.MPDSongConverter;
import org.bff.javampd.Player;
import org.bff.javampd.ServerStatus;
import org.bff.javampd.events.PlayerChangeEvent;
import org.bff.javampd.events.PlayerChangeListener;
import org.bff.javampd.events.VolumeChangeDelegate;
import org.bff.javampd.events.VolumeChangeListener;
import org.bff.javampd.exception.MPDPlayerException;
import org.bff.javampd.exception.MPDResponseException;
import org.bff.javampd.objects.MPDAudioInfo;
import org.bff.javampd.objects.MPDSong;
import org.bff.javampd.properties.PlayerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPDPlayer
implements Player {
    private int oldVolume;
    private List<PlayerChangeListener> listeners = new ArrayList<PlayerChangeListener>();
    private VolumeChangeDelegate volumeChangeDelegate;
    private Player.Status status = Player.Status.STATUS_STOPPED;
    @Inject
    private ServerStatus serverStatus;
    @Inject
    private PlayerProperties playerProperties;
    @Inject
    private CommandExecutor commandExecutor;
    private static final Logger LOGGER = LoggerFactory.getLogger(MPDPlayer.class);

    public MPDPlayer() {
        this.volumeChangeDelegate = new VolumeChangeDelegate();
    }

    @Override
    public MPDSong getCurrentSong() throws MPDPlayerException {
        try {
            List<MPDSong> songList = MPDSongConverter.convertResponseToSong(this.commandExecutor.sendCommand(this.playerProperties.getCurrentSong()));
            if (songList.isEmpty()) {
                return null;
            }
            return songList.get(0);
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDPlayerException(e);
        }
    }

    @Override
    public synchronized void addPlayerChangeListener(PlayerChangeListener pcl) {
        this.listeners.add(pcl);
    }

    @Override
    public synchronized void removePlayerChangedListener(PlayerChangeListener pcl) {
        this.listeners.remove(pcl);
    }

    protected synchronized void firePlayerChangeEvent(PlayerChangeEvent.Event event) {
        PlayerChangeEvent pce = new PlayerChangeEvent(this, event);
        for (PlayerChangeListener pcl : this.listeners) {
            pcl.playerChanged(pce);
        }
    }

    @Override
    public synchronized void addVolumeChangeListener(VolumeChangeListener vcl) {
        this.volumeChangeDelegate.addVolumeChangeListener(vcl);
    }

    @Override
    public synchronized void removeVolumeChangedListener(VolumeChangeListener vcl) {
        this.volumeChangeDelegate.removeVolumeChangedListener(vcl);
    }

    protected synchronized void fireVolumeChangeEvent(int volume) {
        this.volumeChangeDelegate.fireVolumeChangeEvent(this, volume);
    }

    @Override
    public void play() throws MPDPlayerException {
        this.playId(null);
    }

    @Override
    public void playId(MPDSong song) throws MPDPlayerException {
        try {
            if (song == null) {
                this.commandExecutor.sendCommand(this.playerProperties.getPlay());
            } else {
                this.commandExecutor.sendCommand(this.playerProperties.getPlayId(), song.getId());
            }
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDPlayerException(e);
        }
        if (this.status == Player.Status.STATUS_STOPPED || this.status == Player.Status.STATUS_PAUSED) {
            this.status = Player.Status.STATUS_PLAYING;
            this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_STARTED);
        } else {
            this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_SONG_SET);
        }
    }

    @Override
    public void seek(long secs) throws MPDPlayerException {
        this.seekId(null, secs);
    }

    @Override
    public void seekId(MPDSong song, long secs) throws MPDPlayerException {
        List<String> response = null;
        String[] params = new String[2];
        params[2] = Long.toString(secs);
        if (song == null) {
            if ((long)this.getCurrentSong().getLength() > secs) {
                params[1] = Integer.toString(this.getCurrentSong().getId());
                try {
                    response = this.commandExecutor.sendCommand(this.playerProperties.getSeekId(), params);
                }
                catch (MPDResponseException re) {
                    throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
                }
            }
        } else if ((long)song.getLength() >= secs) {
            params[1] = Integer.toString(song.getId());
            try {
                response = this.commandExecutor.sendCommand(this.playerProperties.getSeekId(), params);
            }
            catch (MPDResponseException re) {
                throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
            }
        }
        if (response != null) {
            this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_SEEKING);
        }
    }

    @Override
    public void stop() throws MPDPlayerException {
        try {
            this.commandExecutor.sendCommand(this.playerProperties.getStop());
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
        this.status = Player.Status.STATUS_STOPPED;
        this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_STOPPED);
    }

    @Override
    public void pause() throws MPDPlayerException {
        try {
            this.commandExecutor.sendCommand(this.playerProperties.getPause());
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
        this.status = Player.Status.STATUS_PAUSED;
        this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_PAUSED);
    }

    @Override
    public void playNext() throws MPDPlayerException {
        try {
            this.commandExecutor.sendCommand(this.playerProperties.getNext());
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
        this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_NEXT);
    }

    @Override
    public void playPrev() throws MPDPlayerException {
        try {
            this.commandExecutor.sendCommand(this.playerProperties.getPrevious());
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
        this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_PREVIOUS);
    }

    @Override
    public void mute() throws MPDPlayerException {
        this.oldVolume = this.getVolume();
        this.setVolume(0);
        this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_MUTED);
    }

    @Override
    public void unMute() throws MPDPlayerException {
        this.setVolume(this.oldVolume);
        this.firePlayerChangeEvent(PlayerChangeEvent.Event.PLAYER_UNMUTED);
    }

    @Override
    public int getBitrate() throws MPDPlayerException {
        try {
            return this.serverStatus.getBitrate();
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
    }

    @Override
    public int getVolume() throws MPDPlayerException {
        try {
            return this.serverStatus.getVolume();
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
    }

    @Override
    public void setVolume(int volume) throws MPDPlayerException {
        if (volume < 0 || volume > 100) {
            throw new MPDPlayerException("Volume not in allowable range");
        }
        try {
            this.commandExecutor.sendCommand(this.playerProperties.getSetVolume(), volume);
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
        this.fireVolumeChangeEvent(volume);
    }

    @Override
    public boolean isRepeat() throws MPDPlayerException {
        try {
            return this.serverStatus.isRepeat();
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
    }

    @Override
    public void setRepeat(boolean shouldRepeat) throws MPDPlayerException {
        String repeat = shouldRepeat ? "1" : "0";
        try {
            this.commandExecutor.sendCommand(this.playerProperties.getRepeat(), repeat);
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
    }

    @Override
    public boolean isRandom() throws MPDPlayerException {
        try {
            return this.serverStatus.isRandom();
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
    }

    @Override
    public void setRandom(boolean shouldRandom) throws MPDPlayerException {
        String random = shouldRandom ? "1" : "0";
        try {
            this.commandExecutor.sendCommand(this.playerProperties.getRandom(), random);
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
    }

    @Override
    public void randomizePlay() throws MPDPlayerException {
        this.setRandom(true);
    }

    @Override
    public void unRandomizePlay() throws MPDPlayerException {
        this.setRandom(false);
    }

    @Override
    public int getXFade() throws MPDPlayerException {
        try {
            return Integer.parseInt(this.serverStatus.getXFade());
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
    }

    @Override
    public void setXFade(int xFade) throws MPDPlayerException {
        try {
            this.commandExecutor.sendCommand(this.playerProperties.getXFade(), xFade);
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
    }

    @Override
    public long getElapsedTime() throws MPDPlayerException {
        try {
            return this.serverStatus.getTime();
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
    }

    @Override
    public MPDAudioInfo getAudioDetails() throws MPDPlayerException {
        MPDAudioInfo info = null;
        try {
            String response = this.serverStatus.getAudio();
            if (response != null) {
                info = new MPDAudioInfo();
                String[] split = response.split(":");
                this.parseSampleRate(info, split[0]);
                this.parseBitRate(info, split[1]);
                this.parseChannels(info, split[2]);
            }
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
        return info;
    }

    private void parseSampleRate(MPDAudioInfo info, String sampleRate) {
        try {
            info.setSampleRate(Integer.parseInt(sampleRate));
        }
        catch (NumberFormatException nfe) {
            LOGGER.error("Could not format sample rate", (Throwable)nfe);
            info.setSampleRate(-1);
        }
    }

    @Override
    public Player.Status getStatus() throws MPDPlayerException {
        String currentStatus = null;
        try {
            currentStatus = this.serverStatus.getState();
        }
        catch (MPDResponseException re) {
            throw new MPDPlayerException(re.getMessage(), re.getCommand(), re);
        }
        if (currentStatus.equalsIgnoreCase(Player.Status.STATUS_PLAYING.getPrefix())) {
            return Player.Status.STATUS_PLAYING;
        }
        if (currentStatus.equalsIgnoreCase(Player.Status.STATUS_PAUSED.getPrefix())) {
            return Player.Status.STATUS_PAUSED;
        }
        return Player.Status.STATUS_STOPPED;
    }

    private void parseChannels(MPDAudioInfo info, String channels) {
        try {
            info.setChannels(Integer.parseInt(channels));
        }
        catch (NumberFormatException nfe) {
            LOGGER.error("Could not format channels", (Throwable)nfe);
            info.setChannels(-1);
        }
    }

    private void parseBitRate(MPDAudioInfo info, String bitRate) {
        try {
            info.setBits(Integer.parseInt(bitRate));
        }
        catch (NumberFormatException nfe) {
            LOGGER.error("Could not format bits", (Throwable)nfe);
            info.setBits(-1);
        }
    }
}

