/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.bff.javampd.CommandExecutor;
import org.bff.javampd.Database;
import org.bff.javampd.MPDFile;
import org.bff.javampd.MPDSongConverter;
import org.bff.javampd.ServerStatistics;
import org.bff.javampd.Utils;
import org.bff.javampd.exception.MPDDatabaseException;
import org.bff.javampd.exception.MPDResponseException;
import org.bff.javampd.objects.MPDAlbum;
import org.bff.javampd.objects.MPDArtist;
import org.bff.javampd.objects.MPDGenre;
import org.bff.javampd.objects.MPDSavedPlaylist;
import org.bff.javampd.objects.MPDSong;
import org.bff.javampd.properties.DatabaseProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPDDatabase
implements Database {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPDDatabase.class);
    @Inject
    private DatabaseProperties databaseProperties;
    @Inject
    private ServerStatistics serverStatistics;
    @Inject
    private CommandExecutor commandExecutor;

    protected MPDDatabase() {
    }

    @Override
    public Collection<MPDSong> findArtist(MPDArtist artist) throws MPDDatabaseException {
        return this.findArtist(artist.getName());
    }

    @Override
    public Collection<MPDSong> findArtist(String artist) throws MPDDatabaseException {
        return this.find(Database.ScopeType.ARTIST, artist);
    }

    @Override
    public Collection<MPDSong> findGenre(MPDGenre genre) throws MPDDatabaseException {
        return this.findGenre(genre.getName());
    }

    @Override
    public Collection<MPDSong> findGenre(String genre) throws MPDDatabaseException {
        return this.find(Database.ScopeType.GENRE, genre);
    }

    @Override
    public Collection<MPDSong> findYear(String year) throws MPDDatabaseException {
        return this.find(Database.ScopeType.DATE, year);
    }

    @Override
    public Collection<MPDSong> findAlbum(MPDAlbum album) throws MPDDatabaseException {
        return this.findAlbum(album.getName());
    }

    @Override
    public Collection<MPDSong> findAlbum(String album) throws MPDDatabaseException {
        return this.find(Database.ScopeType.ALBUM, album);
    }

    @Override
    public Collection<MPDSong> findAlbumByArtist(MPDArtist artist, MPDAlbum album) throws MPDDatabaseException {
        ArrayList<MPDSong> retList = new ArrayList<MPDSong>();
        ArrayList<MPDSong> songList = new ArrayList<MPDSong>(this.find(Database.ScopeType.ALBUM, album.getName()));
        for (MPDSong song : songList) {
            if (song.getArtistName() == null || !song.getArtistName().equals(artist.getName())) continue;
            retList.add(song);
        }
        return retList;
    }

    @Override
    public Collection<MPDSong> findAlbumByGenre(MPDGenre genre, MPDAlbum album) throws MPDDatabaseException {
        ArrayList<MPDSong> retList = new ArrayList<MPDSong>();
        ArrayList<MPDSong> songList = new ArrayList<MPDSong>(this.find(Database.ScopeType.ALBUM, album.getName()));
        for (MPDSong song : songList) {
            if (song.getGenre() == null || !song.getGenre().equals(genre.getName())) continue;
            retList.add(song);
        }
        return retList;
    }

    @Override
    public Collection<MPDSong> findAlbumByYear(String year, MPDAlbum album) throws MPDDatabaseException {
        ArrayList<MPDSong> retList = new ArrayList<MPDSong>();
        ArrayList<MPDSong> songList = new ArrayList<MPDSong>(this.find(Database.ScopeType.ALBUM, album.getName()));
        for (MPDSong song : songList) {
            if (song.getYear() == null || !song.getYear().equals(year)) continue;
            retList.add(song);
        }
        return retList;
    }

    @Override
    public Collection<MPDSong> findTitle(String title) throws MPDDatabaseException {
        return this.find(Database.ScopeType.TITLE, title);
    }

    @Override
    public Collection<MPDSong> findAny(String criteria) throws MPDDatabaseException {
        return this.find(Database.ScopeType.ANY, criteria);
    }

    @Override
    public Collection<String> listAllFiles() throws MPDDatabaseException {
        try {
            return this.commandExecutor.sendCommand(this.databaseProperties.getListAll());
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
    }

    @Override
    public Collection<String> listAllFiles(String path) throws MPDDatabaseException {
        try {
            return this.commandExecutor.sendCommand(this.databaseProperties.getListAll());
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
    }

    @Override
    public Collection<String> listAllSongFiles() throws MPDDatabaseException {
        List<String> fileList;
        try {
            fileList = this.commandExecutor.sendCommand(this.databaseProperties.getListAll());
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
        return MPDSongConverter.getSongNameList(fileList);
    }

    @Override
    public Collection<String> listAllSongFiles(String path) throws MPDDatabaseException {
        List<String> fileList;
        try {
            fileList = this.commandExecutor.sendCommand(this.databaseProperties.getListAll(), path);
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
        return MPDSongConverter.getSongNameList(fileList);
    }

    @Override
    public Collection<MPDSong> listAllSongs() throws MPDDatabaseException {
        List<String> songList;
        try {
            songList = this.commandExecutor.sendCommand(this.databaseProperties.getListAllInfo());
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
        return new ArrayList<MPDSong>(this.convertResponseToSong(songList));
    }

    @Override
    public Collection<MPDSong> listAllSongs(String path) throws MPDDatabaseException {
        List<String> songList;
        try {
            songList = this.commandExecutor.sendCommand(this.databaseProperties.getListAllInfo(), path);
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
        return new ArrayList<MPDSong>(this.convertResponseToSong(songList));
    }

    private List<MPDSong> convertResponseToSong(List<String> songList) {
        return MPDSongConverter.convertResponseToSong(songList);
    }

    @Override
    public Collection<MPDSong> searchArtist(MPDArtist artist) throws MPDDatabaseException {
        return this.searchArtist(artist.getName());
    }

    @Override
    public Collection<MPDSong> searchArtist(String artist) throws MPDDatabaseException {
        return this.search(Database.ScopeType.ARTIST, artist);
    }

    @Override
    public Collection<MPDSong> searchAlbum(MPDAlbum album) throws MPDDatabaseException {
        return this.searchAlbum(album.getName());
    }

    @Override
    public Collection<MPDSong> searchAlbum(String album) throws MPDDatabaseException {
        return this.search(Database.ScopeType.ALBUM, album);
    }

    @Override
    public Collection<MPDSong> searchTitle(String title) throws MPDDatabaseException {
        return this.search(Database.ScopeType.TITLE, title);
    }

    @Override
    public Collection<MPDSong> searchAny(String criteria) throws MPDDatabaseException {
        return this.search(Database.ScopeType.ANY, criteria);
    }

    @Override
    public Collection<MPDSong> searchTitle(String title, int startYear, int endYear) throws MPDDatabaseException {
        ArrayList<MPDSong> retList = new ArrayList<MPDSong>();
        for (MPDSong song : this.search(Database.ScopeType.TITLE, title)) {
            if (song.getYear() == null) continue;
            try {
                int year = song.getYear().contains("-") ? Integer.parseInt(song.getYear().split("-")[0]) : Integer.parseInt(song.getYear());
                if (year < startYear || year > endYear) continue;
                retList.add(song);
            }
            catch (Exception e) {
                LOGGER.error("Problem searching for title", (Throwable)e);
            }
        }
        return retList;
    }

    @Override
    public Collection<MPDSong> searchFileName(String fileName) throws MPDDatabaseException {
        return this.search(Database.ScopeType.FILENAME, Utils.removeSlashes(fileName));
    }

    @Override
    public Collection<MPDAlbum> listAllAlbums() throws MPDDatabaseException {
        ArrayList<MPDAlbum> albums = new ArrayList<MPDAlbum>();
        for (MPDArtist artist : this.listAllArtists()) {
            albums.addAll(this.listAlbumsByArtist(artist));
        }
        Collections.sort(albums, new Comparator<MPDAlbum>(){

            @Override
            public int compare(MPDAlbum one, MPDAlbum other) {
                return one.getName().compareTo(other.getName());
            }
        });
        return albums;
    }

    @Override
    public Collection<MPDArtist> listAllArtists() throws MPDDatabaseException {
        ArrayList<MPDArtist> artists = new ArrayList<MPDArtist>();
        for (String str : this.list(Database.ListType.ARTIST)) {
            artists.add(new MPDArtist(str));
        }
        return artists;
    }

    @Override
    public Collection<MPDGenre> listAllGenres() throws MPDDatabaseException {
        ArrayList<MPDGenre> genres = new ArrayList<MPDGenre>();
        for (String str : this.list(Database.ListType.GENRE)) {
            genres.add(new MPDGenre(str));
        }
        return genres;
    }

    @Override
    public Collection<MPDAlbum> listAlbumsByArtist(MPDArtist artist) throws MPDDatabaseException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(artist.getName());
        ArrayList<MPDAlbum> albums = new ArrayList<MPDAlbum>();
        for (String str : this.list(Database.ListType.ALBUM, list)) {
            MPDAlbum album = new MPDAlbum(str);
            album.setArtistName(artist.getName());
            albums.add(album);
        }
        return albums;
    }

    @Override
    public Collection<MPDAlbum> listAlbumsByGenre(MPDGenre genre) throws MPDDatabaseException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Database.ListType.GENRE.getType());
        list.add(genre.getName());
        ArrayList<MPDAlbum> albums = new ArrayList<MPDAlbum>();
        for (String str : this.list(Database.ListType.ALBUM, list)) {
            albums.add(new MPDAlbum(str));
        }
        return albums;
    }

    @Override
    public Collection<MPDArtist> listArtistsByGenre(MPDGenre genre) throws MPDDatabaseException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Database.ListType.GENRE.getType());
        list.add(genre.getName());
        ArrayList<MPDArtist> artists = new ArrayList<MPDArtist>();
        for (String str : this.list(Database.ListType.ARTIST, list)) {
            artists.add(new MPDArtist(str));
        }
        return artists;
    }

    @Override
    public Collection<MPDAlbum> listAlbumsByYear(String year) throws MPDDatabaseException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Database.ListType.DATE.getType());
        list.add(year);
        ArrayList<MPDAlbum> albums = new ArrayList<MPDAlbum>();
        for (String str : this.list(Database.ListType.ALBUM, list)) {
            albums.add(new MPDAlbum(str));
        }
        return albums;
    }

    private Collection<String> listInfo(Database.ListInfoType ... types) throws MPDDatabaseException {
        List<String> list;
        ArrayList<String> returnList = new ArrayList<String>();
        try {
            list = this.commandExecutor.sendCommand(this.databaseProperties.getListInfo());
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
        for (String s : list) {
            for (Database.ListInfoType type : types) {
                if (!s.startsWith(type.getPrefix())) continue;
                returnList.add(s.substring(type.getPrefix().length()).trim());
            }
        }
        return returnList;
    }

    @Override
    public Collection<MPDFile> listRootDirectory() throws MPDDatabaseException {
        return this.listDirectory("");
    }

    @Override
    public Collection<MPDFile> listDirectory(MPDFile directory) throws MPDDatabaseException {
        if (directory.isDirectory()) {
            return this.listDirectory(directory.getPath());
        }
        throw new MPDDatabaseException(directory.getName() + " is not a directory.");
    }

    private Collection<MPDFile> listDirectory(String directory) throws MPDDatabaseException {
        return this.listDirectoryInfo(directory);
    }

    private Collection<MPDFile> listDirectoryInfo(String directory) throws MPDDatabaseException {
        List<String> list;
        ArrayList<MPDFile> returnList = new ArrayList<MPDFile>();
        try {
            list = this.commandExecutor.sendCommand(this.databaseProperties.getListInfo(), directory);
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
        for (String s : list) {
            if (!s.startsWith(Database.ListInfoType.FILE.getPrefix()) && !s.startsWith(Database.ListInfoType.DIRECTORY.getPrefix())) continue;
            MPDFile f = new MPDFile();
            String name = s;
            if (s.startsWith(Database.ListInfoType.FILE.getPrefix())) {
                f.setDirectory(false);
                name = name.substring(Database.ListInfoType.FILE.getPrefix().length()).trim();
            } else {
                f.setDirectory(true);
                name = name.substring(Database.ListInfoType.DIRECTORY.getPrefix().length()).trim();
            }
            f.setName(name);
            f.setPath(name);
            returnList.add(f);
        }
        return returnList;
    }

    private Collection<String> list(Database.ListType listType) throws MPDDatabaseException {
        return this.list(listType, null);
    }

    private Collection<String> list(Database.ListType listType, List<String> params) throws MPDDatabaseException {
        List<String> responseList;
        int i = 0;
        String[] paramList = params != null ? new String[params.size() + 1] : new String[1];
        paramList[i++] = listType.getType();
        if (params != null) {
            for (String s : params) {
                paramList[i++] = s;
            }
        }
        try {
            responseList = this.commandExecutor.sendCommand(this.databaseProperties.getList(), paramList);
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
        ArrayList<String> retList = new ArrayList<String>();
        for (String s : responseList) {
            try {
                retList.add(s.substring(s.split(":")[0].length() + 1).trim());
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOGGER.error("Problem with response array {}", (Object)s, (Object)e);
                retList.add("");
            }
        }
        return retList;
    }

    @Override
    public Collection<MPDSong> search(Database.ScopeType searchType, String param) throws MPDDatabaseException {
        List<String> titleList;
        String[] paramList;
        if (param != null) {
            paramList = new String[2];
            paramList[1] = param;
        } else {
            paramList = new String[]{searchType.getType()};
        }
        try {
            titleList = this.commandExecutor.sendCommand(this.databaseProperties.getSearch(), paramList);
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
        return this.convertResponseToSong(titleList);
    }

    @Override
    public Collection<MPDSong> find(Database.ScopeType scopeType, String param) throws MPDDatabaseException {
        List<String> titleList;
        String[] paramList;
        if (param != null) {
            paramList = new String[2];
            paramList[1] = param;
        } else {
            paramList = new String[]{scopeType.getType()};
        }
        try {
            titleList = this.commandExecutor.sendCommand(this.databaseProperties.getFind(), paramList);
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
        return this.convertResponseToSong(titleList);
    }

    @Override
    public int getArtistCount() throws MPDDatabaseException {
        try {
            return this.serverStatistics.getArtists();
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
    }

    @Override
    public int getAlbumCount() throws MPDDatabaseException {
        try {
            return this.serverStatistics.getAlbums();
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
    }

    @Override
    public int getSongCount() throws MPDDatabaseException {
        try {
            return this.serverStatistics.getSongs();
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
    }

    @Override
    public long getDbPlayTime() throws MPDDatabaseException {
        try {
            return this.serverStatistics.getDatabasePlaytime();
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
    }

    @Override
    public long getLastUpdateTime() throws MPDDatabaseException {
        try {
            return this.serverStatistics.getDatabaseUpdateTime();
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
    }

    @Override
    public Collection<MPDSavedPlaylist> listSavedPlaylists() throws MPDDatabaseException {
        ArrayList<MPDSavedPlaylist> playlists = new ArrayList<MPDSavedPlaylist>();
        for (String s : this.listPlaylists()) {
            MPDSavedPlaylist playlist = new MPDSavedPlaylist(s);
            playlist.setSongs(this.listPlaylistSongs(s));
            playlists.add(playlist);
        }
        return playlists;
    }

    @Override
    public Collection<String> listPlaylists() throws MPDDatabaseException {
        try {
            return this.listInfo(Database.ListInfoType.PLAYLIST);
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
    }

    @Override
    public Collection<MPDSong> listPlaylistSongs(String playlistName) throws MPDDatabaseException {
        ArrayList<MPDSong> songList = new ArrayList<MPDSong>();
        try {
            List<String> response = this.commandExecutor.sendCommand(this.databaseProperties.getListSongs(), playlistName);
            for (String song : MPDSongConverter.getSongNameList(response)) {
                songList.add(new ArrayList<MPDSong>(this.searchFileName(song)).get(0));
            }
        }
        catch (MPDResponseException re) {
            throw new MPDDatabaseException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDDatabaseException(e);
        }
        return songList;
    }

    @Override
    public Collection<String> listAllYears() throws MPDDatabaseException {
        ArrayList<String> retList = new ArrayList<String>();
        for (String str : this.list(Database.ListType.DATE)) {
            if (str.contains("-")) {
                str = str.split("-")[0];
            }
            if (retList.contains(str)) continue;
            retList.add(str);
        }
        Collections.sort(retList);
        return retList;
    }
}

