/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd;

import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bff.javampd.CommandExecutor;
import org.bff.javampd.MPD;
import org.bff.javampd.MPDCommand;
import org.bff.javampd.MPDSocket;
import org.bff.javampd.exception.MPDConnectionException;
import org.bff.javampd.exception.MPDResponseException;

@Singleton
public class MPDCommandExecutor
implements CommandExecutor {
    private MPDSocket mpdSocket;
    private MPD mpd;

    @Override
    public synchronized List<String> sendCommand(String command) throws MPDResponseException {
        return new ArrayList<String>(this.sendCommand(new MPDCommand(command, new String[0])));
    }

    @Override
    public synchronized List<String> sendCommand(String command, String ... params) throws MPDResponseException {
        return new ArrayList<String>(this.sendCommand(new MPDCommand(command, params)));
    }

    @Override
    public synchronized List<String> sendCommand(String command, Integer ... params) throws MPDResponseException {
        String[] intParms = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            intParms[i] = Integer.toString(params[i]);
        }
        return new ArrayList<String>(this.sendCommand(new MPDCommand(command, intParms)));
    }

    @Override
    public synchronized Collection<String> sendCommand(MPDCommand command) throws MPDResponseException {
        try {
            this.checkSocket();
        }
        catch (MPDConnectionException e) {
            throw new MPDResponseException(e);
        }
        return this.mpdSocket.sendCommand(command);
    }

    @Override
    public synchronized boolean sendCommands(List<MPDCommand> commandList) throws MPDResponseException {
        try {
            this.checkSocket();
        }
        catch (MPDConnectionException e) {
            throw new MPDResponseException(e);
        }
        return this.mpdSocket.sendCommands(commandList);
    }

    private void checkSocket() throws MPDConnectionException {
        if (this.mpd == null) {
            throw new MPDConnectionException("Socket could not be established.  Was mpd set?");
        }
        if (this.mpdSocket == null) {
            this.mpdSocket = new MPDSocket(this.mpd.getAddress(), this.mpd.getPort(), this.mpd.getTimeout());
        }
    }

    @Override
    public String getMPDVersion() throws MPDResponseException {
        try {
            this.checkSocket();
        }
        catch (MPDConnectionException e) {
            throw new MPDResponseException(e);
        }
        return this.mpdSocket.getVersion();
    }

    @Override
    public void setMpd(MPD mpd) throws MPDConnectionException {
        this.mpd = mpd;
    }
}

