/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.bff.javampd.Admin;
import org.bff.javampd.CommandExecutor;
import org.bff.javampd.MPDOutput;
import org.bff.javampd.ServerStatistics;
import org.bff.javampd.events.MPDChangeEvent;
import org.bff.javampd.events.MPDChangeListener;
import org.bff.javampd.events.OutputChangeEvent;
import org.bff.javampd.events.OutputChangeListener;
import org.bff.javampd.exception.MPDAdminException;
import org.bff.javampd.exception.MPDException;
import org.bff.javampd.exception.MPDResponseException;
import org.bff.javampd.properties.AdminProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPDAdmin
implements Admin {
    private static final Logger LOGGER = LoggerFactory.getLogger(MPDAdmin.class);
    private List<MPDChangeListener> listeners = new ArrayList<MPDChangeListener>();
    private List<OutputChangeListener> outputListeners = new ArrayList<OutputChangeListener>();
    protected static final String OUTPUT_PREFIX_ID = "outputid:";
    protected static final String OUTPUT_PREFIX_NAME = "outputname:";
    protected static final String OUTPUT_PREFIX_ENABLED = "outputenabled:";
    @Inject
    private AdminProperties adminProperties;
    @Inject
    private ServerStatistics serverStatistics;
    @Inject
    private CommandExecutor commandExecutor;

    @Override
    public Collection<MPDOutput> getOutputs() throws MPDAdminException {
        try {
            return new ArrayList<MPDOutput>(this.parseOutputs(this.commandExecutor.sendCommand(this.adminProperties.getOutputs())));
        }
        catch (MPDException e) {
            LOGGER.error("Could not get outputs", (Throwable)e);
            throw new MPDAdminException(e);
        }
    }

    @Override
    public boolean disableOutput(MPDOutput output) throws MPDAdminException {
        this.fireOutputChangeEvent(OutputChangeEvent.OUTPUT_EVENT.OUTPUT_CHANGED);
        try {
            return this.commandExecutor.sendCommand(this.adminProperties.getOutputDisable(), output.getId()).isEmpty();
        }
        catch (MPDException e) {
            LOGGER.error("Could not disable output {}", (Object)output, (Object)e);
            throw new MPDAdminException(e);
        }
    }

    @Override
    public boolean enableOutput(MPDOutput output) throws MPDAdminException {
        this.fireOutputChangeEvent(OutputChangeEvent.OUTPUT_EVENT.OUTPUT_CHANGED);
        try {
            return this.commandExecutor.sendCommand(this.adminProperties.getOutputEnable(), output.getId()).isEmpty();
        }
        catch (MPDException e) {
            LOGGER.error("Could not enable output {}", (Object)output, (Object)e);
            throw new MPDAdminException(e);
        }
    }

    private Collection<MPDOutput> parseOutputs(Collection<String> response) {
        ArrayList<MPDOutput> outputs = new ArrayList<MPDOutput>();
        Iterator<String> iter = response.iterator();
        String line = null;
        while (iter.hasNext()) {
            if (line == null || !line.startsWith(OUTPUT_PREFIX_ID)) {
                line = iter.next();
            }
            if (!line.startsWith(OUTPUT_PREFIX_ID)) continue;
            MPDOutput output = new MPDOutput(Integer.parseInt(line.substring(OUTPUT_PREFIX_ID.length()).trim()));
            line = iter.next();
            while (!line.startsWith(OUTPUT_PREFIX_ID)) {
                if (line.startsWith(OUTPUT_PREFIX_NAME)) {
                    output.setName(line.replace(OUTPUT_PREFIX_NAME, "").trim());
                } else if (line.startsWith(OUTPUT_PREFIX_ENABLED)) {
                    output.setEnabled("1".equals(line.replace(OUTPUT_PREFIX_ENABLED, "").trim()));
                }
                if (!iter.hasNext()) break;
                line = iter.next();
            }
            outputs.add(output);
        }
        return outputs;
    }

    @Override
    public synchronized void addMPDChangeListener(MPDChangeListener mcl) {
        this.listeners.add(mcl);
    }

    @Override
    public synchronized void removePlayerChangedListener(MPDChangeListener mcl) {
        this.listeners.remove(mcl);
    }

    protected synchronized void fireMPDChangeEvent(MPDChangeEvent.Event event) {
        MPDChangeEvent mce = new MPDChangeEvent(this, event);
        for (MPDChangeListener mcl : this.listeners) {
            mcl.mpdChanged(mce);
        }
    }

    @Override
    public void killMPD() throws MPDAdminException {
        try {
            this.commandExecutor.sendCommand(this.adminProperties.getKill());
            this.fireMPDChangeEvent(MPDChangeEvent.Event.MPD_KILLED);
        }
        catch (MPDResponseException re) {
            throw new MPDAdminException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDAdminException(e);
        }
    }

    @Override
    public void updateDatabase() throws MPDAdminException {
        try {
            this.commandExecutor.sendCommand(this.adminProperties.getRefresh());
            this.fireMPDChangeEvent(MPDChangeEvent.Event.MPD_REFRESHED);
        }
        catch (MPDResponseException re) {
            throw new MPDAdminException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDAdminException(e);
        }
    }

    @Override
    public void updateDatabase(String path) throws MPDAdminException {
        try {
            this.commandExecutor.sendCommand(this.adminProperties.getRefresh(), path);
            this.fireMPDChangeEvent(MPDChangeEvent.Event.MPD_REFRESHED);
        }
        catch (MPDResponseException re) {
            throw new MPDAdminException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDAdminException(e);
        }
    }

    @Override
    public long getDaemonUpTime() throws MPDAdminException {
        try {
            return this.serverStatistics.getUptime();
        }
        catch (MPDResponseException re) {
            throw new MPDAdminException(re.getMessage(), re.getCommand(), re);
        }
        catch (Exception e) {
            throw new MPDAdminException(e);
        }
    }

    @Override
    public synchronized void addOutputChangeListener(OutputChangeListener pcl) {
        this.outputListeners.add(pcl);
    }

    @Override
    public synchronized void removePlaylistStatusChangedListener(OutputChangeListener pcl) {
        this.outputListeners.remove(pcl);
    }

    protected synchronized void fireOutputChangeEvent(OutputChangeEvent.OUTPUT_EVENT event) {
        OutputChangeEvent oce = new OutputChangeEvent(this, event);
        for (OutputChangeListener pcl : this.outputListeners) {
            pcl.outputChanged(oce);
        }
    }
}

