/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.bff.javampd.Admin;
import org.bff.javampd.CommandExecutor;
import org.bff.javampd.Database;
import org.bff.javampd.MPDModule;
import org.bff.javampd.Player;
import org.bff.javampd.Playlist;
import org.bff.javampd.Server;
import org.bff.javampd.ServerStatistics;
import org.bff.javampd.ServerStatus;
import org.bff.javampd.StandAloneMonitor;
import org.bff.javampd.exception.MPDConnectionException;
import org.bff.javampd.exception.MPDException;
import org.bff.javampd.exception.MPDResponseException;
import org.bff.javampd.monitor.ConnectionMonitor;
import org.bff.javampd.properties.ServerProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPD
implements Server {
    private int port;
    private InetAddress address;
    private int timeout;
    private static final int DEFAULT_PORT = 6600;
    private static final int DEFAULT_TIMEOUT = 0;
    private static final String DEFAULT_SERVER = "localhost";
    private final ServerProperties serverProperties;
    private final CommandExecutor commandExecutor;
    private final Database database;
    private final Player player;
    private final Playlist playlist;
    private final Admin admin;
    private final ServerStatistics serverStatistics;
    private final ServerStatus serverStatus;
    private final StandAloneMonitor standAloneMonitor;
    private static final Logger LOGGER = LoggerFactory.getLogger(MPD.class);

    private MPD(Builder builder) throws MPDConnectionException {
        try {
            this.address = InetAddress.getByName(builder.server);
            this.port = builder.port;
            this.timeout = builder.timeout;
            this.serverProperties = builder.serverProperties;
            this.commandExecutor = builder.commandExecutor;
            this.database = builder.database;
            this.player = builder.player;
            this.playlist = builder.playlist;
            this.admin = builder.admin;
            this.serverStatistics = builder.serverStatistics;
            this.serverStatus = builder.serverStatus;
            this.standAloneMonitor = builder.standAloneMonitor;
            this.commandExecutor.setMpd(this);
            if (builder.password != null) {
                this.authenticate(builder.password);
            }
        }
        catch (Exception e) {
            throw new MPDConnectionException(e);
        }
    }

    @Override
    public void clearerror() throws MPDResponseException {
        this.commandExecutor.sendCommand(this.serverProperties.getClearError());
    }

    @Override
    public void close() throws MPDResponseException {
        this.commandExecutor.sendCommand(this.serverProperties.getClose());
    }

    @Override
    public String getVersion() throws MPDResponseException {
        return this.commandExecutor.getMPDVersion();
    }

    @Override
    public boolean isConnected() {
        return this.ping();
    }

    public void authenticate(String password) throws MPDResponseException {
        this.commandExecutor.sendCommand(this.serverProperties.getPassword(), password);
    }

    private boolean ping() {
        try {
            this.commandExecutor.sendCommand(this.serverProperties.getPing());
        }
        catch (MPDException e) {
            LOGGER.error("Could not ping MPD", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public Playlist getPlaylist() {
        return this.playlist;
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public ServerStatistics getServerStatistics() {
        return this.serverStatistics;
    }

    @Override
    public ServerStatus getServerStatus() {
        return this.serverStatus;
    }

    @Override
    public StandAloneMonitor getMonitor() {
        return this.standAloneMonitor;
    }

    public static class Builder {
        private int port = 6600;
        private String server = "localhost";
        private int timeout = 0;
        private String password;
        private ServerProperties serverProperties;
        private CommandExecutor commandExecutor;
        private Database database;
        private Player player;
        private Playlist playlist;
        private Admin admin;
        private ServerStatistics serverStatistics;
        private ServerStatus serverStatus;
        private StandAloneMonitor standAloneMonitor;
        private Injector injector = Guice.createInjector((Module[])new Module[]{new MPDModule()});

        public Builder() {
            this.bind(this.injector);
            this.bindMonitorAndRelay(this.injector);
        }

        public Builder server(String server) throws UnknownHostException {
            this.server = server;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public MPD build() throws MPDConnectionException {
            MPD mpd = new MPD(this);
            ((ConnectionMonitor)this.injector.getInstance(ConnectionMonitor.class)).setServer(mpd);
            return mpd;
        }

        private void bind(Injector injector) {
            this.serverProperties = (ServerProperties)injector.getInstance(ServerProperties.class);
            this.database = (Database)injector.getInstance(Database.class);
            this.player = (Player)injector.getInstance(Player.class);
            this.playlist = (Playlist)injector.getInstance(Playlist.class);
            this.admin = (Admin)injector.getInstance(Admin.class);
            this.serverStatistics = (ServerStatistics)injector.getInstance(ServerStatistics.class);
            this.serverStatus = (ServerStatus)injector.getInstance(ServerStatus.class);
            this.commandExecutor = (CommandExecutor)injector.getInstance(CommandExecutor.class);
        }

        private void bindMonitorAndRelay(Injector injector) {
            this.standAloneMonitor = (StandAloneMonitor)injector.getInstance(StandAloneMonitor.class);
        }
    }
}

