/*
 * Decompiled with CFR 0.152.
 */
package org.bff.javampd;

import java.util.Collection;
import org.bff.javampd.MPDFile;
import org.bff.javampd.exception.MPDDatabaseException;
import org.bff.javampd.objects.MPDAlbum;
import org.bff.javampd.objects.MPDArtist;
import org.bff.javampd.objects.MPDGenre;
import org.bff.javampd.objects.MPDSavedPlaylist;
import org.bff.javampd.objects.MPDSong;

public interface Database {
    public Collection<MPDSong> findArtist(MPDArtist var1) throws MPDDatabaseException;

    public Collection<MPDSong> findArtist(String var1) throws MPDDatabaseException;

    public Collection<MPDSong> findGenre(MPDGenre var1) throws MPDDatabaseException;

    public Collection<MPDSong> findGenre(String var1) throws MPDDatabaseException;

    public Collection<MPDSong> findYear(String var1) throws MPDDatabaseException;

    public Collection<MPDSong> findAlbum(MPDAlbum var1) throws MPDDatabaseException;

    public Collection<MPDSong> findAlbum(String var1) throws MPDDatabaseException;

    public Collection<MPDSong> findAlbumByArtist(MPDArtist var1, MPDAlbum var2) throws MPDDatabaseException;

    public Collection<MPDSong> findAlbumByGenre(MPDGenre var1, MPDAlbum var2) throws MPDDatabaseException;

    public Collection<MPDSong> findAlbumByYear(String var1, MPDAlbum var2) throws MPDDatabaseException;

    public Collection<MPDSong> findTitle(String var1) throws MPDDatabaseException;

    public Collection<MPDSong> findAny(String var1) throws MPDDatabaseException;

    public Collection<String> listAllFiles() throws MPDDatabaseException;

    public Collection<String> listAllFiles(String var1) throws MPDDatabaseException;

    public Collection<String> listAllSongFiles() throws MPDDatabaseException;

    public Collection<String> listAllSongFiles(String var1) throws MPDDatabaseException;

    public Collection<MPDSong> listAllSongs() throws MPDDatabaseException;

    public Collection<MPDSong> listAllSongs(String var1) throws MPDDatabaseException;

    public Collection<MPDSong> searchArtist(MPDArtist var1) throws MPDDatabaseException;

    public Collection<MPDSong> searchArtist(String var1) throws MPDDatabaseException;

    public Collection<MPDSong> searchAlbum(MPDAlbum var1) throws MPDDatabaseException;

    public Collection<MPDSong> searchAlbum(String var1) throws MPDDatabaseException;

    public Collection<MPDSong> searchTitle(String var1) throws MPDDatabaseException;

    public Collection<MPDSong> searchAny(String var1) throws MPDDatabaseException;

    public Collection<MPDSong> searchTitle(String var1, int var2, int var3) throws MPDDatabaseException;

    public Collection<MPDSong> searchFileName(String var1) throws MPDDatabaseException;

    public Collection<MPDAlbum> listAllAlbums() throws MPDDatabaseException;

    public Collection<MPDArtist> listAllArtists() throws MPDDatabaseException;

    public Collection<MPDGenre> listAllGenres() throws MPDDatabaseException;

    public Collection<MPDAlbum> listAlbumsByArtist(MPDArtist var1) throws MPDDatabaseException;

    public Collection<MPDAlbum> listAlbumsByGenre(MPDGenre var1) throws MPDDatabaseException;

    public Collection<MPDArtist> listArtistsByGenre(MPDGenre var1) throws MPDDatabaseException;

    public Collection<MPDAlbum> listAlbumsByYear(String var1) throws MPDDatabaseException;

    public Collection<MPDFile> listRootDirectory() throws MPDDatabaseException;

    public Collection<MPDFile> listDirectory(MPDFile var1) throws MPDDatabaseException;

    public Collection<MPDSong> search(ScopeType var1, String var2) throws MPDDatabaseException;

    public Collection<MPDSong> find(ScopeType var1, String var2) throws MPDDatabaseException;

    public int getArtistCount() throws MPDDatabaseException;

    public int getAlbumCount() throws MPDDatabaseException;

    public int getSongCount() throws MPDDatabaseException;

    public long getDbPlayTime() throws MPDDatabaseException;

    public long getLastUpdateTime() throws MPDDatabaseException;

    public Collection<MPDSavedPlaylist> listSavedPlaylists() throws MPDDatabaseException;

    public Collection<String> listPlaylists() throws MPDDatabaseException;

    public Collection<MPDSong> listPlaylistSongs(String var1) throws MPDDatabaseException;

    public Collection<String> listAllYears() throws MPDDatabaseException;

    public static enum ListInfoType {
        PLAYLIST("playlist:"),
        DIRECTORY("directory:"),
        FILE("file:");

        private String prefix;

        private ListInfoType(String prefix) {
            this.prefix = prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }

    public static enum ScopeType {
        ALBUM("album"),
        ARTIST("artist"),
        TITLE("title"),
        TRACK("track"),
        NAME("name"),
        GENRE("genre"),
        DATE("date"),
        COMPOSER("composer"),
        PERFORMER("performer"),
        COMMENT("comment"),
        DISC("disc"),
        FILENAME("filename"),
        ANY("any");

        private String type;

        private ScopeType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    public static enum ListType {
        ALBUM("album"),
        ARTIST("artist"),
        GENRE("genre"),
        DATE("date");

        private String type;

        private ListType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

