/*
 * Decompiled with CFR 0.152.
 */
package net.termer.rtflc.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.termer.rtflc.runtime.RtflFunction;
import net.termer.rtflc.runtime.RtflRuntime;
import net.termer.rtflc.runtime.RuntimeException;
import net.termer.rtflc.runtime.Scope;
import net.termer.rtflc.type.NullType;
import net.termer.rtflc.type.RtflType;
import net.termer.rtflc.utils.ClassUtils;

public class RtflFunctionBuilder {
    public static RtflFunction fromStaticMethod(Class<?> clazz, String name, Class<?>[] parameters) throws NoSuchMethodException, SecurityException {
        return new JavaMethodFunction(clazz, name, parameters, null);
    }

    public static RtflFunction fromMethod(Class<?> clazz, String name, Class<?>[] parameters, Object obj) throws NoSuchMethodException, SecurityException {
        return new JavaMethodFunction(clazz, name, parameters, obj);
    }

    public static class JavaMethodFunction
    implements RtflFunction {
        private final Class<?>[] _params;
        private final Object _obj;
        private final Method _method;

        public JavaMethodFunction(Class<?> clazz, String name, Class<?>[] parameters, Object obj) throws NoSuchMethodException, SecurityException {
            this._params = parameters;
            this._obj = obj;
            this._method = clazz.getMethod(name, parameters);
        }

        @Override
        public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
            RtflType result = new NullType();
            ArrayList<Object> jargs = new ArrayList<Object>();
            for (RtflType rt : args) {
                jargs.add(RtflType.toJavaType(rt));
            }
            if (args.length == this._params.length) {
                boolean match = true;
                for (int i = 0; i < args.length; ++i) {
                    if (ClassUtils.classMatches(jargs.get(i).getClass(), this._params[i])) continue;
                    match = false;
                    break;
                }
                if (!match) {
                    throw new RuntimeException("Argument types do not match");
                }
                try {
                    result = RtflType.fromJavaType(this._method.invoke(this._obj, jargs.toArray()));
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                    throw new RuntimeException("Failed to execute method");
                }
            } else {
                throw new RuntimeException("Must provide " + this._params.length + " argument" + (this._params.length == 1 ? "" : Character.valueOf('s')));
            }
            return result;
        }
    }
}

