/*
 * Decompiled with CFR 0.152.
 */
package net.termer.rtflc.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.termer.rtflc.RtflLibrary;

public class LibraryLoader {
    public static RtflLibrary loadLibrary(File jar) throws ClassNotFoundException, IOException {
        JarFile jf;
        RtflLibrary lib = null;
        String launch = null;
        ZipFile zf = new ZipFile(jar.getAbsolutePath());
        if (zf.isValidZipFile()) {
            jf = new JarFile(jar.getAbsolutePath());
            Enumeration<JarEntry> ent = jf.entries();
            while (ent.hasMoreElements()) {
                String clazz;
                String name = ent.nextElement().getName();
                if (!name.toLowerCase().endsWith(".class") || !(clazz = name.replace("/", ".").replace(".class", "")).endsWith("Library")) continue;
                launch = clazz;
                break;
            }
        } else {
            throw new ZipException("File is not a valid jarfile");
        }
        jf.close();
        if (launch != null) {
            URLClassLoader ucl = new URLClassLoader(new URL[]{jar.toURL()});
            try {
                lib = (RtflLibrary)ucl.loadClass(launch).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }
        return lib;
    }
}

