/*
 * Decompiled with CFR 0.152.
 */
package net.termer.rtflc.utils;

import java.util.ArrayList;
import java.util.HashMap;

public class ArgParser {
    private HashMap<String, String> _options = new HashMap();
    private Character[] _flags;
    private String[] _args;

    public ArgParser(String[] args) {
        ArrayList<Character> flags = new ArrayList<Character>();
        ArrayList<String> tmpArgs = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("--") && arg.length() > 2) {
                String argStr = arg.substring(2);
                String valStr = null;
                if (argStr.contains("=") && argStr.length() > argStr.indexOf(61) + 1) {
                    valStr = argStr.substring(argStr.indexOf(61) + 1);
                    argStr = argStr.split("=")[0];
                }
                this._options.put(argStr, valStr);
                continue;
            }
            if (arg.startsWith("-") && arg.length() > 1 && arg.charAt(1) != '-') {
                String flagStr = arg.substring(1);
                for (char fchar : flagStr.toCharArray()) {
                    if (flags.contains(Character.valueOf(fchar))) continue;
                    flags.add(Character.valueOf(fchar));
                }
                continue;
            }
            tmpArgs.add(arg);
        }
        this._flags = flags.toArray(new Character[0]);
        this._args = tmpArgs.toArray(new String[0]);
    }

    public String[] arguments() {
        return this._args;
    }

    public Character[] flags() {
        return this._flags;
    }

    public HashMap<String, String> options() {
        return this._options;
    }

    public boolean option(String name) {
        return this._options.containsKey(name);
    }

    public boolean flag(char flag) {
        boolean exists = false;
        Character[] characterArray = this._flags;
        int n = characterArray.length;
        for (int i = 0; i < n; ++i) {
            char f = characterArray[i].charValue();
            if (f != flag) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public String optionString(String option) {
        return this._options.get(option);
    }

    public int optionInt(String option) {
        return Integer.parseInt(this._options.get(option));
    }

    public char optionChar(String option) {
        return this._options.get(option).charAt(0);
    }

    public double optionDouble(String option) {
        return Double.parseDouble(this._options.get(option));
    }

    public boolean hasValue(String option) {
        return this._options.get(option) != null;
    }
}

