/*
 * Decompiled with CFR 0.152.
 */
package net.termer.rtflc.type.assignment;

import net.termer.rtflc.runtime.RuntimeException;
import net.termer.rtflc.runtime.Scope;
import net.termer.rtflc.type.BoolType;
import net.termer.rtflc.type.NumberType;
import net.termer.rtflc.type.RtflType;
import net.termer.rtflc.type.assignment.AssignmentType;
import net.termer.rtflc.utils.LogicComparison;

public class LogicAssignment
implements AssignmentType {
    private RtflType left = null;
    private LogicComparison comp = null;
    private RtflType right = null;
    private boolean inverse = false;

    public LogicAssignment(RtflType leftCondition, LogicComparison comparison, RtflType rightCondition, boolean isInverse) {
        this.left = leftCondition;
        this.comp = comparison;
        this.right = rightCondition;
        this.inverse = isInverse;
    }

    @Override
    public String name() {
        return "LOGIC";
    }

    @Override
    public Object value() {
        return null;
    }

    @Override
    public boolean equals(RtflType val, Scope scope) throws RuntimeException {
        return this.extractValue(scope).equals(val, scope);
    }

    public String toString() {
        return (this.inverse ? Character.valueOf('!') : "") + '[' + this.left.toString() + ' ' + LogicComparison.toChar(this.comp) + ' ' + this.right.toString() + ']';
    }

    public RtflType firstValue() {
        return this.left;
    }

    public RtflType secondValue() {
        return this.right;
    }

    public LogicComparison comparisonType() {
        return this.comp;
    }

    public boolean inverse() {
        return this.inverse;
    }

    @Override
    public RtflType extractValue(Scope scope) throws RuntimeException {
        RtflType r;
        boolean val = false;
        RtflType l = this.left instanceof AssignmentType ? ((AssignmentType)this.left).extractValue(scope) : this.left;
        RtflType rtflType = r = this.right instanceof AssignmentType ? ((AssignmentType)this.right).extractValue(scope) : this.right;
        val = this.comp == LogicComparison.EQUAL ? l.equals(r, scope) : (this.comp == LogicComparison.AND ? (l instanceof NumberType && r instanceof NumberType ? ((NumberType)l).toDouble() > 0.0 && ((NumberType)r).toDouble() > 0.0 : false) : (this.comp == LogicComparison.OR ? (l instanceof NumberType && r instanceof NumberType ? ((NumberType)l).toDouble() > 0.0 || ((NumberType)r).toDouble() > 0.0 : false) : (this.comp == LogicComparison.GREATER ? (l instanceof NumberType && r instanceof NumberType ? ((NumberType)l).toDouble() > ((NumberType)r).toDouble() : false) : (this.comp == LogicComparison.LESS ? (l instanceof NumberType && r instanceof NumberType ? ((NumberType)l).toDouble() < ((NumberType)r).toDouble() : false) : false))));
        return this.inverse ? new BoolType(!val) : new BoolType(val);
    }
}

