/*
 * Decompiled with CFR 0.152.
 */
package net.termer.rtflc.type.assignment;

import java.util.ArrayList;
import net.termer.rtflc.runtime.RuntimeException;
import net.termer.rtflc.runtime.Scope;
import net.termer.rtflc.type.ArrayType;
import net.termer.rtflc.type.NumberType;
import net.termer.rtflc.type.RtflType;
import net.termer.rtflc.type.assignment.AssignmentType;

public class ArrayIndexAssignment
implements AssignmentType {
    private RtflType _array = null;
    private RtflType _index = null;

    public ArrayIndexAssignment(RtflType array, RtflType index) {
        this._array = array;
        this._index = index;
    }

    @Override
    public String name() {
        return "ARRAY_INDEX";
    }

    @Override
    public Object value() {
        return null;
    }

    public RtflType array() {
        return this._array;
    }

    public RtflType index() {
        return this._index;
    }

    @Override
    public boolean equals(RtflType value, Scope scope) throws RuntimeException {
        return this.extractValue(scope).equals(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RtflType extractValue(Scope scope) throws RuntimeException {
        RtflType arr = this._array instanceof AssignmentType ? ((AssignmentType)this._array).extractValue(scope) : this._array;
        RtflType idx = this._index instanceof AssignmentType ? ((AssignmentType)this._index).extractValue(scope) : this._index;
        RtflType res = null;
        if (!(arr instanceof ArrayType)) throw new RuntimeException("Cannot get array element from non-array value");
        if (!(idx instanceof NumberType)) throw new RuntimeException("Cannot select element at non-number index");
        ArrayList array = (ArrayList)arr.value();
        NumberType index = (NumberType)idx;
        try {
            return (RtflType)array.get(index.toInt());
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("Index " + index.toInt() + " is out of bounds");
        }
    }

    public String toString() {
        return this._array.toString() + '[' + this._index + ']';
    }
}

