/*
 * Decompiled with CFR 0.152.
 */
package net.termer.rtflc.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.termer.rtflc.runtime.RuntimeException;
import net.termer.rtflc.runtime.Scope;
import net.termer.rtflc.type.ArrayType;
import net.termer.rtflc.type.BoolType;
import net.termer.rtflc.type.DoubleType;
import net.termer.rtflc.type.IntType;
import net.termer.rtflc.type.JavaObjectWrapperType;
import net.termer.rtflc.type.MapType;
import net.termer.rtflc.type.NullType;
import net.termer.rtflc.type.StringType;

public interface RtflType {
    public String name();

    public Object value();

    public boolean equals(RtflType var1, Scope var2) throws RuntimeException;

    public static RtflType fromJavaType(Object javaType) {
        RtflType val = new NullType();
        if (javaType instanceof Boolean) {
            val = new BoolType((Boolean)javaType);
        } else if (javaType instanceof Integer) {
            val = new IntType((Integer)javaType);
        } else if (javaType instanceof Double) {
            val = new DoubleType((Double)javaType);
        } else if (javaType instanceof String) {
            val = new StringType((String)javaType);
        } else if (javaType instanceof Object[]) {
            ArrayList<RtflType> tmpArr = new ArrayList<RtflType>();
            for (Object obj : (Object[])javaType) {
                tmpArr.add(RtflType.fromJavaType(obj));
            }
            val = new ArrayType(tmpArr);
        } else if (javaType instanceof Map) {
            Map map = (Map)javaType;
            HashMap<String, RtflType> rtflMap = new HashMap<String, RtflType>();
            for (Map.Entry entry : map.entrySet()) {
                rtflMap.put((String)entry.getKey(), RtflType.fromJavaType(entry.getValue()));
            }
            val = new MapType(rtflMap);
        } else if (javaType != null) {
            val = new JavaObjectWrapperType(javaType);
        }
        return val;
    }

    public static Object toJavaType(RtflType rtflType) {
        Object java = null;
        if (rtflType instanceof ArrayType) {
            ArrayList rtflArr = (ArrayList)rtflType.value();
            ArrayList<Object> arr = new ArrayList<Object>();
            for (RtflType rt : rtflArr) {
                arr.add(RtflType.toJavaType(rt));
            }
            java = arr.toArray();
        } else if (rtflType instanceof MapType) {
            Map map = (Map)rtflType.value();
            HashMap javaMap = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                javaMap.put(entry.getKey(), RtflType.toJavaType((RtflType)entry.getValue()));
            }
            java = javaMap;
        } else {
            java = rtflType.value();
        }
        return java;
    }
}

