/*
 * Decompiled with CFR 0.152.
 */
package net.termer.rtflc.runtime;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.termer.rtflc.instructions.RtflInstruction;
import net.termer.rtflc.producers.ProducerException;
import net.termer.rtflc.producers.SourcecodeInstructionProducer;
import net.termer.rtflc.runtime.RtflFunction;
import net.termer.rtflc.runtime.RtflRuntime;
import net.termer.rtflc.runtime.RuntimeException;
import net.termer.rtflc.runtime.Scope;
import net.termer.rtflc.type.ArrayType;
import net.termer.rtflc.type.BoolType;
import net.termer.rtflc.type.DoubleType;
import net.termer.rtflc.type.IntType;
import net.termer.rtflc.type.MapType;
import net.termer.rtflc.type.NullType;
import net.termer.rtflc.type.NumberType;
import net.termer.rtflc.type.RtflType;
import net.termer.rtflc.type.StringType;
import net.termer.rtflc.utils.CacheInstructionConsumer;
import net.termer.rtflc.utils.IOUtils;
import net.termer.rtflc.utils.LibraryLoader;
import org.json.JSONArray;
import org.json.JSONObject;

public class StandardFunctions {
    private HashMap<String, RtflFunction> funcs = new HashMap();
    private ArrayList<String> requiredFiles = new ArrayList();

    public StandardFunctions() {
        this.funcs.put("print", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                for (RtflType arg : args) {
                    System.out.print(arg.value());
                }
                return new NullType();
            }
        });
        this.funcs.put("println", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                for (RtflType arg : args) {
                    System.out.print(arg.value());
                }
                System.out.println();
                return new NullType();
            }
        });
        this.funcs.put("add", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                RtflType num = new NullType();
                if (args.length > 1) {
                    if (args[0] instanceof NumberType && args[1] instanceof NumberType) {
                        num = args[0] instanceof DoubleType || args[1] instanceof DoubleType ? new DoubleType(((NumberType)args[0]).toDouble() + ((NumberType)args[1]).toDouble()) : new IntType((Integer)args[0].value() + (Integer)args[1].value());
                    }
                } else {
                    throw new RuntimeException("Must provide at least 2 arguments");
                }
                return num;
            }
        });
        this.funcs.put("sub", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                RtflType num = new NullType();
                if (args.length > 1) {
                    if (args[0] instanceof NumberType && args[1] instanceof NumberType) {
                        num = args[0] instanceof DoubleType || args[1] instanceof DoubleType ? new DoubleType(((NumberType)args[0]).toDouble() - ((NumberType)args[1]).toDouble()) : new IntType((Integer)args[0].value() - (Integer)args[1].value());
                    }
                } else {
                    throw new RuntimeException("Must provide at least 2 arguments");
                }
                return num;
            }
        });
        this.funcs.put("mul", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                RtflType num = new NullType();
                if (args.length > 1) {
                    if (args[0] instanceof NumberType && args[1] instanceof NumberType) {
                        num = args[0] instanceof DoubleType || args[1] instanceof DoubleType ? new DoubleType(((NumberType)args[0]).toDouble() * ((NumberType)args[1]).toDouble()) : new IntType((Integer)args[0].value() * (Integer)args[1].value());
                    }
                } else {
                    throw new RuntimeException("Must provide at least 2 arguments");
                }
                return num;
            }
        });
        this.funcs.put("div", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                RtflType num = new NullType();
                if (args.length > 1) {
                    if (args[0] instanceof NumberType && args[1] instanceof NumberType) {
                        double dbl = ((NumberType)args[0]).toDouble() / ((NumberType)args[1]).toDouble();
                        num = dbl == Math.floor(dbl) && !Double.isInfinite(dbl) ? new IntType((int)dbl) : new DoubleType(dbl);
                    }
                } else {
                    throw new RuntimeException("Must provide at least 2 arguments");
                }
                return num;
            }
        });
        this.funcs.put("sleep", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length <= 0) throw new RuntimeException("Must provide at least 1 argument");
                if (!(args[0] instanceof NumberType)) throw new RuntimeException("Provided non-number argument");
                try {
                    Thread.sleep(((NumberType)args[0]).toInt());
                    return new NullType();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Failed to sleep because of internal error: " + e.getMessage());
                }
            }
        });
        this.funcs.put("gc", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) {
                return new IntType(runtime.garbageCollector().collect());
            }
        });
        this.funcs.put("gc_pause", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) {
                runtime.garbageCollector().pause();
                return new NullType();
            }
        });
        this.funcs.put("gc_resume", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) {
                runtime.garbageCollector().unpause();
                return new NullType();
            }
        });
        this.funcs.put("eval", new EvalFunction(false, false));
        this.funcs.put("async", new EvalFunction(true, false));
        this.funcs.put("load", new EvalFunction(false, true));
        this.funcs.put("load_async", new EvalFunction(true, true));
        this.funcs.put("require", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length <= 0) throw new RuntimeException("Must provide at least 1 argument");
                if (!(args[0] instanceof StringType)) throw new RuntimeException("Provided non-string argument");
                String path = (String)args[0].value();
                File file = null;
                if (path.contains(".") || path.contains("/")) {
                    file = new File(path);
                } else {
                    file = new File("libs/" + path + ".rtfc");
                    if (!file.isFile()) {
                        file = new File("libs/" + path + ".rtfl");
                    }
                }
                if (StandardFunctions.this.requiredFiles.contains(file.getAbsolutePath())) return new NullType();
                try {
                    runtime.executeFile(file, scope);
                    StandardFunctions.this.requiredFiles.add(file.getAbsolutePath());
                    return new NullType();
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("File/library \"" + path + "\" does not exist");
                }
                catch (IOException | ProducerException e) {
                    throw new RuntimeException("Failed to execute file: " + e.getMessage());
                }
            }
        });
        this.funcs.put("inc", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length <= 0) throw new RuntimeException("Must provide at least 1 argument");
                if (!(args[0] instanceof StringType)) throw new RuntimeException("Provided non-string argument");
                String varName = (String)((StringType)args[0]).value();
                RtflType varVal = scope.varValue(varName);
                if (varVal instanceof DoubleType) {
                    scope.assignVar(varName, new DoubleType(((DoubleType)varVal).toDouble() + 1.0));
                    return new NullType();
                } else {
                    scope.assignVar(varName, new IntType(((IntType)varVal).toInt() + 1));
                }
                return new NullType();
            }
        });
        this.funcs.put("dec", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length <= 0) throw new RuntimeException("Must provide at least 1 argument");
                if (!(args[0] instanceof StringType)) throw new RuntimeException("Provided non-string argument");
                String varName = (String)((StringType)args[0]).value();
                RtflType varVal = scope.varValue(varName);
                if (varVal instanceof DoubleType) {
                    scope.assignVar(varName, new DoubleType(((DoubleType)varVal).toDouble() - 1.0));
                    return new NullType();
                } else {
                    scope.assignVar(varName, new IntType(((IntType)varVal).toInt() - 1));
                }
                return new NullType();
            }
        });
        this.funcs.put("equals", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                boolean equals = false;
                if (args.length <= 1) {
                    throw new RuntimeException("Must provide at least 2 arguments");
                }
                equals = args[0].equals(args[1], scope);
                return new BoolType(equals);
            }
        });
        this.funcs.put("more_than", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                boolean more = false;
                if (args.length > 1) {
                    if (!(args[0] instanceof NumberType) || !(args[1] instanceof NumberType)) {
                        throw new RuntimeException("Provided non-number argument");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 2 arguments");
                }
                more = ((NumberType)args[0]).toDouble() > ((NumberType)args[1]).toDouble();
                return new BoolType(more);
            }
        });
        this.funcs.put("less_than", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                boolean less = false;
                if (args.length > 1) {
                    if (!(args[0] instanceof NumberType) || !(args[1] instanceof NumberType)) {
                        throw new RuntimeException("Provided non-number argument");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 2 arguments");
                }
                less = ((NumberType)args[0]).toDouble() < ((NumberType)args[1]).toDouble();
                return new BoolType(less);
            }
        });
        this.funcs.put("not", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                BoolType inverse = null;
                if (args.length > 0) {
                    if (!(args[0] instanceof NumberType)) {
                        throw new RuntimeException("Provided non-number/bool argument");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 1 argument");
                }
                inverse = new BoolType(!(((NumberType)args[0]).toDouble() > 0.0));
                return inverse;
            }
        });
        this.funcs.put("and", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                BoolType val = null;
                if (args.length > 1) {
                    if (!(args[0] instanceof NumberType) || !(args[1] instanceof NumberType)) {
                        throw new RuntimeException("Provided non-number/bool argument");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 2 arguments");
                }
                val = new BoolType(((NumberType)args[0]).toDouble() > 0.0 && ((NumberType)args[1]).toDouble() > 0.0);
                return val;
            }
        });
        this.funcs.put("or", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                BoolType val = null;
                if (args.length > 1) {
                    if (!(args[0] instanceof NumberType) || !(args[1] instanceof NumberType)) {
                        throw new RuntimeException("Provided non-number/bool argument");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 2 arguments");
                }
                val = new BoolType(((NumberType)args[0]).toDouble() > 0.0 || ((NumberType)args[1]).toDouble() > 0.0);
                return val;
            }
        });
        this.funcs.put("concat", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                StringBuilder str = null;
                if (args.length > 1) {
                    String value = args[0].value() == null ? "null" : args[0].value().toString();
                    str = new StringBuilder(value);
                    for (int i = 1; i < args.length; ++i) {
                        str.append(args[i].value() == null ? "null" : args[i].value().toString());
                    }
                } else {
                    throw new RuntimeException("Must provide at least 2 arguments");
                }
                return new StringType(str.toString());
            }
        });
        this.funcs.put("string_contains", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                BoolType contains = null;
                if (args.length > 1) {
                    if (!(args[0] instanceof StringType) || !(args[1] instanceof StringType)) {
                        throw new RuntimeException("Provided non-string argument");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 2 arguments");
                }
                String str = (String)args[0].value();
                String substr = (String)args[1].value();
                contains = new BoolType(str.contains(substr));
                return contains;
            }
        });
        this.funcs.put("string_trim", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                StringType trimmed = null;
                if (args.length > 0) {
                    if (!(args[0] instanceof StringType)) {
                        throw new RuntimeException("Provided non-string argument");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 1 argument");
                }
                String str = (String)args[0].value();
                trimmed = new StringType(str.trim());
                return trimmed;
            }
        });
        this.funcs.put("var", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                RtflType varVal = new NullType();
                if (args.length > 0) {
                    if (!(args[0] instanceof StringType)) {
                        throw new RuntimeException("Provided non-string argument");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 1 argument");
                }
                String varName = (String)args[0].value();
                varVal = scope.varValue(varName);
                return varVal;
            }
        });
        this.funcs.put("to_string", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                StringType val = null;
                if (args.length <= 0) {
                    throw new RuntimeException("Must provide at least 1 argument");
                }
                val = new StringType(args[0].value() == null ? "null" : args[0].value().toString());
                return val;
            }
        });
        this.funcs.put("read_file", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                StringType val = null;
                if (args.length <= 0) throw new RuntimeException("Must provide at least 1 argument");
                if (!(args[0] instanceof StringType)) throw new RuntimeException("Provided non-string argument");
                String path = (String)args[0].value();
                try {
                    return new StringType(IOUtils.readFile(path));
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("File \"" + path + "\" does not exist");
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading file \"" + path + "\": " + e.getMessage());
                }
            }
        });
        this.funcs.put("write_file", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length <= 1) throw new RuntimeException("Must provide at least 2 arguments");
                if (!(args[0] instanceof StringType)) throw new RuntimeException("Provided non-string path");
                boolean append = false;
                if (args.length > 2) {
                    if (!(args[2] instanceof BoolType)) throw new RuntimeException("Provided non-bool type for append argument");
                    append = (Boolean)args[2].value();
                }
                String path = (String)args[0].value();
                String content = args[1].value() == null ? "null" : args[1].value().toString();
                try {
                    IOUtils.writeFile(path, content, append);
                    return new NullType();
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("File \"" + path + "\" does not exist");
                }
                catch (IOException e) {
                    throw new RuntimeException("Error writing to file \"" + path + "\": " + e.getMessage());
                }
            }
        });
        this.funcs.put("file_exists", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                BoolType val = null;
                if (args.length > 0) {
                    if (!(args[0] instanceof StringType)) {
                        throw new RuntimeException("Provided non-string path");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 1 argument");
                }
                val = new BoolType(new File((String)args[0].value()).exists());
                return val;
            }
        });
        this.funcs.put("is_file", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                BoolType val = null;
                if (args.length > 0) {
                    if (!(args[0] instanceof StringType)) {
                        throw new RuntimeException("Provided non-string path");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 1 argument");
                }
                val = new BoolType(new File((String)args[0].value()).isFile());
                return val;
            }
        });
        this.funcs.put("is_directory", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                BoolType val = null;
                if (args.length > 0) {
                    if (!(args[0] instanceof StringType)) {
                        throw new RuntimeException("Provided non-string path");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 1 argument");
                }
                val = new BoolType(new File((String)args[0].value()).isDirectory());
                return val;
            }
        });
        this.funcs.put("delete_file", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length <= 0) throw new RuntimeException("Must provide at least 1 argument");
                if (!(args[0] instanceof StringType)) throw new RuntimeException("Provided non-string path");
                File file = new File((String)args[0].value());
                if (!file.exists()) throw new RuntimeException("File \"" + (String)args[0].value() + "\" does not exist");
                if (file.isDirectory() && file.list().length > 0) {
                    throw new RuntimeException("Cannot delete directories with files in them");
                }
                file.delete();
                return new NullType();
            }
        });
        this.funcs.put("list_files", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                ArrayType files = new ArrayType();
                if (args.length <= 0) throw new RuntimeException("Must provide at least 1 argument");
                if (!(args[0] instanceof StringType)) throw new RuntimeException("Provided non-string path");
                File file = new File((String)args[0].value());
                ArrayList fileNames = (ArrayList)files.value();
                if (!file.exists()) throw new RuntimeException("Path \"" + (String)args[0].value() + "\" does not exist");
                if (!file.isDirectory()) throw new RuntimeException("Path \"" + (String)args[0].value() + "\" does not point to a directory");
                for (String path : file.list()) {
                    fileNames.add(new StringType(path));
                }
                return files;
            }
        });
        this.funcs.put("create_directory", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length > 0) {
                    if (!(args[0] instanceof StringType)) {
                        throw new RuntimeException("Provided non-string path");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 1 argument");
                }
                File file = new File((String)args[0].value());
                file.mkdirs();
                return new NullType();
            }
        });
        this.funcs.put("move_file", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length > 1) {
                    if (!(args[0] instanceof StringType) || !(args[1] instanceof StringType)) {
                        throw new RuntimeException("Provided non-string path");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 2 arguments");
                }
                File file = new File((String)args[0].value());
                file.renameTo(new File((String)args[1].value()));
                return new NullType();
            }
        });
        this.funcs.put("open_terminal", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                runtime.openTerminal();
                return new NullType();
            }
        });
        this.funcs.put("close_terminal", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                runtime.closeTerminal();
                return new NullType();
            }
        });
        this.funcs.put("terminal_open", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                return new BoolType(runtime.terminalOpen());
            }
        });
        this.funcs.put("read_terminal", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                return new StringType(runtime.readTerminal());
            }
        });
        this.funcs.put("exit", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length > 0 && args[0] instanceof NumberType) {
                    System.exit(((NumberType)args[0]).toInt());
                } else {
                    System.exit(0);
                }
                return new NullType();
            }
        });
        this.funcs.put("system_property", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                RtflType prop = null;
                if (args.length > 0) {
                    if (!(args[0] instanceof StringType)) {
                        throw new RuntimeException("Provided non-string property name");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 1 argument");
                }
                String sysProp = System.getProperty((String)args[0].value());
                prop = sysProp == null ? new NullType() : new StringType(sysProp);
                return prop;
            }
        });
        this.funcs.put("array", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                return new ArrayType(args);
            }
        });
        this.funcs.put("array_add", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length <= 1) throw new RuntimeException("Must provide at least 2 arguments");
                if (!(args[0] instanceof ArrayType)) throw new RuntimeException("Did not provide array to add elements to");
                ArrayList arr = (ArrayList)((ArrayType)args[0]).value();
                for (int i = 1; i < args.length; ++i) {
                    arr.add(args[i]);
                }
                return new NullType();
            }
        });
        this.funcs.put("array_contains", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                boolean contains = false;
                if (args.length <= 1) throw new RuntimeException("Must provide at least 2 arguments");
                if (!(args[0] instanceof ArrayType)) throw new RuntimeException("Did not provide array to search");
                ArrayList arr = (ArrayList)((ArrayType)args[0]).value();
                for (RtflType elem : arr) {
                    if (!elem.equals(args[1], scope)) continue;
                    contains = true;
                    return new BoolType(contains);
                }
                return new BoolType(contains);
            }
        });
        this.funcs.put("array_remove", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length <= 1) throw new RuntimeException("Must provide at least 2 arguments");
                if (!(args[0] instanceof ArrayType)) throw new RuntimeException("Did not provide array to remove elements from");
                ArrayList arr = (ArrayList)((ArrayType)args[0]).value();
                RtflType rem = args[1];
                if (rem instanceof NumberType) {
                    arr.remove(((NumberType)rem).toInt());
                    return new NullType();
                } else {
                    for (int i = 0; i < arr.size(); ++i) {
                        if (!rem.value().equals(((RtflType)arr.get(i)).value())) continue;
                        arr.remove(i);
                    }
                }
                return new NullType();
            }
        });
        this.funcs.put("array_get", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                NullType nullType = new NullType();
                if (args.length <= 1) throw new RuntimeException("Must provide at least 2 arguments");
                if (!(args[0] instanceof ArrayType)) throw new RuntimeException("Did not provide array to read");
                ArrayList arr = (ArrayList)((ArrayType)args[0]).value();
                RtflType index = args[1];
                try {
                    if (!(index instanceof NumberType)) throw new RuntimeException("Index must be a number");
                    return (RtflType)arr.get(((NumberType)index).toInt());
                }
                catch (IndexOutOfBoundsException e) {
                    throw new RuntimeException("Index " + index + " out of bounds (array length is " + arr.size() + ')');
                }
            }
        });
        this.funcs.put("array_set", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length <= 2) throw new RuntimeException("Must provide at least 3 arguments");
                if (!(args[0] instanceof ArrayType)) throw new RuntimeException("Did not provide array to set");
                ArrayList arr = (ArrayList)((ArrayType)args[0]).value();
                RtflType index = args[1];
                try {
                    if (!(index instanceof NumberType)) {
                        throw new RuntimeException("Index must be a number");
                    }
                    arr.set(((NumberType)index).toInt(), args[2]);
                    return new NullType();
                }
                catch (IndexOutOfBoundsException e) {
                    throw new RuntimeException("Index " + index + " out of bounds (array length is " + arr.size() + ')');
                }
            }
        });
        this.funcs.put("array_length", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                IntType len = null;
                if (args.length > 0) {
                    if (!(args[0] instanceof ArrayType)) {
                        throw new RuntimeException("Did not provide array to measure");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 1 argument");
                }
                ArrayList arr = (ArrayList)((ArrayType)args[0]).value();
                len = new IntType(arr.size());
                return len;
            }
        });
        this.funcs.put("split", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                String[] bits;
                ArrayType parts = new ArrayType();
                if (args.length <= 1) throw new RuntimeException("Must provide at least 2 arguments");
                if (!(args[0] instanceof StringType) || !(args[1] instanceof StringType)) throw new RuntimeException("Provided non-string argument");
                String str = (String)args[0].value();
                String splitter = (String)args[1].value();
                for (String bit : bits = str.split(splitter)) {
                    ((ArrayList)parts.value()).add(new StringType(bit));
                }
                return parts;
            }
        });
        this.funcs.put("index_of", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                IntType index = null;
                if (args.length > 1) {
                    if (!(args[0] instanceof StringType) || !(args[1] instanceof StringType)) {
                        throw new RuntimeException("Provided non-string argument");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 2 arguments");
                }
                String str = (String)args[0].value();
                String str2 = (String)args[1].value();
                index = new IntType(str.indexOf(str2));
                return index;
            }
        });
        this.funcs.put("starts_with", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                BoolType result = null;
                if (args.length > 1) {
                    if (!(args[0] instanceof StringType) || !(args[1] instanceof StringType)) {
                        throw new RuntimeException("Provided non-string argument");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 2 arguments");
                }
                String str = (String)args[0].value();
                String start = (String)args[1].value();
                result = new BoolType(str.startsWith(start));
                return result;
            }
        });
        this.funcs.put("ends_with", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                BoolType result = null;
                if (args.length > 1) {
                    if (!(args[0] instanceof StringType) || !(args[1] instanceof StringType)) {
                        throw new RuntimeException("Provided non-string argument");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 2 arguments");
                }
                String str = (String)args[0].value();
                String end = (String)args[1].value();
                result = new BoolType(str.endsWith(end));
                return result;
            }
        });
        this.funcs.put("string_replace", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                StringType result = null;
                if (args.length > 2) {
                    if (!(args[0] instanceof StringType && args[1] instanceof StringType && args[2] instanceof StringType)) {
                        throw new RuntimeException("Provided non-string argument");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 3 arguments");
                }
                String str = (String)args[0].value();
                String replace = (String)args[1].value();
                String replaceVal = (String)args[2].value();
                result = new StringType(str.replace(replace, replaceVal));
                return result;
            }
        });
        this.funcs.put("substring", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                StringType sub = null;
                if (args.length <= 1) throw new RuntimeException("Must provide at least 1 argument");
                if (!(args[0] instanceof StringType)) throw new RuntimeException("Provided non-string argument");
                String str = (String)args[0].value();
                int start = -1;
                int end = str.length();
                if (!(args[1] instanceof NumberType)) throw new RuntimeException("Starting index must be a number");
                start = ((NumberType)args[1]).toInt();
                if (args.length > 2 && args[2] instanceof NumberType) {
                    end = ((NumberType)args[2]).toInt();
                }
                try {
                    return new StringType(str.substring(start, end));
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new RuntimeException("String range is out of bounds");
                }
            }
        });
        this.funcs.put("char_at", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                StringType ch = null;
                if (args.length <= 1) throw new RuntimeException("Must provide at least 1 argument");
                if (!(args[0] instanceof StringType)) throw new RuntimeException("Provided non-string argument");
                String str = (String)args[0].value();
                if (!(args[1] instanceof NumberType)) throw new RuntimeException("Character index must be a number");
                int index = ((NumberType)args[1]).toInt();
                try {
                    return new StringType(str.charAt(index) + "");
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new RuntimeException("Character index is out of bounds");
                }
            }
        });
        this.funcs.put("string_length", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                IntType len = null;
                if (args.length > 0) {
                    if (!(args[0] instanceof StringType)) {
                        throw new RuntimeException("Did not provide string to measure");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 1 argument");
                }
                String str = (String)args[0].value();
                len = new IntType(str.length());
                return len;
            }
        });
        this.funcs.put("type", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                String type = null;
                if (args.length > 0) {
                    type = args[0] instanceof ArrayType ? "array" : (args[0] instanceof BoolType ? "boolean" : (args[0] instanceof NumberType ? "number" : (args[0] instanceof NullType ? "null" : (args[0] instanceof StringType ? "string" : args[0].name().toLowerCase()))));
                } else {
                    throw new RuntimeException("Must provide at least 1 argument");
                }
                return new StringType(type);
            }
        });
        this.funcs.put("to_number", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                NumberType num = null;
                if (args.length <= 0) throw new RuntimeException("Must provide at least 1 argument");
                if (args[0] instanceof NumberType) {
                    return (NumberType)args[0];
                }
                if (args[0] instanceof BoolType) {
                    return new IntType(((NumberType)args[0]).toInt());
                }
                if (!(args[0] instanceof StringType)) throw new RuntimeException("Cannot convert \"" + args[0] + "\" to number");
                String str = (String)args[0].value();
                try {
                    if (!str.contains(".")) return new IntType(Integer.parseInt(str));
                    return new DoubleType(Double.parseDouble(str));
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("String \"" + str + "\" does not represent a number");
                }
            }
        });
        this.funcs.put("read_http", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                StringType res = null;
                if (args.length > 0) {
                    if (args[0] instanceof StringType) {
                        String url = (String)args[0].value();
                        String method = "GET";
                        if (args.length > 1 && args[1] instanceof StringType) {
                            method = (String)args[1].value();
                        }
                        try {
                            URL obj = new URL(url);
                            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
                            con.setRequestMethod(method);
                            StringBuilder response = new StringBuilder();
                            BufferedInputStream buf = new BufferedInputStream(con.getInputStream());
                            int read = 0;
                            while ((read = buf.read()) > -1) {
                                response.append((char)read);
                            }
                            buf.close();
                            res = new StringType(response.toString());
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to load URL: " + e.getMessage());
                        }
                    }
                } else {
                    throw new RuntimeException("Must provide at least 1 argument");
                }
                return res;
            }
        });
        this.funcs.put("exec", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                String out = null;
                if (args.length > 0) {
                    ArrayList<String> procArgs = new ArrayList<String>();
                    for (RtflType arg : args) {
                        procArgs.add(arg.value().toString());
                    }
                    ProcessBuilder pb = new ProcessBuilder(procArgs);
                    pb.redirectErrorStream(true);
                    InputStream in = null;
                    ByteArrayOutputStream baos = null;
                    try {
                        Process proc = pb.start();
                        in = proc.getInputStream();
                        baos = new ByteArrayOutputStream();
                        byte[] b = new byte[1024];
                        int size = 0;
                        while ((size = in.read(b)) != -1) {
                            baos.write(b, 0, size);
                        }
                        out = new String(baos.toByteArray());
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to execute process: " + e.getMessage());
                    }
                    finally {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            if (baos != null) {
                                baos.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
                throw new RuntimeException("Must provide at least 1 argument");
                return new StringType(out);
            }
        });
        this.funcs.put("map", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                return new MapType();
            }
        });
        this.funcs.put("map_keys", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                ArrayType val = null;
                if (args.length <= 0) throw new RuntimeException("Must provide at least 1 argument");
                if (!(args[0] instanceof MapType)) throw new RuntimeException("Provided non-map argument");
                ConcurrentHashMap map = (ConcurrentHashMap)args[0].value();
                ArrayList<RtflType> arr = new ArrayList<RtflType>();
                Iterator iterator = ((ConcurrentHashMap.KeySetView)map.keySet()).iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    arr.add(new StringType(key));
                }
                return new ArrayType(arr);
            }
        });
        this.funcs.put("map_values", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                ArrayType val = null;
                if (args.length <= 0) throw new RuntimeException("Must provide at least 1 argument");
                if (!(args[0] instanceof MapType)) throw new RuntimeException("Provided non-map argument");
                ConcurrentHashMap map = (ConcurrentHashMap)args[0].value();
                ArrayList<RtflType> arr = new ArrayList<RtflType>();
                Iterator iterator = map.values().iterator();
                while (iterator.hasNext()) {
                    RtflType value = (RtflType)iterator.next();
                    arr.add(value);
                }
                return new ArrayType(arr);
            }
        });
        this.funcs.put("map_contains_key", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                boolean contains = false;
                if (args.length > 1) {
                    if (!(args[0] instanceof MapType)) {
                        throw new RuntimeException("Provided non-map argument");
                    }
                } else {
                    throw new RuntimeException("Must provide at least 2 arguments");
                }
                ConcurrentHashMap map = (ConcurrentHashMap)args[0].value();
                contains = map.containsKey((String)args[1].value());
                return new BoolType(contains);
            }
        });
        this.funcs.put("map_put", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length <= 2) throw new RuntimeException("Must provide at least 3 arguments");
                if (!(args[0] instanceof MapType)) throw new RuntimeException("Provided non-map argument");
                if (!(args[1] instanceof StringType)) {
                    throw new RuntimeException("Key must be a string");
                }
                ConcurrentHashMap map = (ConcurrentHashMap)args[0].value();
                map.put((String)args[1].value(), args[2]);
                return new NullType();
            }
        });
        this.funcs.put("map_set", this.funcs.get("map_put"));
        this.funcs.put("map_get", new RtflFunction(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                void var4_6;
                NullType nullType = new NullType();
                if (args.length <= 1) throw new RuntimeException("Must provide at least 2 arguments");
                if (!(args[0] instanceof MapType)) throw new RuntimeException("Provided non-map argument");
                if (!(args[1] instanceof StringType)) throw new RuntimeException("Key must be a string");
                ConcurrentHashMap map = (ConcurrentHashMap)args[0].value();
                RtflType value = (RtflType)map.get((String)args[1].value());
                if (value == null) return var4_6;
                RtflType rtflType = value;
                return var4_6;
            }
        });
        this.funcs.put("map_remove", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length <= 1) throw new RuntimeException("Must provide at least 2 arguments");
                if (!(args[0] instanceof MapType)) throw new RuntimeException("Provided non-map argument");
                if (!(args[1] instanceof StringType)) {
                    throw new RuntimeException("Key must be a string");
                }
                ConcurrentHashMap map = (ConcurrentHashMap)args[0].value();
                map.remove((String)args[1].value());
                return new NullType();
            }
        });
        this.funcs.put("to_json", new JsonParseFunction(false));
        this.funcs.put("from_json", new JsonParseFunction(true));
        this.funcs.put("restrict", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length <= 0) throw new RuntimeException("Must provide at least 1 argument");
                if (!(args[0] instanceof StringType)) throw new RuntimeException("Provided non-string argument");
                String funcName = (String)args[0].value();
                if (scope.parent() == null) return new NullType();
                scope.parent().restrictFunc(funcName);
                return new NullType();
            }
        });
        this.funcs.put("library", new RtflFunction(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length <= 0) throw new RuntimeException("Must provide at least 1 argument");
                if (!(args[0] instanceof StringType)) throw new RuntimeException("Provided non-string argument");
                File jar = new File((String)args[0].value());
                try {
                    LibraryLoader.loadLibrary(jar).initialize(runtime);
                    return new NullType();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to load JAR library: " + e.getMessage());
                }
            }
        });
        this.funcs.put("throw", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length > 0) {
                    if (args[0] instanceof StringType) {
                        throw new RuntimeException((String)args[0].value());
                    }
                    throw new RuntimeException("Provided non-string argument");
                }
                throw new RuntimeException("Must provide at least 1 argument");
            }
        });
        this.funcs.put("copy_func", new RtflFunction(){

            @Override
            public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
                if (args.length > 1) {
                    if (args[0] instanceof StringType && args[1] instanceof StringType && scope.function((String)args[0].value()) != null) {
                        runtime.functions().put((String)args[1].value(), scope.function((String)args[0].value()));
                    }
                } else {
                    throw new RuntimeException("Musst provide at least two arguments");
                }
                return new NullType();
            }
        });
    }

    public HashMap<String, RtflFunction> functions() {
        return this.funcs;
    }

    private class JsonParseFunction
    implements RtflFunction {
        private boolean _toMap = false;

        public JsonParseFunction(boolean toMap) {
            this._toMap = toMap;
        }

        private JSONArray arrayToJson(ArrayType arrayType) {
            JSONArray arr = new JSONArray();
            for (RtflType val : (ArrayList)arrayType.value()) {
                if (val instanceof MapType) {
                    arr.put((Object)this.mapToJson((MapType)val));
                    continue;
                }
                if (val instanceof ArrayType) {
                    arr.put((Object)this.arrayToJson((ArrayType)val));
                    continue;
                }
                arr.put(val.value());
            }
            return arr;
        }

        private JSONObject mapToJson(MapType mapType) {
            JSONObject json = new JSONObject();
            ConcurrentHashMap map = (ConcurrentHashMap)mapType.value();
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() instanceof MapType) {
                    json.put((String)entry.getKey(), (Object)this.mapToJson((MapType)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof ArrayType) {
                    json.put((String)entry.getKey(), (Object)this.arrayToJson((ArrayType)entry.getValue()));
                    continue;
                }
                json.put((String)entry.getKey(), ((RtflType)entry.getValue()).value());
            }
            return json;
        }

        public RtflType jsonToValue(Object json) {
            RtflType val = null;
            val = json instanceof ArrayList ? new ArrayType(this.jsonToArray((ArrayList)json)) : (json instanceof Boolean ? new BoolType((Boolean)json) : (json instanceof Double ? new DoubleType((Double)json) : (json instanceof Integer ? new IntType((Integer)json) : (json instanceof Map ? new MapType(this.jsonToMap((Map)json)) : (json instanceof String ? new StringType((String)json) : new NullType())))));
            return val;
        }

        public ArrayList<RtflType> jsonToArray(ArrayList<Object> json) {
            ArrayList<RtflType> array = new ArrayList<RtflType>();
            for (Object obj : json) {
                array.add(this.jsonToValue(obj));
            }
            return array;
        }

        public HashMap<String, RtflType> jsonToMap(Map<String, Object> json) {
            HashMap<String, RtflType> map = new HashMap<String, RtflType>();
            for (Map.Entry<String, Object> entry : json.entrySet()) {
                map.put(entry.getKey(), this.jsonToValue(entry.getValue()));
            }
            return map;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
            void var4_7;
            Object var4_4 = null;
            if (args.length <= 0) throw new RuntimeException("Must provide at least 1 argument");
            if (this._toMap) {
                if (!(args[0] instanceof StringType)) throw new RuntimeException("Provided non-string argument");
                try {
                    Map map = new JSONObject((String)args[0].value()).toMap();
                    MapType mapType = new MapType(this.jsonToMap(map));
                    return var4_7;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to parse JSON: " + e.getMessage());
                }
            } else {
                if (!(args[0] instanceof MapType)) throw new RuntimeException("Provided non-map argument");
                JSONObject json = this.mapToJson((MapType)args[0]);
                boolean pretty = false;
                if (args.length > 1 && args[1] instanceof BoolType) {
                    pretty = (Boolean)args[1].value();
                }
                StringType stringType = new StringType(json.toString(pretty ? 1 : 0));
            }
            return var4_7;
        }
    }

    private class EvalFunction
    implements RtflFunction {
        private boolean _async = false;
        private boolean _fromFile = false;

        public EvalFunction(boolean async, boolean fromFile) {
            this._async = async;
            this._fromFile = fromFile;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public RtflType run(RtflType[] args, RtflRuntime runtime, Scope scope) throws RuntimeException {
            void var4_6;
            NullType nullType = new NullType();
            if (args.length <= 0) throw new RuntimeException("Must provide at least 1 argument");
            if (!(args[0] instanceof StringType)) throw new RuntimeException("Provided non-string argument");
            ByteArrayInputStream in = null;
            if (this._fromFile) {
                String path = (String)((StringType)args[0]).value();
                try {
                    runtime.executeFile(new File(path), scope);
                    return var4_6;
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("File \"" + path + "\" does not exist");
                }
                catch (IOException | ProducerException e) {
                    throw new RuntimeException("Failed to execute file: " + e.getMessage());
                }
            }
            String code = (String)((StringType)args[0]).value();
            in = new ByteArrayInputStream(code.getBytes(StandardCharsets.UTF_8));
            CacheInstructionConsumer cons = new CacheInstructionConsumer();
            try {
                SourcecodeInstructionProducer.produce(this._fromFile ? new File((String)args[0].value()).getName() : "eval", in, cons);
                if (this._async) {
                    runtime.executeAsync(cons.cache.toArray(new RtflInstruction[0]), scope);
                    return var4_6;
                } else {
                    RtflType rtflType = runtime.execute(cons.cache.toArray(new RtflInstruction[0]), scope);
                }
                return var4_6;
            }
            catch (IOException | ProducerException | RuntimeException e) {
                if (!(e instanceof RuntimeException)) throw new RuntimeException(e.getMessage());
                throw (RuntimeException)e;
            }
        }
    }
}

