/*
 * Decompiled with CFR 0.152.
 */
package net.termer.rtflc.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import net.termer.rtflc.instructions.RtflInstruction;
import net.termer.rtflc.runtime.RtflFunction;
import net.termer.rtflc.runtime.RtflRuntime;
import net.termer.rtflc.runtime.RuntimeException;
import net.termer.rtflc.type.RtflType;

public class Scope {
    private RtflRuntime rt = null;
    private HashMap<String, Integer> locals = null;
    private Scope parent = null;
    private RtflInstruction cause = null;
    private ArrayList<String> restrictedFuncs = new ArrayList();

    public Scope(RtflRuntime runtime, HashMap<String, Integer> localAliases, RtflInstruction causeInstruction) {
        this.rt = runtime;
        this.locals = localAliases == null ? new HashMap() : localAliases;
        this.cause = causeInstruction;
    }

    public Scope(RtflRuntime runtime, HashMap<String, Integer> localAliases, RtflInstruction causeInstruction, Scope parentScope) {
        this.rt = runtime;
        this.locals = localAliases == null ? new HashMap() : localAliases;
        this.cause = causeInstruction;
        this.parent = parentScope;
    }

    public Scope(RtflRuntime runtime, HashMap<String, Integer> localAliases, ArrayList<String> restrictedFunctions, RtflInstruction causeInstruction, Scope parentScope) {
        this.rt = runtime;
        this.locals = localAliases == null ? new HashMap() : localAliases;
        this.restrictedFuncs = restrictedFunctions;
        this.cause = causeInstruction;
        this.parent = parentScope;
    }

    public Scope parent() {
        return this.parent;
    }

    public RtflRuntime runtime() {
        return this.rt;
    }

    public RtflInstruction cause() {
        return this.cause;
    }

    public HashMap<String, Integer> variableAliases() {
        return this.locals;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean assignVar(String varName, RtflType value) throws RuntimeException {
        boolean local = false;
        if (!this.locals.containsKey(varName)) {
            if (!this.rt.globalVarables().containsKey(varName)) throw new RuntimeException("Attempted to assign value to undefined variable \"" + varName + "\"");
            this.rt.globalVarables().replace(varName, value);
            return local;
        }
        int id = this.locals.get(varName);
        if (this.rt.localVariables().containsKey(id)) {
            local = true;
            this.rt.localVariables().replace(id, new RtflRuntime.LocalVar(value, Thread.currentThread().getName()));
            return local;
        }
        this.locals.remove(varName);
        throw new RuntimeException("Attempted to assign value to undefined variable \"" + varName + "\"");
    }

    public int createLocalVar(String varName, RtflType value) {
        int id = this.rt.newId();
        if (this.locals.containsKey(varName)) {
            this.locals.remove(varName);
        }
        this.rt.localVariables().put(id, new RtflRuntime.LocalVar(value, Thread.currentThread().getName()));
        this.locals.put(varName, id);
        return id;
    }

    public int undefineVar(String varName) throws RuntimeException {
        int localId = -1;
        if (this.locals.containsKey(varName)) {
            int id;
            localId = id = this.locals.get(varName).intValue();
            this.locals.remove(varName);
            this.rt.localVariables().remove(id);
        } else if (this.rt.globalVarables().containsKey(varName)) {
            this.rt.globalVarables().remove(varName);
        } else {
            throw new RuntimeException("Attempted undefine undefined variable \"" + varName + "\"");
        }
        return localId;
    }

    public void undefineFunc(String funcName) {
        if (!this.restrictedFuncs.contains(funcName) && this.rt.functions().containsKey(funcName)) {
            this.rt.functions().remove(funcName);
        }
    }

    public void restrictFunc(String funcName) {
        this.restrictedFuncs.add(funcName);
    }

    public RtflType varValue(String varName) throws RuntimeException {
        RtflType val = null;
        if (this.locals.containsKey(varName)) {
            int id = this.locals.get(varName);
            RtflRuntime.LocalVar var = this.rt.localVariables().get(id);
            if (var == null) {
                this.locals.remove(varName);
                throw new RuntimeException("Attempted to retrieve value from undefined variable \"" + varName + "\"");
            }
            val = var.value;
        } else if (this.rt.globalVarables().containsKey(varName)) {
            val = this.rt.globalVarables().get(varName);
        } else {
            throw new RuntimeException("Attempted to retrieve value from undefined variable \"" + varName + "\"");
        }
        return val;
    }

    public RtflFunction function(String funcName) throws RuntimeException {
        RtflFunction func = null;
        if (this.restrictedFuncs.contains(funcName) || !this.rt.functions().containsKey(funcName)) {
            throw new RuntimeException("Attempted to call undefined or restricted function \"" + funcName + "\"");
        }
        func = this.rt.functions().get(funcName);
        return func;
    }

    public Scope[] scopeStack() {
        ArrayList<Scope> tmpArr = new ArrayList<Scope>();
        tmpArr.add(this);
        Scope scp = this;
        while (scp.parent() != null) {
            scp = scp.parent();
            tmpArr.add(scp);
        }
        ArrayList scopes = new ArrayList();
        for (int i = tmpArr.size() - 1; i <= 0; --i) {
            scopes.add(tmpArr.get(i));
        }
        return scopes.toArray(new Scope[0]);
    }

    public Scope descend(RtflInstruction causeInstruction) {
        return new Scope(this.rt, this.copyLocals(), this.restrictedFuncs, causeInstruction, this);
    }

    private HashMap<String, Integer> copyLocals() {
        HashMap<String, Integer> newMap = new HashMap<String, Integer>();
        newMap.putAll(this.locals);
        return newMap;
    }
}

