/*
 * Decompiled with CFR 0.152.
 */
package net.termer.rtflc.producers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.termer.rtflc.consumers.InstructionConsumer;
import net.termer.rtflc.instructions.ArrayAssignInstruction;
import net.termer.rtflc.instructions.AsyncInstruction;
import net.termer.rtflc.instructions.EndClauseInstruction;
import net.termer.rtflc.instructions.FuncCallInstruction;
import net.termer.rtflc.instructions.FuncDefInstruction;
import net.termer.rtflc.instructions.FuncUndefInstruction;
import net.termer.rtflc.instructions.IfInstruction;
import net.termer.rtflc.instructions.MapAssignInstruction;
import net.termer.rtflc.instructions.ReturnInstruction;
import net.termer.rtflc.instructions.TryInstruction;
import net.termer.rtflc.instructions.VarAssignInstruction;
import net.termer.rtflc.instructions.VarDefInstruction;
import net.termer.rtflc.instructions.VarLocalDefInstruction;
import net.termer.rtflc.instructions.VarUndefInstruction;
import net.termer.rtflc.instructions.WhileInstruction;
import net.termer.rtflc.producers.ProducerException;
import net.termer.rtflc.runtime.RuntimeException;
import net.termer.rtflc.type.BoolType;
import net.termer.rtflc.type.DoubleType;
import net.termer.rtflc.type.IntType;
import net.termer.rtflc.type.NullType;
import net.termer.rtflc.type.NumberType;
import net.termer.rtflc.type.RtflType;
import net.termer.rtflc.type.StringType;
import net.termer.rtflc.type.assignment.ArrayIndexAssignment;
import net.termer.rtflc.type.assignment.AssignmentType;
import net.termer.rtflc.type.assignment.FunctionCallAssignment;
import net.termer.rtflc.type.assignment.LogicAssignment;
import net.termer.rtflc.type.assignment.MapFieldAssignment;
import net.termer.rtflc.type.assignment.NotAssignment;
import net.termer.rtflc.type.assignment.VarRefAssignment;
import net.termer.rtflc.utils.LogicComparison;

public class SourcecodeInstructionProducer {
    private static final Pattern patGlobalVarDef = Pattern.compile("^def[ ]*([a-zA-Z0-9_-]*)[ ]*=[ ]*(.*)$");
    private static final Pattern patLocalVarDef = Pattern.compile("^local[ ]*([a-zA-Z0-9_-]*)[ ]*=[ ]*(.*)$");
    private static final Pattern patVarAssignment = Pattern.compile("^([a-zA-Z0-9_-]*)[ ]*=[ ]*(.*)$");
    private static final Pattern patVarUndef = Pattern.compile("^undef[ ]*([a-zA-Z0-9_-]*)$");
    private static final Pattern patFuncCall = Pattern.compile("^*([a-zA-Z0-9_-]*)\\((.*)\\)$");
    private static final Pattern patMethodCall = Pattern.compile("^(.+)\\.([a-zA-Z0-9_-]+)(\\((.*)\\))?$");
    private static final Pattern patReturn = Pattern.compile("^return (.*)$");
    private static final Pattern patIf = Pattern.compile("^if (.+)[ ]*\\{$");
    private static final Pattern patWhile = Pattern.compile("^while (.+)[ ]*\\{$");
    private static final Pattern patTry = Pattern.compile("^error ([a-zA-Z0-9_-]*)[ ]*\\{$");
    private static final Pattern patFuncDef = Pattern.compile("^func ([a-zA-Z0-9_-]*)[ ]*\\{$");
    private static final Pattern patFuncUndef = Pattern.compile("^unfunc[ ]*([a-zA-Z0-9_-]*)$");
    private static final Pattern patAsync = Pattern.compile("^async[ ]*\\{$");
    private static final Pattern patArrayAssignment = Pattern.compile("^(.+)[ ]*\\[[ ]*(.+)[ ]*\\][ ]*=[ ]*(.+)$");
    private static final Pattern patMapFieldAssignment = Pattern.compile("^(.+)->([a-zA-Z0-9_-]+)[ ]*=[ ]*(.+)$");
    private static final Pattern patFuncDefArgs = Pattern.compile("^func[ ]+([a-zA-Z0-9_-]*)\\([ ]*(.*)[ ]*\\)[ ]*\\{$");
    private static final Pattern patFunc = patFuncCall;
    private static final Pattern patMethod = patMethodCall;
    private static final Pattern patNumber = Pattern.compile("^(-?[0-9]*[\\.]?[0-9]*)?$");
    private static final Pattern patString = Pattern.compile("^\"(.*)\"$");
    private static final Pattern patVar = Pattern.compile("^([a-zA-Z0-9_.-]*)$");
    private static final Pattern patLogic = Pattern.compile("^\\!?\\[[ ]*(.+)[ ]*(=|&|\\||>|<)[ ]*(.+)[ ]*\\]$");
    private static final Pattern patSimpleLogic = Pattern.compile("^\\!?\\[[ ]*(.+)[ ]*\\]$");
    private static final Pattern patArrayIndex = Pattern.compile("(.+)[ ]*\\[[ ]*(.+)[ ]*\\]");
    private static final Pattern patMapField = Pattern.compile("(.+)->([a-zA-Z0-9_-]+)");

    public static void produce(String src, InputStream in, InstructionConsumer cons) throws IOException, ProducerException, RuntimeException {
        BufferedReader buf = new BufferedReader(new InputStreamReader(in, "UTF8"));
        int lnNum = 0;
        while (buf.ready()) {
            RtflType cond;
            String ln = buf.readLine().trim();
            if (ln.endsWith(";")) {
                ln = ln.substring(0, ln.length() - 1);
            }
            ++lnNum;
            Matcher lnMatch = patGlobalVarDef.matcher(ln);
            if (ln.length() <= 0 || ln.startsWith("//") || ln.startsWith("#")) continue;
            if (lnMatch.matches()) {
                cons.consume(new VarDefInstruction(src, lnNum, lnMatch.group(1), SourcecodeInstructionProducer.resolveValue(src, lnNum, lnMatch.group(2))));
                continue;
            }
            lnMatch = patLocalVarDef.matcher(ln);
            if (lnMatch.matches()) {
                cons.consume(new VarLocalDefInstruction(src, lnNum, lnMatch.group(1), SourcecodeInstructionProducer.resolveValue(src, lnNum, lnMatch.group(2))));
                continue;
            }
            lnMatch = patArrayAssignment.matcher(ln);
            if (lnMatch.matches()) {
                RtflType arr = SourcecodeInstructionProducer.resolveValue(src, lnNum, lnMatch.group(1));
                RtflType idx = SourcecodeInstructionProducer.resolveValue(src, lnNum, lnMatch.group(2));
                RtflType val = SourcecodeInstructionProducer.resolveValue(src, lnNum, lnMatch.group(3));
                if (!(idx instanceof AssignmentType) && !(idx instanceof NumberType)) {
                    throw new ProducerException("Non-number/bool value provided for logic expression", src, lnNum);
                }
                cons.consume(new ArrayAssignInstruction(src, lnNum, arr, idx, val));
                continue;
            }
            lnMatch = patMapFieldAssignment.matcher(ln);
            if (lnMatch.matches()) {
                RtflType map = SourcecodeInstructionProducer.resolveValue(src, lnNum, lnMatch.group(1));
                String field = lnMatch.group(2);
                RtflType value = SourcecodeInstructionProducer.resolveValue(src, lnNum, lnMatch.group(3));
                cons.consume(new MapAssignInstruction(src, lnNum, map, field, value));
                continue;
            }
            lnMatch = patVarAssignment.matcher(ln);
            if (lnMatch.matches()) {
                cons.consume(new VarAssignInstruction(src, lnNum, lnMatch.group(1), SourcecodeInstructionProducer.resolveValue(src, lnNum, lnMatch.group(2))));
                continue;
            }
            lnMatch = patVarUndef.matcher(ln);
            if (lnMatch.matches()) {
                cons.consume(new VarUndefInstruction(src, lnNum, lnMatch.group(1)));
                continue;
            }
            lnMatch = patReturn.matcher(ln);
            if (lnMatch.matches()) {
                cons.consume(new ReturnInstruction(src, lnNum, SourcecodeInstructionProducer.resolveValue(src, lnNum, lnMatch.group(1))));
                continue;
            }
            lnMatch = patFuncCall.matcher(ln);
            if (lnMatch.matches()) {
                String funcName = lnMatch.group(1);
                RtflType[] args = SourcecodeInstructionProducer.parseFuncArgs(src, lnNum, lnMatch.group(2).trim());
                FuncCallInstruction instr = new FuncCallInstruction(src, lnNum, funcName, args);
                cons.consume(instr);
                continue;
            }
            lnMatch = patMethodCall.matcher(ln);
            if (lnMatch.matches()) {
                RtflType exp = SourcecodeInstructionProducer.resolveValue(src, lnNum, lnMatch.group(1));
                String funcName = lnMatch.group(2);
                ArrayList<RtflType> args = new ArrayList<RtflType>();
                args.add(exp);
                if (lnMatch.group(4) != null) {
                    RtflType[] parseArgs;
                    for (RtflType arg : parseArgs = SourcecodeInstructionProducer.parseFuncArgs(src, lnNum, lnMatch.group(4))) {
                        args.add(arg);
                    }
                }
                FuncCallInstruction instr = new FuncCallInstruction(src, lnNum, funcName, args.toArray(new RtflType[0]));
                cons.consume(instr);
                continue;
            }
            lnMatch = patIf.matcher(ln);
            if (lnMatch.matches()) {
                cond = SourcecodeInstructionProducer.resolveValue(src, lnNum, lnMatch.group(1));
                if (cond instanceof AssignmentType || cond instanceof NumberType) {
                    cons.consume(new IfInstruction(src, lnNum, SourcecodeInstructionProducer.resolveValue(src, lnNum, lnMatch.group(1))));
                    continue;
                }
                throw new ProducerException("Non-number/bool value provided for 'if' instruction", src, lnNum);
            }
            lnMatch = patWhile.matcher(ln);
            if (lnMatch.matches()) {
                cond = SourcecodeInstructionProducer.resolveValue(src, lnNum, lnMatch.group(1));
                if (cond instanceof AssignmentType || cond instanceof NumberType) {
                    cons.consume(new WhileInstruction(src, lnNum, SourcecodeInstructionProducer.resolveValue(src, lnNum, lnMatch.group(1))));
                    continue;
                }
                throw new ProducerException("Non-number/bool value provided for 'while' instruction", src, lnNum);
            }
            lnMatch = patTry.matcher(ln);
            if (lnMatch.matches()) {
                cons.consume(new TryInstruction(src, lnNum, lnMatch.group(1)));
                continue;
            }
            lnMatch = patFuncDef.matcher(ln);
            if (lnMatch.matches()) {
                cons.consume(new FuncDefInstruction(src, lnNum, lnMatch.group(1)));
                continue;
            }
            lnMatch = patFuncDefArgs.matcher(ln);
            if (lnMatch.matches()) {
                String[] rawNames = lnMatch.group(2).split(",");
                ArrayList<String> names = new ArrayList<String>();
                for (String name : rawNames) {
                    if (!patVar.matcher(name.trim()).matches()) {
                        throw new ProducerException("Argument name cannot contain special characters");
                    }
                    names.add(name.trim());
                }
                cons.consume(new FuncDefInstruction(src, lnNum, lnMatch.group(1), names.toArray(new String[0])));
                continue;
            }
            lnMatch = patFuncUndef.matcher(ln);
            if (lnMatch.matches()) {
                cons.consume(new FuncUndefInstruction(src, lnNum, lnMatch.group(1)));
                continue;
            }
            lnMatch = patAsync.matcher(ln);
            if (lnMatch.matches()) {
                cons.consume(new AsyncInstruction(src, lnNum));
                continue;
            }
            if (ln.equalsIgnoreCase("}")) {
                cons.consume(new EndClauseInstruction(src, lnNum));
                continue;
            }
            throw new ProducerException("Encountered invalid expression: " + ln, src, lnNum);
        }
        cons.finish();
        buf.close();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RtflType resolveValue(String src, int ln, String value) throws ProducerException {
        void var3_22;
        Object var3_3 = null;
        String str = value.trim();
        Matcher valMatch = null;
        if (str.equalsIgnoreCase("null")) {
            NullType nullType = new NullType();
            return var3_22;
        } else if (str.equalsIgnoreCase("true")) {
            BoolType boolType = new BoolType(true);
            return var3_22;
        } else if (str.equalsIgnoreCase("false")) {
            BoolType boolType = new BoolType(false);
            return var3_22;
        } else {
            valMatch = patString.matcher(str);
            if (valMatch.matches()) {
                StringType stringType = new StringType(valMatch.group(1).replace("\\\\", "\\").replace("\\\"", "\"").replace("\\n", "\n").replace("\\t", "\t").replace("\\r", "\r").replace("\\b", "\b").replace("\\f", "\f"));
                return var3_22;
            } else {
                valMatch = patNumber.matcher(str);
                if (valMatch.matches()) {
                    NumberType numberType = str.contains(".") ? new DoubleType(Double.parseDouble(str)) : new IntType(Integer.parseInt(str));
                    return var3_22;
                } else {
                    valMatch = patFunc.matcher(str);
                    if (valMatch.matches()) {
                        String funcName = valMatch.group(1);
                        RtflType[] args = SourcecodeInstructionProducer.parseFuncArgs(src, ln, valMatch.group(2).trim());
                        FunctionCallAssignment functionCallAssignment = new FunctionCallAssignment(funcName, args);
                        return var3_22;
                    } else {
                        valMatch = patMethod.matcher(str);
                        if (valMatch.matches()) {
                            RtflType exp = SourcecodeInstructionProducer.resolveValue(src, ln, valMatch.group(1));
                            String funcName = valMatch.group(2);
                            ArrayList<RtflType> args = new ArrayList<RtflType>();
                            args.add(exp);
                            if (valMatch.group(4) != null) {
                                RtflType[] parseArgs;
                                for (RtflType arg : parseArgs = SourcecodeInstructionProducer.parseFuncArgs(src, ln, valMatch.group(4))) {
                                    args.add(arg);
                                }
                            }
                            FunctionCallAssignment functionCallAssignment = new FunctionCallAssignment(funcName, args.toArray(new RtflType[0]));
                            return var3_22;
                        } else {
                            valMatch = patVar.matcher(str);
                            if (valMatch.matches()) {
                                VarRefAssignment varRefAssignment = new VarRefAssignment(valMatch.group(1));
                                return var3_22;
                            } else {
                                valMatch = patLogic.matcher(str);
                                if (valMatch.matches()) {
                                    RtflType val1 = SourcecodeInstructionProducer.resolveValue(src, ln, valMatch.group(1));
                                    RtflType val2 = SourcecodeInstructionProducer.resolveValue(src, ln, valMatch.group(3));
                                    LogicComparison comp = LogicComparison.byChar(valMatch.group(2).charAt(0));
                                    if ((val1 instanceof AssignmentType || val1 instanceof NumberType) && (val2 instanceof AssignmentType || val2 instanceof NumberType)) {
                                        LogicAssignment logicAssignment = new LogicAssignment(val1, comp, val2, str.startsWith("!"));
                                        return var3_22;
                                    } else {
                                        if (comp != LogicComparison.EQUAL) {
                                            throw new ProducerException("Non-number/bool value provided for logic expression", src, ln);
                                        }
                                        LogicAssignment logicAssignment = new LogicAssignment(val1, comp, val2, str.startsWith("!"));
                                    }
                                    return var3_22;
                                } else {
                                    valMatch = patSimpleLogic.matcher(str);
                                    if (valMatch.matches()) {
                                        RtflType logicVal = SourcecodeInstructionProducer.resolveValue(src, ln, valMatch.group(1));
                                        if (logicVal instanceof AssignmentType) {
                                            if (str.startsWith("!")) {
                                                NotAssignment notAssignment = new NotAssignment(logicVal);
                                                return var3_22;
                                            } else {
                                                RtflType rtflType = logicVal;
                                            }
                                            return var3_22;
                                        } else {
                                            if (!(logicVal instanceof NumberType)) throw new ProducerException("Non-number/bool value provided for logic expression", src, ln);
                                            if (str.startsWith("!")) {
                                                BoolType boolType = new BoolType(!(((NumberType)logicVal).toDouble() > 0.0));
                                                return var3_22;
                                            } else {
                                                BoolType boolType = new BoolType(((NumberType)logicVal).toDouble() > 0.0);
                                            }
                                        }
                                        return var3_22;
                                    } else {
                                        valMatch = patArrayIndex.matcher(str);
                                        if (valMatch.matches()) {
                                            RtflType arr = SourcecodeInstructionProducer.resolveValue(src, ln, valMatch.group(1));
                                            RtflType idx = SourcecodeInstructionProducer.resolveValue(src, ln, valMatch.group(2));
                                            if (!(idx instanceof NumberType) && !(idx instanceof AssignmentType)) {
                                                throw new ProducerException("Non-number value provided as array index", src, ln);
                                            }
                                            ArrayIndexAssignment arrayIndexAssignment = new ArrayIndexAssignment(arr, idx);
                                            return var3_22;
                                        } else {
                                            valMatch = patMapField.matcher(str);
                                            if (!valMatch.matches()) throw new ProducerException("Encountered invalid value expression: " + str, src, ln);
                                            RtflType map = SourcecodeInstructionProducer.resolveValue(src, ln, valMatch.group(1));
                                            String field = valMatch.group(2);
                                            MapFieldAssignment mapFieldAssignment = new MapFieldAssignment(map, field);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return var3_22;
    }

    private static RtflType[] parseFuncArgs(String src, int ln, String argStr) throws ProducerException {
        char[] chars = argStr.toCharArray();
        boolean openQuote = false;
        int openPars = 0;
        ArrayList<RtflType> args = new ArrayList<RtflType>();
        StringBuilder argBuf = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (i < 1 && c == '\"') {
                openQuote = !openQuote;
            } else if (c == '\"' && (i > 0 && chars[i - 1] != '\\' || i > 1 && chars[i - 2] == '\\')) {
                openQuote = !openQuote;
            } else if (c == '\"' && i > 1 && chars[i - 2] == '\\') {
                boolean bl = openQuote = !openQuote;
            }
            if (!openQuote) {
                switch (c) {
                    case '(': {
                        ++openPars;
                        break;
                    }
                    case ')': {
                        if (openPars <= -1) break;
                        --openPars;
                    }
                }
            }
            if (!openQuote && openPars < 1 && c == ',') {
                args.add(SourcecodeInstructionProducer.resolveValue(src, ln, argBuf.toString()));
                argBuf = new StringBuilder();
                continue;
            }
            argBuf.append(c);
        }
        String lastArg = argBuf.toString().trim();
        if (lastArg.length() > 0) {
            args.add(SourcecodeInstructionProducer.resolveValue(src, ln, lastArg));
        }
        return args.toArray(new RtflType[0]);
    }
}

