/*
 * Decompiled with CFR 0.152.
 */
package net.termer.rtflc.producers;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.termer.rtflc.consumers.InstructionConsumer;
import net.termer.rtflc.instructions.ArrayAssignInstruction;
import net.termer.rtflc.instructions.AscendScopeInstruction;
import net.termer.rtflc.instructions.AsyncInstruction;
import net.termer.rtflc.instructions.DescendScopeInstruction;
import net.termer.rtflc.instructions.EndClauseInstruction;
import net.termer.rtflc.instructions.FuncCallInstruction;
import net.termer.rtflc.instructions.FuncDefInstruction;
import net.termer.rtflc.instructions.FuncUndefInstruction;
import net.termer.rtflc.instructions.IfInstruction;
import net.termer.rtflc.instructions.MapAssignInstruction;
import net.termer.rtflc.instructions.ReturnInstruction;
import net.termer.rtflc.instructions.TryInstruction;
import net.termer.rtflc.instructions.VarAssignInstruction;
import net.termer.rtflc.instructions.VarDefInstruction;
import net.termer.rtflc.instructions.VarLocalDefInstruction;
import net.termer.rtflc.instructions.VarUndefInstruction;
import net.termer.rtflc.instructions.WhileInstruction;
import net.termer.rtflc.producers.ProducerException;
import net.termer.rtflc.runtime.RuntimeException;
import net.termer.rtflc.type.BoolType;
import net.termer.rtflc.type.DoubleType;
import net.termer.rtflc.type.IntType;
import net.termer.rtflc.type.NullType;
import net.termer.rtflc.type.NumberType;
import net.termer.rtflc.type.RtflType;
import net.termer.rtflc.type.StringType;
import net.termer.rtflc.type.assignment.ArrayIndexAssignment;
import net.termer.rtflc.type.assignment.AssignmentType;
import net.termer.rtflc.type.assignment.FunctionCallAssignment;
import net.termer.rtflc.type.assignment.LogicAssignment;
import net.termer.rtflc.type.assignment.MapFieldAssignment;
import net.termer.rtflc.type.assignment.NotAssignment;
import net.termer.rtflc.type.assignment.VarRefAssignment;
import net.termer.rtflc.utils.LogicComparison;

public class BytecodeInstructionProducer {
    public static void produce(String src, InputStream in, InstructionConsumer cons, boolean readLines) throws IOException, ProducerException, RuntimeException {
        BufferedInputStream buf = new BufferedInputStream(in);
        while (buf.available() > 0) {
            int i;
            short ln = readLines ? BytecodeInstructionProducer.readShort(buf) : (short)0;
            int opcode = buf.read();
            if (opcode == 0) {
                int nlen = buf.read();
                StringBuilder name = new StringBuilder(nlen);
                for (int i2 = 0; i2 < nlen; ++i2) {
                    name.append((char)buf.read());
                }
                RtflType val = BytecodeInstructionProducer.resolveVal(buf, src, ln);
                cons.consume(new VarDefInstruction(src, ln, name.toString(), val));
                continue;
            }
            if (opcode == 1) {
                int nlen = buf.read();
                StringBuilder name = new StringBuilder(nlen);
                for (int i3 = 0; i3 < nlen; ++i3) {
                    name.append((char)buf.read());
                }
                RtflType val = BytecodeInstructionProducer.resolveVal(buf, src, ln);
                cons.consume(new VarLocalDefInstruction(src, ln, name.toString(), val));
                continue;
            }
            if (opcode == 2) {
                int nlen = buf.read();
                StringBuilder name = new StringBuilder(nlen);
                for (int i4 = 0; i4 < nlen; ++i4) {
                    name.append((char)buf.read());
                }
                RtflType val = BytecodeInstructionProducer.resolveVal(buf, src, ln);
                cons.consume(new VarAssignInstruction(src, ln, name.toString(), val));
                continue;
            }
            if (opcode == 3) {
                int nlen = buf.read();
                StringBuilder name = new StringBuilder(nlen);
                for (int i5 = 0; i5 < nlen; ++i5) {
                    name.append((char)buf.read());
                }
                cons.consume(new VarUndefInstruction(src, ln, name.toString()));
                continue;
            }
            if (opcode == 4) {
                int nlen = buf.read();
                StringBuilder name = new StringBuilder(nlen);
                for (int i6 = 0; i6 < nlen; ++i6) {
                    name.append((char)buf.read());
                }
                int arglen = buf.read();
                ArrayList<RtflType> args = new ArrayList<RtflType>();
                for (i = 0; i < arglen; ++i) {
                    args.add(BytecodeInstructionProducer.resolveVal(buf, src, ln));
                }
                cons.consume(new FuncCallInstruction(src, ln, name.toString(), args.toArray(new RtflType[0])));
                continue;
            }
            if (opcode == 5) {
                RtflType returnVal = BytecodeInstructionProducer.resolveVal(buf, src, ln);
                cons.consume(new ReturnInstruction(src, ln, returnVal));
                continue;
            }
            if (opcode == 6) {
                RtflType condition = BytecodeInstructionProducer.resolveVal(buf, src, ln);
                if (condition instanceof NumberType || condition instanceof AssignmentType) {
                    cons.consume(new IfInstruction(src, ln, condition));
                    continue;
                }
                throw new ProducerException("Non-number/bool value provided for 'if' instruction", src, ln);
            }
            if (opcode == 7) {
                RtflType condition = BytecodeInstructionProducer.resolveVal(buf, src, ln);
                if (condition instanceof NumberType || condition instanceof AssignmentType) {
                    cons.consume(new WhileInstruction(src, ln, condition));
                    continue;
                }
                throw new ProducerException("Non-number/bool value provided for 'while' instruction", src, ln);
            }
            if (opcode == 8) {
                int nlen = buf.read();
                StringBuilder name = new StringBuilder(nlen);
                for (int i7 = 0; i7 < nlen; ++i7) {
                    name.append((char)buf.read());
                }
                cons.consume(new TryInstruction(src, ln, name.toString()));
                continue;
            }
            if (opcode == 9) {
                cons.consume(new EndClauseInstruction(src, ln));
                continue;
            }
            if (opcode == 10) {
                int nlen = buf.read();
                StringBuilder name = new StringBuilder(nlen);
                for (int i8 = 0; i8 < nlen; ++i8) {
                    name.append((char)buf.read());
                }
                int argNameCount = buf.read();
                String[] argNames = new String[argNameCount];
                for (i = 0; i < argNameCount; ++i) {
                    int nameLen = buf.read();
                    StringBuilder argName = new StringBuilder(nameLen);
                    for (int j = 0; j < nameLen; ++j) {
                        argName.append((char)buf.read());
                    }
                    argNames[i] = argName.toString();
                }
                cons.consume(new FuncDefInstruction(src, ln, name.toString(), argNames));
                continue;
            }
            if (opcode == 11) {
                int nlen = buf.read();
                StringBuilder name = new StringBuilder(nlen);
                for (int i9 = 0; i9 < nlen; ++i9) {
                    name.append((char)buf.read());
                }
                cons.consume(new FuncUndefInstruction(src, ln, name.toString()));
                break;
            }
            if (opcode == 12) {
                cons.consume(new AsyncInstruction(src, ln));
                continue;
            }
            if (opcode == 13) {
                int nlen = buf.read();
                StringBuilder name = new StringBuilder(nlen);
                for (int i10 = 0; i10 < nlen; ++i10) {
                    name.append((char)buf.read());
                }
                src = name.toString();
                continue;
            }
            if (opcode == 14) {
                cons.consume(new DescendScopeInstruction());
                continue;
            }
            if (opcode == 15) {
                cons.consume(new AscendScopeInstruction());
                continue;
            }
            if (opcode == 16) {
                RtflType array = BytecodeInstructionProducer.resolveVal(buf, src, ln);
                RtflType index = BytecodeInstructionProducer.resolveVal(buf, src, ln);
                RtflType value = BytecodeInstructionProducer.resolveVal(buf, src, ln);
                cons.consume(new ArrayAssignInstruction(src, ln, array, index, value));
                continue;
            }
            if (opcode == 17) {
                RtflType map = BytecodeInstructionProducer.resolveVal(buf, src, ln);
                int fieldLen = buf.read();
                StringBuilder field = new StringBuilder(fieldLen);
                for (int i11 = 0; i11 < fieldLen; ++i11) {
                    field.append((char)buf.read());
                }
                RtflType value = BytecodeInstructionProducer.resolveVal(buf, src, ln);
                cons.consume(new MapAssignInstruction(src, ln, map, field.toString(), value));
                continue;
            }
            throw new ProducerException("Encountered invalid opcode \"" + opcode + "\", perhaps this was compiled for a newer version of Rtfl?");
        }
        cons.finish();
        buf.close();
    }

    public static RtflType resolveVal(InputStream in, String src, int ln) throws IOException, ProducerException {
        RtflType val = null;
        int type = in.read();
        switch (type) {
            case 0: {
                val = new NullType();
                break;
            }
            case 1: {
                val = new BoolType(in.read() > 0);
                break;
            }
            case 2: {
                val = new IntType(BytecodeInstructionProducer.readInt(in));
                break;
            }
            case 3: {
                val = new DoubleType(BytecodeInstructionProducer.readDouble(in));
                break;
            }
            case 4: {
                byte[] str = new byte[in.read()];
                in.read(str);
                val = new StringType(new String(str, StandardCharsets.UTF_8));
                break;
            }
            case 5: {
                byte[] strBytes = new byte[BytecodeInstructionProducer.readShort(in)];
                in.read(strBytes);
                val = new StringType(new String(strBytes, StandardCharsets.UTF_8));
                break;
            }
            case 6: {
                int nlen = in.read();
                StringBuilder name = new StringBuilder(nlen);
                for (int i = 0; i < nlen; ++i) {
                    name.append((char)in.read());
                }
                int arglen = in.read();
                ArrayList<RtflType> args = new ArrayList<RtflType>();
                for (int i = 0; i < arglen; ++i) {
                    args.add(BytecodeInstructionProducer.resolveVal(in, src, ln));
                }
                val = new FunctionCallAssignment(name.toString(), args.toArray(new RtflType[0]));
                break;
            }
            case 7: {
                int vlen = in.read();
                StringBuilder varName = new StringBuilder(vlen);
                for (int i = 0; i < vlen; ++i) {
                    varName.append((char)in.read());
                }
                val = new VarRefAssignment(varName.toString());
                break;
            }
            case 8: {
                LogicComparison compType = LogicComparison.values()[in.read()];
                boolean inverse = in.read() > 0;
                RtflType comp1 = BytecodeInstructionProducer.resolveVal(in, src, ln);
                RtflType comp2 = BytecodeInstructionProducer.resolveVal(in, src, ln);
                val = new LogicAssignment(comp1, compType, comp2, inverse);
                break;
            }
            case 9: {
                val = new NotAssignment(BytecodeInstructionProducer.resolveVal(in, src, ln));
                break;
            }
            case 10: {
                RtflType array = BytecodeInstructionProducer.resolveVal(in, src, ln);
                RtflType index = BytecodeInstructionProducer.resolveVal(in, src, ln);
                val = new ArrayIndexAssignment(array, index);
                break;
            }
            case 11: {
                RtflType map = BytecodeInstructionProducer.resolveVal(in, src, ln);
                int fieldLen = in.read();
                StringBuffer fieldName = new StringBuffer(fieldLen);
                for (int i = 0; i < fieldLen; ++i) {
                    fieldName.append((char)in.read());
                }
                val = new MapFieldAssignment(map, fieldName.toString());
                break;
            }
            default: {
                throw new ProducerException("Encountered invalid value type \"" + type + "\", perhaps this was compiled for a newer version of Rtfl?", src, ln);
            }
        }
        return val;
    }

    private static short readShort(InputStream in) throws IOException {
        byte[] bytes = new byte[2];
        for (int i = 0; i < 2; ++i) {
            bytes[i] = (byte)in.read();
        }
        ByteBuffer.allocate(2);
        return ByteBuffer.wrap(bytes).getShort();
    }

    private static int readInt(InputStream in) throws IOException {
        byte[] bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            bytes[i] = (byte)in.read();
        }
        ByteBuffer.allocate(4);
        return ByteBuffer.wrap(bytes).getInt();
    }

    private static double readDouble(InputStream in) throws IOException {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)in.read();
        }
        ByteBuffer.allocate(8);
        return ByteBuffer.wrap(bytes).getDouble();
    }
}

