/*
 * Decompiled with CFR 0.152.
 */
package net.termer.rtflc.consumers;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.termer.rtflc.compiler.CompilerException;
import net.termer.rtflc.consumers.InstructionConsumer;
import net.termer.rtflc.instructions.ArrayAssignInstruction;
import net.termer.rtflc.instructions.AscendScopeInstruction;
import net.termer.rtflc.instructions.AsyncInstruction;
import net.termer.rtflc.instructions.DescendScopeInstruction;
import net.termer.rtflc.instructions.EndClauseInstruction;
import net.termer.rtflc.instructions.FuncCallInstruction;
import net.termer.rtflc.instructions.FuncDefInstruction;
import net.termer.rtflc.instructions.FuncUndefInstruction;
import net.termer.rtflc.instructions.IfInstruction;
import net.termer.rtflc.instructions.MapAssignInstruction;
import net.termer.rtflc.instructions.ReturnInstruction;
import net.termer.rtflc.instructions.RtflInstruction;
import net.termer.rtflc.instructions.TryInstruction;
import net.termer.rtflc.instructions.VarAssignInstruction;
import net.termer.rtflc.instructions.VarDefInstruction;
import net.termer.rtflc.instructions.VarLocalDefInstruction;
import net.termer.rtflc.instructions.VarUndefInstruction;
import net.termer.rtflc.instructions.WhileInstruction;
import net.termer.rtflc.type.BoolType;
import net.termer.rtflc.type.DoubleType;
import net.termer.rtflc.type.IntType;
import net.termer.rtflc.type.NullType;
import net.termer.rtflc.type.NumberType;
import net.termer.rtflc.type.RtflType;
import net.termer.rtflc.type.StringType;
import net.termer.rtflc.type.assignment.ArrayIndexAssignment;
import net.termer.rtflc.type.assignment.AssignmentType;
import net.termer.rtflc.type.assignment.FunctionCallAssignment;
import net.termer.rtflc.type.assignment.LogicAssignment;
import net.termer.rtflc.type.assignment.MapFieldAssignment;
import net.termer.rtflc.type.assignment.NotAssignment;
import net.termer.rtflc.type.assignment.VarRefAssignment;

public class CompilerInstructionConsumer
implements InstructionConsumer {
    private OutputStream out = null;
    private boolean writeLns = true;

    public CompilerInstructionConsumer(OutputStream output, boolean writeLines) {
        this.out = output;
        this.writeLns = writeLines;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void consume(RtflInstruction inst) throws IOException {
        if (this.writeLns) {
            this.writeShort((short)inst.originLine());
        }
        if (inst instanceof VarDefInstruction) {
            VarDefInstruction ins = (VarDefInstruction)inst;
            this.out.write(0);
            this.out.write((byte)ins.variableName().length());
            this.writeStr(ins.variableName());
            this.writeVal(ins.variableValue());
            return;
        } else if (inst instanceof VarLocalDefInstruction) {
            VarLocalDefInstruction ins = (VarLocalDefInstruction)inst;
            this.out.write(1);
            this.out.write((byte)ins.variableName().length());
            this.writeStr(ins.variableName());
            this.writeVal(ins.variableValue());
            return;
        } else if (inst instanceof VarAssignInstruction) {
            VarAssignInstruction ins = (VarAssignInstruction)inst;
            this.out.write(2);
            this.out.write((byte)ins.variableName().length());
            this.writeStr(ins.variableName());
            this.writeVal(ins.assignValue());
            return;
        } else if (inst instanceof VarUndefInstruction) {
            VarUndefInstruction ins = (VarUndefInstruction)inst;
            this.out.write(3);
            this.out.write((byte)ins.variableName().length());
            this.writeStr(ins.variableName());
            return;
        } else if (inst instanceof FuncCallInstruction) {
            FuncCallInstruction ins = (FuncCallInstruction)inst;
            this.out.write(4);
            this.out.write(ins.functionName().length());
            this.writeStr(ins.functionName());
            this.out.write(ins.functionArguments().length);
            for (RtflType arg : ins.functionArguments()) {
                this.writeVal(arg);
            }
            return;
        } else if (inst instanceof ReturnInstruction) {
            ReturnInstruction ins = (ReturnInstruction)inst;
            this.out.write(5);
            this.writeVal(ins.returnValue());
            return;
        } else if (inst instanceof IfInstruction) {
            IfInstruction ins = (IfInstruction)inst;
            this.out.write(6);
            RtflType cond = ins.condition();
            if (!(cond instanceof NumberType) && !(cond instanceof AssignmentType)) throw new CompilerException("Non-number/bool value provided for 'if' instruction");
            this.writeVal(cond);
            return;
        } else if (inst instanceof WhileInstruction) {
            WhileInstruction ins = (WhileInstruction)inst;
            this.out.write(7);
            RtflType cond = ins.condition();
            if (!(cond instanceof NumberType) && !(cond instanceof AssignmentType)) throw new CompilerException("Non-number/bool value provided for 'while' instruction");
            this.writeVal(cond);
            return;
        } else if (inst instanceof TryInstruction) {
            TryInstruction ins = (TryInstruction)inst;
            this.out.write(8);
            this.out.write(ins.variableName().length());
            this.writeStr(ins.variableName());
            return;
        } else if (inst instanceof EndClauseInstruction) {
            this.out.write(9);
            return;
        } else if (inst instanceof FuncDefInstruction) {
            FuncDefInstruction ins = (FuncDefInstruction)inst;
            this.out.write(10);
            this.out.write(ins.functionName().length());
            this.writeStr(ins.functionName());
            this.out.write(ins.argumentNames().length);
            for (String name : ins.argumentNames()) {
                this.out.write(name.length());
                this.writeStr(name);
            }
            return;
        } else if (inst instanceof FuncUndefInstruction) {
            FuncUndefInstruction ins = (FuncUndefInstruction)inst;
            this.out.write(11);
            this.out.write(ins.functionName().length());
            this.writeStr(ins.functionName());
            return;
        } else if (inst instanceof AsyncInstruction) {
            this.out.write(12);
            return;
        } else if (inst instanceof DescendScopeInstruction) {
            this.out.write(14);
            return;
        } else if (inst instanceof AscendScopeInstruction) {
            this.out.write(15);
            return;
        } else if (inst instanceof ArrayAssignInstruction) {
            ArrayAssignInstruction ins = (ArrayAssignInstruction)inst;
            this.out.write(16);
            this.writeVal(ins.array());
            this.writeVal(ins.index());
            this.writeVal(ins.assignValue());
            return;
        } else {
            if (!(inst instanceof MapAssignInstruction)) return;
            MapAssignInstruction ins = (MapAssignInstruction)inst;
            this.out.write(17);
            this.writeVal(ins.map());
            this.out.write(ins.field().length());
            this.writeStr(ins.field());
            this.writeVal(ins.assignValue());
        }
    }

    private void writeShort(short val) throws IOException {
        this.out.write(ByteBuffer.allocate(2).putShort(val).array());
    }

    private void writeInt(int val) throws IOException {
        this.out.write(ByteBuffer.allocate(4).putInt(val).array());
    }

    private void writeDouble(double val) throws IOException {
        this.out.write(ByteBuffer.allocate(8).putDouble(val).array());
    }

    private void writeStr(String str) throws IOException {
        this.out.write(str.getBytes(StandardCharsets.UTF_8));
    }

    private void writeVal(RtflType val) throws IOException {
        if (val instanceof NullType) {
            this.out.write(0);
        } else if (val instanceof BoolType) {
            this.out.write(1);
            this.out.write(((BoolType)val).toInt());
        } else if (val instanceof IntType) {
            this.out.write(2);
            this.writeInt(((IntType)val).toInt());
        } else if (val instanceof DoubleType) {
            this.out.write(3);
            this.writeDouble(((DoubleType)val).toDouble());
        } else if (val instanceof StringType) {
            String str = (String)val.value();
            if (str.length() > 256) {
                this.out.write(5);
                this.writeShort((short)str.length());
                this.writeStr(str);
            } else {
                this.out.write(4);
                this.out.write(str.length());
                this.writeStr(str);
            }
        } else if (val instanceof FunctionCallAssignment) {
            this.out.write(6);
            FunctionCallAssignment call = (FunctionCallAssignment)val;
            this.out.write(call.functionName().length());
            this.writeStr(call.functionName());
            this.out.write(call.functionArgs().length);
            for (RtflType arg : call.functionArgs()) {
                this.writeVal(arg);
            }
        } else if (val instanceof VarRefAssignment) {
            this.out.write(7);
            VarRefAssignment var = (VarRefAssignment)val;
            this.out.write(var.variableName().length());
            this.writeStr(var.variableName());
        } else if (val instanceof LogicAssignment) {
            this.out.write(8);
            LogicAssignment var = (LogicAssignment)val;
            this.out.write(var.comparisonType().ordinal());
            this.out.write(var.inverse() ? 1 : 0);
            this.writeVal(var.firstValue());
            this.writeVal(var.secondValue());
        } else if (val instanceof NotAssignment) {
            this.out.write(9);
            NotAssignment var = (NotAssignment)val;
            this.writeVal(var.originalValue());
        } else if (val instanceof ArrayIndexAssignment) {
            this.out.write(10);
            ArrayIndexAssignment var = (ArrayIndexAssignment)val;
            this.writeVal(var.array());
            this.writeVal(var.index());
        } else if (val instanceof MapFieldAssignment) {
            this.out.write(11);
            MapFieldAssignment var = (MapFieldAssignment)val;
            this.writeVal(var.map());
            this.out.write(var.field().length());
            this.writeStr(var.field());
        } else {
            throw new CompilerException("Failed to write unknown value type " + val.getClass().getName());
        }
    }

    @Override
    public void finish() {
    }
}

