/*
 * Decompiled with CFR 0.152.
 */
package net.termer.rtflc.runtime;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import net.termer.rtflc.instructions.ArrayAssignInstruction;
import net.termer.rtflc.instructions.AscendScopeInstruction;
import net.termer.rtflc.instructions.AsyncInstruction;
import net.termer.rtflc.instructions.ClauseOpenerInstruction;
import net.termer.rtflc.instructions.DescendScopeInstruction;
import net.termer.rtflc.instructions.EndClauseInstruction;
import net.termer.rtflc.instructions.FuncCallInstruction;
import net.termer.rtflc.instructions.FuncDefInstruction;
import net.termer.rtflc.instructions.FuncUndefInstruction;
import net.termer.rtflc.instructions.IfInstruction;
import net.termer.rtflc.instructions.MapAssignInstruction;
import net.termer.rtflc.instructions.ReturnInstruction;
import net.termer.rtflc.instructions.RtflInstruction;
import net.termer.rtflc.instructions.TryInstruction;
import net.termer.rtflc.instructions.VarAssignInstruction;
import net.termer.rtflc.instructions.VarDefInstruction;
import net.termer.rtflc.instructions.VarLocalDefInstruction;
import net.termer.rtflc.instructions.VarUndefInstruction;
import net.termer.rtflc.instructions.WhileInstruction;
import net.termer.rtflc.producers.BytecodeInstructionProducer;
import net.termer.rtflc.producers.ProducerException;
import net.termer.rtflc.producers.SourcecodeInstructionProducer;
import net.termer.rtflc.runtime.InstructionFunction;
import net.termer.rtflc.runtime.JavaInteropFunctions;
import net.termer.rtflc.runtime.RtflFunction;
import net.termer.rtflc.runtime.RuntimeException;
import net.termer.rtflc.runtime.Scope;
import net.termer.rtflc.runtime.StandardFunctions;
import net.termer.rtflc.type.ArrayType;
import net.termer.rtflc.type.MapType;
import net.termer.rtflc.type.NullType;
import net.termer.rtflc.type.NumberType;
import net.termer.rtflc.type.RtflType;
import net.termer.rtflc.type.StringType;
import net.termer.rtflc.type.assignment.AssignmentType;
import net.termer.rtflc.utils.CacheInstructionConsumer;
import net.termer.rtflc.utils.RtflFunctionBuilder;

public class RtflRuntime {
    private ConcurrentHashMap<String, RtflFunction> _functions = new ConcurrentHashMap();
    private ConcurrentHashMap<String, RtflType> _variables = new ConcurrentHashMap();
    private ConcurrentHashMap<Integer, LocalVar> _localVars = new ConcurrentHashMap();
    private GarbageCollector _gc = null;
    private BufferedReader _terminalIn = null;
    private int _nextVarId = 0;
    private Scope _topScope = new Scope(this, new HashMap<String, Integer>(), null);

    public static boolean isCompiledScript(InputStream in) throws IOException {
        byte[] signature = new byte[4];
        in.read(signature);
        return new String(signature).equals("\u0001\u0003\u0003\u0007");
    }

    public static RtflMetadata readCompiledMetadata(InputStream in) throws IOException {
        int compVer = in.read();
        int rtflVer = in.read();
        int nameLen = in.read();
        byte[] filename = new byte[nameLen];
        in.read(filename);
        boolean hasLineNums = in.read() > 0;
        return new RtflMetadata(new String(filename), compVer, rtflVer, hasLineNums);
    }

    public RtflRuntime() {
        this._gc = new GarbageCollector(20000L, this);
        this._gc.setDaemon(true);
        this._gc.setName("RtflGC-" + this.newId());
        this._gc.start();
    }

    public RtflRuntime openTerminal() {
        if (this._terminalIn == null) {
            this._terminalIn = new BufferedReader(new InputStreamReader(System.in));
        }
        return this;
    }

    public RtflRuntime closeTerminal() throws RuntimeException {
        if (this._terminalIn != null) {
            try {
                this._terminalIn.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to close terminal: " + e.getMessage());
            }
            finally {
                this._terminalIn = null;
            }
        }
        return this;
    }

    public boolean terminalOpen() {
        return this._terminalIn != null;
    }

    public String readTerminal() throws RuntimeException {
        String in = null;
        if (this._terminalIn == null) {
            throw new RuntimeException("Terminal is not open");
        }
        try {
            in = this._terminalIn.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading terminal input: " + e.getMessage());
        }
        return in;
    }

    public RtflType execute(RtflInstruction[] instructions) throws RuntimeException {
        return this.execute(instructions, this._topScope);
    }

    public RtflType execute(RtflInstruction[] instructions, Scope scope) throws RuntimeException {
        return this.execute(instructions, scope, false);
    }

    public RtflType execute(String code) throws RuntimeException, IOException, ProducerException {
        return this.execute(code, this._topScope);
    }

    public RtflType execute(String code, Scope scope) throws RuntimeException, IOException, ProducerException {
        CacheInstructionConsumer cache = new CacheInstructionConsumer();
        SourcecodeInstructionProducer.produce("eval", new ByteArrayInputStream(code.getBytes()), cache);
        return this.execute(cache.cache.toArray(new RtflInstruction[0]), scope, true);
    }

    public RtflRuntime executeAsync(RtflInstruction[] instructions, Scope scope) {
        Thread asyncThread = new Thread(() -> {
            try {
                this.execute(instructions, scope, true);
            }
            catch (RuntimeException e) {
                String where = e.cause() == null ? "unknown:0" : e.cause().originFile() + ':' + e.cause().originLine();
                System.err.println("(async) " + where + ' ' + e.getMessage());
            }
        });
        asyncThread.setName("RtflWorker-" + this.newId());
        for (int localId : scope.variableAliases().values()) {
            this._localVars.get(localId).addOwner(asyncThread.getName());
        }
        asyncThread.start();
        return this;
    }

    public RtflType executeFile(File file) throws IOException, RuntimeException, ProducerException {
        return this.executeFile(file, this._topScope);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RtflType executeFile(File file, Scope scope) throws IOException, RuntimeException, ProducerException {
        CacheInstructionConsumer cache = new CacheInstructionConsumer();
        RtflType result = null;
        if (!file.exists()) throw new RuntimeException("Provided file does not exist");
        if (!file.isFile()) throw new RuntimeException("Provided path is not a file");
        FileInputStream fin = new FileInputStream(file);
        if (RtflRuntime.isCompiledScript(fin)) {
            RtflMetadata meta = RtflRuntime.readCompiledMetadata(fin);
            if (meta.rtflVersion > 4) {
                throw new RuntimeException("Binary was compiled for a newer version of Rtfl (compiled for " + meta.rtflVersion + ", running " + 4 + ')');
            }
            BytecodeInstructionProducer.produce(meta.fileName, fin, cache, meta.hasLineNumbers);
            return this.execute(cache.cache.toArray(new RtflInstruction[0]), scope);
        } else {
            fin.close();
            fin = new FileInputStream(file);
            SourcecodeInstructionProducer.produce(file.getName(), fin, cache);
        }
        return this.execute(cache.cache.toArray(new RtflInstruction[0]), scope);
    }

    public RtflType execute(RtflInstruction[] instructions, Scope scope, boolean disownAll) throws RuntimeException {
        RtflType val = new NullType();
        ArrayList<Integer> localIds = new ArrayList<Integer>();
        block4: for (int i = 0; i < instructions.length; ++i) {
            RtflInstruction inst = instructions[i];
            try {
                RtflInstruction _inst;
                if (inst instanceof VarDefInstruction) {
                    VarDefInstruction ins = (VarDefInstruction)inst;
                    this._variables.put(ins.variableName(), this.resolveValue(ins.variableValue(), scope));
                    continue;
                }
                if (inst instanceof VarLocalDefInstruction) {
                    VarLocalDefInstruction ins = (VarLocalDefInstruction)inst;
                    int varId = scope.createLocalVar(ins.variableName(), this.resolveValue(ins.variableValue(), scope));
                    localIds.add(varId);
                    continue;
                }
                if (inst instanceof VarAssignInstruction) {
                    VarAssignInstruction ins = (VarAssignInstruction)inst;
                    scope.assignVar(ins.variableName(), this.resolveValue(ins.assignValue(), scope));
                    continue;
                }
                if (inst instanceof ArrayAssignInstruction) {
                    ArrayAssignInstruction ins = (ArrayAssignInstruction)inst;
                    RtflType array = this.resolveValue(ins.array(), scope);
                    RtflType index = this.resolveValue(ins.index(), scope);
                    RtflType value = this.resolveValue(ins.assignValue(), scope);
                    if (!(array instanceof ArrayType)) {
                        throw new RuntimeException("Cannot get element from non-array", inst);
                    }
                    if (!(index instanceof NumberType)) {
                        throw new RuntimeException("Provided non-number index");
                    }
                    ((ArrayList)array.value()).set(((NumberType)index).toInt(), value);
                    continue;
                }
                if (inst instanceof MapAssignInstruction) {
                    MapAssignInstruction ins = (MapAssignInstruction)inst;
                    RtflType map = this.resolveValue(ins.map(), scope);
                    String field = ins.field();
                    RtflType value = this.resolveValue(ins.assignValue(), scope);
                    if (!(map instanceof MapType)) {
                        throw new RuntimeException("Cannot get field from non-map", inst);
                    }
                    ((ConcurrentHashMap)map.value()).put(field, value);
                    continue;
                }
                if (inst instanceof VarUndefInstruction) {
                    VarUndefInstruction ins = (VarUndefInstruction)inst;
                    int undefId = scope.undefineVar(ins.variableName());
                    if (undefId <= -1) continue;
                    localIds.remove(new Integer(undefId));
                    continue;
                }
                if (inst instanceof FuncCallInstruction) {
                    FuncCallInstruction ins = (FuncCallInstruction)inst;
                    scope.function(ins.functionName()).run(this.resolveValues(ins.functionArguments(), scope), this, scope.descend(ins));
                    continue;
                }
                if (inst instanceof ReturnInstruction) {
                    ReturnInstruction ins = (ReturnInstruction)inst;
                    val = this.resolveValue(ins.returnValue(), scope);
                    continue;
                }
                if (inst instanceof IfInstruction) {
                    IfInstruction ins = (IfInstruction)inst;
                    RtflType cond = this.resolveValue(ins.condition(), scope);
                    boolean exec = false;
                    if (!(cond instanceof NumberType)) {
                        throw new RuntimeException("Non-number/bool value provided for 'if' instruction", inst);
                    }
                    exec = ((NumberType)cond).toDouble() > 0.0;
                    int level = 1;
                    ArrayList<RtflInstruction> instCache = new ArrayList<RtflInstruction>();
                    for (int j = i + 1; j < instructions.length && level > 0; ++j) {
                        RtflInstruction _inst2 = instructions[j];
                        if (_inst2 instanceof ClauseOpenerInstruction) {
                            ++level;
                            if (!exec) continue;
                            instCache.add(_inst2);
                            continue;
                        }
                        if (_inst2 instanceof EndClauseInstruction) {
                            if (--level > 0 && exec) {
                                instCache.add(_inst2);
                                continue;
                            }
                            i = j;
                            continue;
                        }
                        if (!exec) continue;
                        instCache.add(_inst2);
                    }
                    if (!exec) continue;
                    this.execute(instCache.toArray(new RtflInstruction[0]), scope.descend(inst));
                    continue;
                }
                if (inst instanceof WhileInstruction) {
                    RtflType cond;
                    WhileInstruction ins = (WhileInstruction)inst;
                    int level = 1;
                    ArrayList<RtflInstruction> instCache = new ArrayList<RtflInstruction>();
                    for (int j = i + 1; j < instructions.length && level > 0; ++j) {
                        _inst = instructions[j];
                        if (_inst instanceof ClauseOpenerInstruction) {
                            ++level;
                            instCache.add(_inst);
                            continue;
                        }
                        if (_inst instanceof EndClauseInstruction) {
                            if (--level > 0) {
                                instCache.add(_inst);
                                continue;
                            }
                            i = j;
                            continue;
                        }
                        instCache.add(_inst);
                    }
                    while ((cond = this.resolveValue(ins.condition(), scope)) instanceof NumberType) {
                        if (!(((NumberType)cond).toDouble() > 0.0)) continue block4;
                        this.execute(instCache.toArray(new RtflInstruction[0]), scope.descend(inst));
                    }
                    throw new RuntimeException("Non-number/bool value provided for 'while' instruction", inst);
                }
                if (inst instanceof TryInstruction) {
                    TryInstruction ins = (TryInstruction)inst;
                    int level = 1;
                    ArrayList<RtflInstruction> instCache = new ArrayList<RtflInstruction>();
                    for (int j = i + 1; j < instructions.length && level > 0; ++j) {
                        _inst = instructions[j];
                        if (_inst instanceof ClauseOpenerInstruction) {
                            ++level;
                            instCache.add(_inst);
                            continue;
                        }
                        if (_inst instanceof EndClauseInstruction) {
                            if (--level > 0) {
                                instCache.add(_inst);
                                continue;
                            }
                            i = j;
                            continue;
                        }
                        instCache.add(_inst);
                    }
                    scope.createLocalVar(ins.variableName(), new StringType("ok"));
                    try {
                        this.execute(instCache.toArray(new RtflInstruction[0]), scope.descend(inst));
                    }
                    catch (RuntimeException e) {
                        scope.assignVar(ins.variableName(), new StringType(e.getMessage()));
                    }
                    continue;
                }
                if (inst instanceof EndClauseInstruction) continue;
                if (inst instanceof FuncDefInstruction) {
                    FuncDefInstruction ins = (FuncDefInstruction)inst;
                    int level = 1;
                    ArrayList<RtflInstruction> instCache = new ArrayList<RtflInstruction>();
                    for (int j = i + 1; j < instructions.length && level > 0; ++j) {
                        _inst = instructions[j];
                        if (_inst instanceof ClauseOpenerInstruction) {
                            ++level;
                            instCache.add(_inst);
                            continue;
                        }
                        if (_inst instanceof EndClauseInstruction) {
                            if (--level > 0) {
                                instCache.add(_inst);
                                continue;
                            }
                            i = j;
                            continue;
                        }
                        instCache.add(_inst);
                    }
                    this._functions.put(ins.functionName(), new InstructionFunction(instCache.toArray(new RtflInstruction[0]), ins.argumentNames()));
                    continue;
                }
                if (inst instanceof FuncUndefInstruction) {
                    FuncUndefInstruction ins = (FuncUndefInstruction)inst;
                    this._functions.remove(ins.functionName());
                    continue;
                }
                if (inst instanceof AsyncInstruction) {
                    int level = 1;
                    ArrayList<RtflInstruction> instCache = new ArrayList<RtflInstruction>();
                    for (int j = i + 1; j < instructions.length && level > 0; ++j) {
                        RtflInstruction _inst3 = instructions[j];
                        if (_inst3 instanceof ClauseOpenerInstruction) {
                            ++level;
                            instCache.add(_inst3);
                            continue;
                        }
                        if (_inst3 instanceof EndClauseInstruction) {
                            if (--level > 0) {
                                instCache.add(_inst3);
                                continue;
                            }
                            i = j;
                            continue;
                        }
                        instCache.add(_inst3);
                    }
                    this.executeAsync(instCache.toArray(new RtflInstruction[0]), scope.descend(inst));
                    continue;
                }
                if (inst instanceof DescendScopeInstruction) {
                    scope = scope.descend(inst);
                    continue;
                }
                if (!(inst instanceof AscendScopeInstruction)) continue;
                scope = scope.parent();
                continue;
            }
            catch (RuntimeException e) {
                if (disownAll) {
                    for (int localId : scope.variableAliases().values()) {
                        if (!this._localVars.containsKey(localId)) continue;
                        this._localVars.get(localId).removeOwner(Thread.currentThread().getName());
                    }
                } else {
                    Iterator iterator = localIds.iterator();
                    while (iterator.hasNext()) {
                        int localId = (Integer)iterator.next();
                        if (!this._localVars.containsKey(localId)) continue;
                        this._localVars.get(localId).removeOwner(Thread.currentThread().getName());
                    }
                }
                if (e.cause() == null) {
                    throw new RuntimeException(e.getMessage(), inst);
                }
                throw e;
            }
        }
        if (disownAll) {
            for (int localId : scope.variableAliases().values()) {
                if (!this._localVars.containsKey(localId)) continue;
                this._localVars.get(localId).removeOwner(Thread.currentThread().getName());
            }
        } else {
            Iterator iterator = localIds.iterator();
            while (iterator.hasNext()) {
                int localId = (Integer)iterator.next();
                if (!this._localVars.containsKey(localId)) continue;
                this._localVars.get(localId).removeOwner(Thread.currentThread().getName());
            }
        }
        return val;
    }

    public ConcurrentHashMap<String, RtflFunction> functions() {
        return this._functions;
    }

    public ConcurrentHashMap<String, RtflType> globalVarables() {
        return this._variables;
    }

    public ConcurrentHashMap<Integer, LocalVar> localVariables() {
        return this._localVars;
    }

    public GarbageCollector garbageCollector() {
        return this._gc;
    }

    public RtflRuntime importStandard() {
        this._functions.putAll(new StandardFunctions().functions());
        return this;
    }

    public RtflRuntime importJavaInterop() {
        new JavaInteropFunctions(this);
        return this;
    }

    public RtflRuntime exposeMethodAs(Object object, String name, Class<?>[] parameters, String importName) throws NoSuchMethodException, SecurityException {
        this._functions.put(importName, RtflFunctionBuilder.fromMethod(object.getClass(), name, parameters, object));
        return this;
    }

    public RtflRuntime exposeMethod(Object object, String name, Class<?>[] parameters) throws NoSuchMethodException, SecurityException {
        this._functions.put(name, RtflFunctionBuilder.fromMethod(object.getClass(), name, parameters, object));
        return this;
    }

    public RtflRuntime exposeStaticMethodAs(Class<?> clazz, String name, Class<?>[] parameters, String importName) throws NoSuchMethodException, SecurityException {
        this._functions.put(importName, RtflFunctionBuilder.fromStaticMethod(clazz, name, parameters));
        return this;
    }

    public RtflRuntime exposeStaticMethod(Class<?> clazz, String name, Class<?>[] parameters) throws NoSuchMethodException, SecurityException {
        this._functions.put(name, RtflFunctionBuilder.fromStaticMethod(clazz, name, parameters));
        return this;
    }

    public int newId() {
        return this._nextVarId++;
    }

    private RtflType resolveValue(RtflType value, Scope scope) throws RuntimeException {
        RtflType val = value;
        if (val instanceof AssignmentType) {
            val = ((AssignmentType)value).extractValue(scope);
        }
        return val;
    }

    private RtflType[] resolveValues(RtflType[] values, Scope scope) throws RuntimeException {
        RtflType[] vals = new RtflType[values.length];
        for (int i = 0; i < values.length; ++i) {
            vals[i] = values[i] instanceof AssignmentType ? ((AssignmentType)values[i]).extractValue(scope) : values[i];
        }
        return vals;
    }

    public static class RtflMetadata {
        public final String fileName;
        public final int compilerVersion;
        public final int rtflVersion;
        public final boolean hasLineNumbers;

        public RtflMetadata(String file, int compVer, int rtflVer, boolean lineNumbers) {
            this.fileName = file;
            this.compilerVersion = compVer;
            this.rtflVersion = rtflVer;
            this.hasLineNumbers = lineNumbers;
        }
    }

    public class GarbageCollector
    extends Thread {
        private long _interval = -1L;
        private long _adjustment = 0L;
        private boolean _paused = false;
        private RtflRuntime _rt = null;

        public GarbageCollector(long interval, RtflRuntime rt) {
            this._interval = interval;
            this._rt = rt;
        }

        public void pause() {
            this._paused = true;
        }

        public void unpause() {
            this._paused = false;
        }

        public void paused(boolean paused) {
            this._paused = paused;
        }

        public boolean paused() {
            return this._paused;
        }

        public int collect() {
            Integer[] varIds;
            int deleted = 0;
            Integer[] integerArray = varIds = ((ConcurrentHashMap.CollectionView)((Object)this._rt._localVars.keySet())).toArray(new Integer[0]);
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int id = integerArray[i];
                if (this._rt._localVars.get(id) == null || !((LocalVar)((RtflRuntime)this._rt)._localVars.get((Object)Integer.valueOf((int)id))).notInUse) continue;
                this._rt._localVars.remove(id);
                ++deleted;
            }
            return deleted;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(this._interval + this._adjustment);
                        this.collect();
                    }
                }
                catch (InterruptedException e) {
                    if (this._paused) continue;
                    System.err.println("Failed to put garbage collector to sleep:");
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    public static class LocalVar {
        public RtflType value = null;
        public ArrayList<String> _owners = new ArrayList();
        public boolean notInUse = false;

        public LocalVar(RtflType val, String thread) {
            this.value = val;
            this._owners.add(thread);
        }

        public void addOwner(String thread) {
            this._owners.add(thread);
        }

        public void removeOwner(String thread) {
            this._owners.remove(thread);
            if (this._owners.size() < 1) {
                this.notInUse = true;
            }
        }
    }
}

