/*
 * Decompiled with CFR 0.152.
 */
package net.termer.rtflc.runtime;

import net.termer.rtflc.instructions.RtflInstruction;
import net.termer.rtflc.runtime.RtflFunction;
import net.termer.rtflc.runtime.RtflRuntime;
import net.termer.rtflc.runtime.RuntimeException;
import net.termer.rtflc.runtime.Scope;
import net.termer.rtflc.type.IntType;
import net.termer.rtflc.type.RtflType;

public class InstructionFunction
implements RtflFunction {
    private RtflInstruction[] insts = null;
    private String[] argNames = new String[0];

    public InstructionFunction(RtflInstruction[] instructions) {
        this.insts = instructions;
    }

    public InstructionFunction(RtflInstruction[] instructions, String[] argumentNames) {
        this.insts = instructions;
        this.argNames = argumentNames;
    }

    @Override
    public RtflType run(RtflType[] args, RtflRuntime rt, Scope scope) throws RuntimeException {
        for (int i = 0; i < args.length; ++i) {
            if (i < this.argNames.length) {
                scope.createLocalVar(this.argNames[i], args[i]);
            }
            scope.createLocalVar("arg" + (i + 1), args[i]);
        }
        scope.createLocalVar("arglen", new IntType(args.length));
        RtflType val = rt.execute(this.insts, scope);
        for (int i = 0; i < args.length; ++i) {
            if (i < this.argNames.length && scope.variableAliases().containsKey(this.argNames[i])) {
                scope.undefineVar(this.argNames[i]);
            }
            String vname = "arg" + (i + 1);
            if (!scope.variableAliases().containsKey(vname)) continue;
            scope.undefineVar(vname);
        }
        if (scope.variableAliases().containsKey("arglen")) {
            scope.undefineVar("arglen");
        }
        return val;
    }
}

