/*
 * Decompiled with CFR 0.152.
 */
package net.termer.rtflc.instructions;

import net.termer.rtflc.instructions.RtflInstruction;
import net.termer.rtflc.type.RtflType;

public class FuncCallInstruction
implements RtflInstruction {
    private String originFile = null;
    private int originLine = 0;
    private String funcName = null;
    private RtflType[] funcArgs = null;

    public FuncCallInstruction(String file, int line, String name, RtflType[] args) {
        this.originFile = file;
        this.originLine = line;
        this.funcName = name;
        this.funcArgs = args;
    }

    @Override
    public String originFile() {
        return this.originFile;
    }

    @Override
    public int originLine() {
        return this.originLine;
    }

    public String functionName() {
        return this.funcName;
    }

    public RtflType[] functionArguments() {
        return this.funcArgs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.funcName + '(');
        for (int i = 0; i < this.funcArgs.length; ++i) {
            sb.append(this.funcArgs[i].toString());
            if (i >= this.funcArgs.length - 1) continue;
            sb.append(", ");
        }
        return sb.append(')').toString();
    }
}

