/*
 * Decompiled with CFR 0.152.
 */
package net.termer.rtflc.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.termer.rtflc.compiler.CompilerOptions;
import net.termer.rtflc.consumers.CompilerInstructionConsumer;
import net.termer.rtflc.consumers.InstructionConsumer;
import net.termer.rtflc.instructions.AscendScopeInstruction;
import net.termer.rtflc.instructions.DescendScopeInstruction;
import net.termer.rtflc.instructions.FuncCallInstruction;
import net.termer.rtflc.instructions.RtflInstruction;
import net.termer.rtflc.producers.BytecodeInstructionProducer;
import net.termer.rtflc.producers.ProducerException;
import net.termer.rtflc.producers.SourcecodeInstructionProducer;
import net.termer.rtflc.runtime.RtflRuntime;
import net.termer.rtflc.runtime.RuntimeException;
import net.termer.rtflc.type.RtflType;
import net.termer.rtflc.type.StringType;

public class RtflCompiler {
    public static final int COMPILER_VERSION = 0;
    public static final int RTFL_VERSION = 4;
    private final CompilerOptions _options;
    private ArrayList<String> _requires = new ArrayList();
    private ArrayList<String> _loads = new ArrayList();

    public RtflCompiler(CompilerOptions options) {
        this._options = options;
    }

    public CompilerOptions options() {
        return this._options;
    }

    public ArrayList<String> requiresLoaded() {
        return this._requires;
    }

    public ArrayList<String> loadsCompiled() {
        return this._loads;
    }

    public void compile(File file, OutputStream out) throws IOException, ProducerException, RuntimeException {
        this.compile(file, out, true);
    }

    public void compile(File file, OutputStream out, boolean writeMetadata) throws IOException, ProducerException, RuntimeException {
        FileInputStream in = new FileInputStream(file);
        CompilerInstructionConsumer cons = new CompilerInstructionConsumer(out, this._options.preserveLineNumbers());
        CompilerConsumer comp = new CompilerConsumer(this, cons, out);
        System.out.println((writeMetadata ? "Compiling " : "Packaging ") + file.getPath() + "...");
        if (writeMetadata) {
            out.write(new byte[]{1, 3, 3, 7});
            out.write(0);
            out.write(4);
            out.write(file.getName().length());
            out.write(file.getName().getBytes(StandardCharsets.UTF_8));
            out.write(this._options.preserveLineNumbers() ? 1 : 0);
        }
        if (RtflRuntime.isCompiledScript(in)) {
            RtflRuntime.RtflMetadata meta = RtflRuntime.readCompiledMetadata(in);
            if (!writeMetadata) {
                this.swapSource(meta.fileName, this, out);
            }
            BytecodeInstructionProducer.produce(file.getName(), in, comp, this._options.preserveLineNumbers());
        } else {
            in.close();
            in = new FileInputStream(file);
            SourcecodeInstructionProducer.produce(file.getName(), in, comp);
        }
        in.close();
    }

    private void swapSource(String source, RtflCompiler compiler, OutputStream out) throws IOException {
        if (compiler.options().preserveLineNumbers()) {
            out.write(new byte[]{0, 0});
        }
        out.write(new byte[]{13, (byte)source.length()});
        out.write(source.getBytes(StandardCharsets.UTF_8));
    }

    private class CompilerConsumer
    implements InstructionConsumer {
        private RtflCompiler comp;
        private InstructionConsumer cons;
        private OutputStream out;

        public CompilerConsumer(RtflCompiler compiler, InstructionConsumer consumer, OutputStream output) {
            this.comp = compiler;
            this.cons = consumer;
            this.out = output;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void consume(RtflInstruction inst) throws IOException {
            if (inst instanceof FuncCallInstruction) {
                FuncCallInstruction ins = (FuncCallInstruction)inst;
                boolean writeInst = true;
                if (ins.functionArguments().length > 0 && ins.functionArguments()[0] instanceof StringType && (ins.functionName().equals("load") || ins.functionName().equals("require"))) {
                    String arg = (String)ins.functionArguments()[0].value();
                    File file = new File(arg);
                    if (ins.functionName().equals("require") && !arg.contains(".") && !arg.contains("/") && !(file = new File("libs/" + arg + ".rtfc")).isFile()) {
                        file = new File("libs/" + arg + ".rtfl");
                    }
                    if (!file.isFile()) throw new FileNotFoundException("Path specified in " + ins.functionName() + " at " + inst.originFile() + ':' + inst.originLine() + " is not a file");
                    try {
                        if (ins.functionName().equals("load")) {
                            if (this.comp.options().packageLiteralLoads()) {
                                writeInst = false;
                                this.cons.consume(new DescendScopeInstruction());
                                this.comp.compile(file, this.out, false);
                                RtflCompiler.this.swapSource(inst.originFile(), this.comp, this.out);
                                this.cons.consume(new AscendScopeInstruction());
                            } else if (this.comp.options().compileLiteralLoads()) {
                                writeInst = false;
                                String compPath = arg;
                                compPath = compPath.endsWith(".rtfl") ? compPath.substring(0, compPath.length() - 1) + 'c' : compPath + ".rtflc";
                                if (!this.comp.loadsCompiled().contains(file.getCanonicalPath())) {
                                    if (!file.isFile()) {
                                        this.comp.compile(file, new FileOutputStream(compPath), true);
                                    }
                                    this.comp.loadsCompiled().add(file.getCanonicalPath());
                                }
                                this.cons.consume(new FuncCallInstruction(inst.originFile(), inst.originLine(), "load", new RtflType[]{new StringType(compPath)}));
                            }
                        } else if (ins.functionName().equals("require")) {
                            if (this.comp.options().packageLiteralRequires()) {
                                writeInst = false;
                                if (!this.comp.requiresLoaded().contains(file.getCanonicalPath())) {
                                    this.cons.consume(new DescendScopeInstruction());
                                    this.comp.compile(file, this.out, false);
                                    RtflCompiler.this.swapSource(inst.originFile(), this.comp, this.out);
                                    this.cons.consume(new AscendScopeInstruction());
                                    this.comp.requiresLoaded().add(file.getCanonicalPath());
                                }
                            } else if (this.comp.options().compileLiteralRequires()) {
                                writeInst = false;
                                String compPath = file.getPath();
                                compPath = compPath.endsWith(".rtfl") ? compPath.substring(0, compPath.length() - 1) + 'c' : compPath + ".rtflc";
                                if (!this.comp.requiresLoaded().contains(file.getCanonicalPath())) {
                                    if (!file.isFile()) {
                                        this.comp.compile(file, new FileOutputStream(compPath), true);
                                    }
                                    this.comp.requiresLoaded().add(file.getCanonicalPath());
                                }
                                this.cons.consume(new FuncCallInstruction(inst.originFile(), inst.originLine(), "require", new RtflType[]{new StringType(arg)}));
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new IOException(e.getMessage());
                    }
                }
                if (!writeInst) return;
                this.cons.consume(inst);
                return;
            }
            this.cons.consume(inst);
        }

        @Override
        public void finish() throws RuntimeException {
        }
    }
}

