/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.fsm.utilities;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import net.tangly.fsm.State;
import net.tangly.fsm.Transition;
import net.tangly.fsm.utilities.Checker;

public class StaticChecker<O, S extends Enum<S>, E extends Enum<E>>
implements Checker {
    private static final String BUNDLE_NAME = "net.tangly.fsm.utilities.CheckerMessages";
    private final ResourceBundle bundle = ResourceBundle.getBundle("net.tangly.fsm.utilities.CheckerMessages");

    public List<String> check(State<O, S, E> root) {
        ArrayList<String> messages = new ArrayList<String>();
        messages.addAll(this.checkStateIdUsedOnce(root));
        messages.addAll(this.checkStateHasAtMostOneInitialState(root));
        messages.addAll(this.checkDefinedInitialStates(root));
        messages.addAll(this.checkStateWithAfferentTransitionHasInitialState(root));
        return messages;
    }

    public List<String> checkStateIdUsedOnce(State<O, S, E> root) {
        ArrayList<String> messages = new ArrayList<String>();
        Set<State<O, S, E>> states = this.collectAllSubstates(root);
        EnumSet allValues = EnumSet.allOf(((Enum)root.id()).getDeclaringClass());
        EnumSet values = EnumSet.noneOf(((Enum)root.id()).getDeclaringClass());
        for (State<O, S, E> state2 : states) {
            if (values.contains(state2.id())) {
                messages.add(this.createError(this.bundle, "FSM-STAT-001", state2.id()));
                continue;
            }
            values.add(state2.id());
        }
        messages.addAll(allValues.stream().filter(state -> !values.contains(state)).map(state -> this.createError(this.bundle, "FSM-STAT-002", state)).collect(Collectors.toList()));
        return messages;
    }

    public List<String> checkStateHasAtMostOneInitialState(State<O, S, E> root) {
        return this.collectAllSubstates(root).stream().filter(State::isComposite).filter(state -> this.getInitialSubstates((State<O, S, E>)state).size() > 1).map(state -> this.createError(this.bundle, "FSM-STAT-003", state.id(), this.getInitialSubstates((State<O, S, E>)state).size())).collect(Collectors.toUnmodifiableList());
    }

    List<String> checkDefinedInitialStates(State<O, S, E> root) {
        ArrayList<String> messages = new ArrayList<String>();
        State<O, S, E> state = root;
        while (state != null && !state.substates().isEmpty()) {
            Set<State<O, S, E>> initialStates = this.getInitialSubstates(state);
            if (initialStates.size() != 1) {
                messages.add(this.createError(this.bundle, "FSM-STAT-005", state.id(), initialStates.size()));
                state = null;
                continue;
            }
            state = initialStates.iterator().next();
        }
        return messages;
    }

    public List<String> checkStateWithAfferentTransitionHasInitialState(State<O, S, E> state) {
        return this.collectAllSubstates(state).stream().flatMap(o -> o.transitions().stream()).map(Transition::target).distinct().filter(State::isComposite).filter(o -> this.getInitialSubstates((State<O, S, E>)o).size() != 1).map(o -> this.createError(this.bundle, "FSM-STAT-004", o.id(), this.getInitialSubstates((State<O, S, E>)o).size())).collect(Collectors.toList());
    }

    private Set<State<O, S, E>> collectAllSubstates(State<O, S, E> root) {
        return this.collectAllSubstates(new HashSet<State<O, S, E>>(), root);
    }

    private Set<State<O, S, E>> collectAllSubstates(Set<State<O, S, E>> states, State<O, S, E> root) {
        states.add(root);
        root.substates().forEach(o -> this.collectAllSubstates((Set<State<O, S, E>>)states, (State<O, S, E>)o));
        return states;
    }

    private Set<State<O, S, E>> getInitialSubstates(State<O, S, E> state) {
        HashSet<State<O, S, E>> initialStates = new HashSet<State<O, S, E>>();
        state.substates().stream().filter(State::isInitial).forEach(initialStates::add);
        return initialStates;
    }
}

