/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.fsm.utilities;

import java.util.Objects;
import java.util.function.BiConsumer;
import net.tangly.fsm.Event;
import net.tangly.fsm.State;
import net.tangly.fsm.StateMachine;
import net.tangly.fsm.StateMachineEventHandler;
import net.tangly.fsm.Transition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateMachineLogger<O, S extends Enum<S>, E extends Enum<E>>
implements StateMachineEventHandler<O, S, E> {
    private static final Logger logger = LoggerFactory.getLogger(StateMachineLogger.class);
    private final StateMachine<O, S, E> machine;

    public StateMachineLogger(StateMachine<O, S, E> machine) {
        this.machine = machine;
    }

    @Override
    public void processEvent(Event<E> event) {
        logger.debug("machine [{}] Process Event : event->{}", this.machine, event);
    }

    @Override
    public void wasReset() {
        logger.debug("machine [{}] reset machine : <none>", this.machine);
    }

    @Override
    public void fireLocalTransition(Transition<O, S, E> transition, Event<E> event) {
        logger.debug("machine [{}]: event->{}, fire local transition {} ", new Object[]{this.machine, event, transition});
    }

    @Override
    public void fireTransition(Transition<O, S, E> transition, Event<E> event) {
        logger.debug("machine [{}]: event->{}, fire transition->{}", new Object[]{this.machine, event, transition});
    }

    @Override
    public void executeEntryAction(State<O, S, E> state, Event<E> event) {
        logger.debug("machine [{}] : event->{}, execute entry action for state->{}", new Object[]{this.machine, event, state});
    }

    @Override
    public void executeExitAction(State<O, S, E> state, Event<E> event) {
        logger.debug("machine [{}] : event->{}, execute exit action for state->{}", new Object[]{this.machine, event, state});
    }

    @Override
    public void enterState(State<O, S, E> state) {
        logger.debug("machine [{}] : enter state {}", this.machine, state);
    }

    @Override
    public void exitState(State<O, S, E> state) {
        logger.debug("machine [{}] : exit state {}", this.machine, state);
    }

    @Override
    public void throwException(Transition<O, S, E> transition, Event<E> event, Exception exception) {
        logger.error("machine [{}] {} : event->{}, transition->{}, exception->{}", new Object[]{this.machine, event, transition, exception});
    }

    @Override
    public void throwException(State<O, S, E> state, BiConsumer<O, Event<E>> action, Event<E> event, Exception exception) {
        if (Objects.equals(action, state.entryAction())) {
            logger.error("machine [{}] {} : event->{}, state->{}, entry action exception->{}", new Object[]{this.machine, event, state, exception});
        } else if (Objects.equals(action, state.exitAction())) {
            logger.error("machine [{}] {} : event->{}, state->{}, exit action exception->{}", new Object[]{this.machine, event, state, exception});
        }
    }
}

