/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.fsm.utilities;

import java.io.PrintWriter;
import net.tangly.fsm.State;
import net.tangly.fsm.dsl.FsmBuilder;
import net.tangly.fsm.utilities.Generator;
import org.jetbrains.annotations.NotNull;

public class GeneratorPlantUml<O, S extends Enum<S>, E extends Enum<E>>
extends Generator<O, S, E> {
    public GeneratorPlantUml(@NotNull FsmBuilder<O, S, E> builder, String name) {
        super(builder, name);
    }

    @Override
    public void generate(@NotNull PrintWriter writer) {
        this.writePreamble(writer);
        this.writeState(this.builder.definition(), 0, writer);
        GeneratorPlantUml.writePostamble(writer);
        writer.flush();
        writer.close();
    }

    @Override
    public String extension() {
        return "puml";
    }

    private void writePreamble(@NotNull PrintWriter writer) {
        writer.append("@startuml").println();
        writer.append("hide empty description").println();
        writer.println();
    }

    private static void writePostamble(@NotNull PrintWriter writer) {
        writer.println();
        writer.append("@enduml").println();
    }

    private void writeState(@NotNull State<O, S, E> state, int depth, @NotNull PrintWriter writer) {
        if (state.isInitial() && state != this.builder.definition()) {
            this.indent(writer, depth).append("[*] --> ").append(this.getStateName(state)).println();
        }
        if (state.isComposite()) {
            this.indent(writer, depth).append("state ").append(this.getStateName(state)).println(" {");
            state.substates().stream().sorted().forEach(o -> this.writeState((State<O, S, E>)o, depth + 1, writer));
            this.writeTransitions(state, writer, depth + 1);
            writer.println("}");
        } else {
            this.indent(writer, depth).append("state ").append(this.getStateName(state)).println();
            this.writeTransitions(state, writer, depth);
        }
        writer.println();
    }

    private void writeTransitions(@NotNull State<O, S, E> state, @NotNull PrintWriter writer, int depth) {
        if (state.isFinal() && state != this.builder.definition()) {
            this.indent(writer, depth).append(this.getStateName(state)).append(" --> [*]").println();
        }
        state.transitions().stream().sorted(this.transitionComparator()).forEach(transition -> {
            State source = transition.source();
            State target = transition.target();
            this.indent(writer, depth).append(this.getStateName(source)).append(" -> ").append(this.getStateName(target)).append(" : ").append(((Enum)transition.eventId()).toString());
            if (transition.hasGuard()) {
                writer.append(" [").append(transition.guardDescription() != null ? transition.guardDescription() : "").append("]");
            }
            if (transition.hasAction() && transition.actionDescription() != null) {
                writer.append(" / ").append(transition.actionDescription() != null ? transition.actionDescription() : "");
            }
            writer.println();
        });
    }
}

