/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.fsm.utilities;

import java.io.PrintWriter;
import net.tangly.fsm.State;
import net.tangly.fsm.dsl.FsmBuilder;
import net.tangly.fsm.utilities.Generator;
import org.jetbrains.annotations.NotNull;

public class GeneratorGraphDot<O, S extends Enum<S>, E extends Enum<E>>
extends Generator<O, S, E> {
    private static final int MAX_NR_STATES = 1000;

    public GeneratorGraphDot(@NotNull FsmBuilder<O, S, E> builder, String name) {
        super(builder, name);
    }

    @Override
    public void generate(@NotNull PrintWriter writer) {
        this.writePreamble(writer);
        this.writeState(this.builder.definition(), 1, writer);
        writer.println();
        this.states.stream().sorted().forEach(state -> this.writeTransitions((State<O, S, E>)state, writer));
        GeneratorGraphDot.writePostamble(writer);
        writer.flush();
        writer.close();
    }

    @Override
    public String extension() {
        return "dot";
    }

    private void writePreamble(@NotNull PrintWriter writer) {
        writer.append("digraph G {").println();
        this.indent(writer, 1).append("compound=true;\n").println();
    }

    private static void writePostamble(@NotNull PrintWriter writer) {
        writer.append("}").println();
    }

    private void writeState(@NotNull State<O, S, E> state, int depth, @NotNull PrintWriter writer) {
        if (state.isComposite()) {
            this.indent(writer, depth).append("subgraph cluster").append(Integer.toString(1000 + ((Enum)state.id()).ordinal())).println(" {");
            this.indent(writer, depth + 1).println("style=invis;");
            this.indent(writer, depth + 1).append("subgraph cluster").append(this.getStateId(state)).println(" {");
            this.indent(writer, depth + 2).append(this.getStyle(state)).println(";");
            this.indent(writer, depth + 2).append("label = \"").append(((Enum)state.id()).name()).println("\"");
            state.substates().stream().sorted().forEach(o -> this.writeState((State<O, S, E>)o, depth + 3, writer));
            this.indent(writer, depth + 1).println("}");
            this.indent(writer, depth).println("}");
        } else {
            this.indent(writer, depth).append(((Enum)state.id()).name()).append(" [").append(this.getStyle(state)).println("];");
        }
    }

    private void writeTransitions(@NotNull State<O, S, E> state, @NotNull PrintWriter writer) {
        state.transitions().stream().sorted(this.transitionComparator()).forEach(transition -> {
            State source = transition.source();
            State target = transition.target();
            this.indent(writer, 1).append(this.getStateName(source)).append(" -> ").append(this.getStateName(target)).append(" [");
            if (source.isComposite()) {
                writer.append("ltail=cluster").append(this.getStateId(source)).append(", ");
            }
            if (target.isComposite()) {
                writer.append("lhead=cluster").append(this.getStateId(target)).append(", ");
            }
            writer.append("label=\"").append(((Enum)transition.eventId()).name());
            if (transition.hasGuard()) {
                writer.append("[").append(transition.guardDescription() != null ? transition.guardDescription() : "").append("]");
            }
            if (transition.hasAction()) {
                writer.append("/").append(transition.actionDescription() != null ? transition.actionDescription() : "");
            }
            writer.println("\"];");
        });
    }

    private String getStyle(@NotNull State<O, S, E> state) {
        StringBuilder buffer = new StringBuilder();
        String separator = "";
        buffer.append("style=\"");
        if (state.isComposite()) {
            buffer.append(separator).append("visible");
            separator = ", ";
        }
        if (state.isInitial()) {
            buffer.append(separator).append("dashed");
            separator = ", ";
        }
        if (state.isFinal()) {
            buffer.append(separator).append("bold");
            separator = ", ";
        }
        if (state.hasHistory()) {
            buffer.append(separator).append("filled");
            separator = ", ";
        }
        buffer.append("\"");
        return separator.equals(", ") ? buffer.toString() : "";
    }
}

