/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.fsm.utilities;

import java.io.PrintWriter;
import net.tangly.fsm.State;
import net.tangly.fsm.Transition;
import net.tangly.fsm.dsl.FsmBuilder;
import net.tangly.fsm.utilities.Generator;
import org.jetbrains.annotations.NotNull;

public class GeneratorAsciiDoc<O, S extends Enum<S>, E extends Enum<E>>
extends Generator<O, S, E> {
    public GeneratorAsciiDoc(@NotNull FsmBuilder<O, S, E> builder, String name) {
        super(builder, name);
    }

    @Override
    public void generate(@NotNull PrintWriter writer) {
        this.generateImageXRef(writer);
        this.writeStateTablePreamble(writer);
        this.states.stream().sorted().forEach(state -> this.writeState((State<O, S, E>)state, writer));
        GeneratorAsciiDoc.writeTablePostamble(writer);
        this.writeTransitionTablePreamble(writer);
        this.states.stream().sorted().forEach(state -> this.writeTransitions((State<O, S, E>)state, writer));
        GeneratorAsciiDoc.writeTablePostamble(writer);
        writer.flush();
        writer.close();
    }

    @Override
    public String extension() {
        return "adoc";
    }

    private void generateImageXRef(@NotNull PrintWriter writer) {
        writer.append("== ").append(this.name).append(" Finite State Machine").println();
        writer.println();
        writer.append("image::pics/").append(this.name).append(".svg[").append(this.name).append("]").println();
        writer.println();
    }

    private void writeStateTablePreamble(@NotNull PrintWriter writer) {
        writer.append("=== ").append(this.name).append(" States").println();
        writer.println();
        writer.println("[cols=\"2,2,3,1,1,1,3,3\"]");
        writer.println("|===");
        writer.println("|Name |Context |Description |Final |Initial |Composite |Entry Action |Exit Action");
        writer.println();
    }

    private static void writeTablePostamble(@NotNull PrintWriter writer) {
        writer.println("|===");
        writer.println();
    }

    private void writeTransitionTablePreamble(@NotNull PrintWriter writer) {
        writer.append("=== ").append(this.name).append(" Transitions").println();
        writer.println();
        writer.println("[cols=\"2,2,3,1,3,3\"]");
        writer.println("|===");
        writer.println("|Start State |End State |Description |Local |Guard |Action");
        writer.println();
    }

    private void writeState(@NotNull State<O, S, E> state, @NotNull PrintWriter writer) {
        writer.append("|");
        this.appendInlineAnchor(writer, state).append(this.getStateName(state)).println();
        writer.append("|").println(this.findOwner(state).map(this::getStateName).orElse("-"));
        writer.append("|").println(this.toString(state.description()));
        writer.append("|").println(state.isFinal());
        writer.append("|").println(state.isInitial());
        writer.append("|").println(state.isComposite());
        writer.append("|").println(state.entryAction() != null ? this.toString(state.entryActionDescription()) : "-");
        writer.append("|").println(state.exitAction() != null ? this.toString(state.exitActionDescription()) : "-");
        writer.println();
    }

    private void writeTransitions(@NotNull State<O, S, E> state, @NotNull PrintWriter writer) {
        state.localTransitions().stream().sorted(this.transitionComparator()).forEach(o -> this.writeTransition((Transition<O, S, E>)o, true, writer));
        state.transitions().stream().sorted(this.transitionComparator()).forEach(o -> this.writeTransition((Transition<O, S, E>)o, false, writer));
    }

    @NotNull
    private PrintWriter appendInlineAnchor(@NotNull PrintWriter writer, @NotNull State<O, S, E> state) {
        writer.append("[[").append(this.name).append("-").append(this.getStateName(state)).append("]]");
        return writer;
    }

    @NotNull
    private PrintWriter appendInternalXRef(@NotNull PrintWriter writer, @NotNull State<O, S, E> state) {
        writer.append("<<").append(this.name).append("-").append(this.getStateName(state)).append(",").append(this.getStateName(state)).append(">>");
        return writer;
    }

    private void writeTransition(@NotNull Transition<O, S, E> transition, boolean isLocal, @NotNull PrintWriter writer) {
        writer.append("|");
        this.appendInternalXRef(writer, transition.source()).println();
        writer.append("|");
        this.appendInternalXRef(writer, transition.target()).println();
        writer.append("|").append(this.toString(transition.description())).println();
        writer.append("|").append(Boolean.toString(isLocal)).println();
        writer.append("|").append(this.toString(transition.guardDescription())).println();
        writer.append("|").append(this.toString(transition.actionDescription())).println();
        writer.println();
    }
}

