/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.fsm.utilities;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.tangly.fsm.State;
import net.tangly.fsm.Transition;
import net.tangly.fsm.dsl.FsmBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class Generator<O, S extends Enum<S>, E extends Enum<E>> {
    private static final int INDENTATION = 4;
    final Comparator<Transition<O, S, E>> comparator;
    protected final FsmBuilder<O, S, E> builder;
    protected final String name;
    protected final Set<State<O, S, E>> states;

    public Generator(@NotNull FsmBuilder<O, S, E> builder, @NotNull String name) {
        this.builder = builder;
        this.name = name;
        this.comparator = Comparator.comparing(Transition::source).thenComparing(Transition::target).thenComparing(Transition::eventId).thenComparing(Comparator.nullsLast(Comparator.comparing(Transition::guardDescription)));
        this.states = new HashSet<State<O, S, E>>();
        this.getAllStates(this.states, builder.definition());
    }

    public boolean generateFileIfChanged(@NotNull Path path) throws IOException {
        String oldText;
        StringWriter writer = new StringWriter();
        this.generate(new PrintWriter(writer));
        String newText = writer.toString();
        Path filePath = Paths.get(path.toString(), this.name + "." + this.extension());
        boolean shouldBeUpdated = Files.exists(filePath, new LinkOption[0]) ? !(oldText = new String(Files.readAllBytes(filePath), StandardCharsets.UTF_8)).contentEquals(newText) : true;
        if (shouldBeUpdated) {
            try (PrintWriter out = new PrintWriter(filePath.toFile(), StandardCharsets.UTF_8);){
                out.append(newText);
                out.flush();
            }
        }
        return shouldBeUpdated;
    }

    public abstract void generate(@NotNull PrintWriter var1);

    public abstract String extension();

    @NotNull
    protected PrintWriter indent(@NotNull PrintWriter writer, int depth) {
        return writer.append(" ".repeat(4 * depth));
    }

    @NotNull
    protected String getStateId(@NotNull State<O, S, E> state) {
        return Integer.toString(((Enum)state.id()).ordinal());
    }

    @NotNull
    protected String getStateName(@NotNull State<O, S, E> state) {
        return ((Enum)state.id()).name();
    }

    @NotNull
    protected String toString(String value) {
        return value != null ? value.trim() : "";
    }

    @NotNull
    protected Comparator<Transition<O, S, E>> transitionComparator() {
        return this.comparator;
    }

    protected Optional<State<O, S, E>> findOwner(State<O, S, E> state) {
        return this.states.stream().filter(o -> o.substates().contains(state)).findAny();
    }

    private void getAllStates(Set<State<O, S, E>> states, State<O, S, E> state) {
        states.add(state);
        state.substates().forEach(o -> this.getAllStates((Set<State<O, S, E>>)states, (State<O, S, E>)o));
    }
}

