/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.fsm.utilities;

import java.util.function.BiConsumer;
import net.tangly.fsm.Event;
import net.tangly.fsm.State;
import net.tangly.fsm.StateMachine;
import net.tangly.fsm.StateMachineEventHandler;
import net.tangly.fsm.Transition;

public class DynamicChecker<O, S extends Enum<S>, E extends Enum<E>>
implements StateMachineEventHandler<O, S, E> {
    private final StateMachine<O, S, E> fsm;

    public DynamicChecker(StateMachine<O, S, E> fsm) {
        this.fsm = fsm;
    }

    @Override
    public void processEvent(Event<E> event) {
    }

    @Override
    public void wasReset() {
    }

    @Override
    public void fireLocalTransition(Transition<O, S, E> transition, Event<E> event) {
        if (transition.source().localTransitions().stream().filter(o -> o.evaluate(this.fsm.context(), event)).count() > 1L) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void fireTransition(Transition<O, S, E> transition, Event<E> event) {
        if (transition.source().transitions().stream().filter(o -> o.evaluate(this.fsm.context(), event)).count() > 1L) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void throwException(Transition<O, S, E> transition, Event<E> event, Exception e) {
        throw new IllegalStateException(e);
    }

    @Override
    public void throwException(State<O, S, E> state, BiConsumer<O, Event<E>> action, Event<E> event, Exception e) {
        throw new IllegalStateException(e);
    }
}

