/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.fsm.utilities;

import java.text.MessageFormat;
import java.util.ResourceBundle;

public interface Checker {
    default public String createMessage(Level level, ResourceBundle bundle, String key, Object ... parameters) {
        MessageFormat formatter = new MessageFormat("");
        formatter.applyPattern(bundle.getString(key));
        return level.getText() + "-" + key + "-" + formatter.format(parameters);
    }

    default public String createError(ResourceBundle bundle, String key, Object ... parameters) {
        return this.createMessage(Level.ERROR, bundle, key, parameters);
    }

    public static enum Level {
        FATAL("FATAL"),
        ERROR("ERROR"),
        WARNING("WARN "),
        INFO("INFO"),
        DEBUG("DEBUG"),
        TRACE("TRACE");

        private final String text;

        private Level(String text) {
            this.text = text;
        }

        String getText() {
            return this.text;
        }
    }
}

