/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.fsm.imp;

import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.tangly.fsm.Event;
import net.tangly.fsm.State;
import net.tangly.fsm.Transition;

class TransitionImp<O, S extends Enum<S>, E extends Enum<E>>
implements Transition<O, S, E> {
    private final State<O, S, E> source;
    private final State<O, S, E> target;
    private final E eventId;
    private BiPredicate<O, Event<E>> guard;
    private BiConsumer<O, Event<E>> action;
    private String description;
    private String guardDescription;
    private String actionDescription;

    public TransitionImp(State<O, S, E> source, State<O, S, E> target, E eventId) {
        this(source, target, eventId, null, null);
    }

    public TransitionImp(State<O, S, E> source, State<O, S, E> target, E eventId, BiConsumer<O, Event<E>> action) {
        this(source, target, eventId, null, action);
    }

    public TransitionImp(State<O, S, E> source, State<O, S, E> target, E eventId, BiPredicate<O, Event<E>> guard, BiConsumer<O, Event<E>> action) {
        this.source = source;
        this.target = target;
        this.eventId = eventId;
        this.guard = guard;
        this.action = action;
    }

    @Override
    public State<O, S, E> target() {
        return this.target;
    }

    @Override
    public State<O, S, E> source() {
        return this.source;
    }

    @Override
    public E eventId() {
        return this.eventId;
    }

    @Override
    public BiPredicate<O, Event<E>> guard() {
        return this.guard;
    }

    public void guard(BiPredicate<O, Event<E>> guard) {
        this.guard = guard;
    }

    @Override
    public BiConsumer<O, Event<E>> action() {
        return this.action;
    }

    public void action(BiConsumer<O, Event<E>> action) {
        this.action = action;
    }

    @Override
    public String actionDescription() {
        return this.actionDescription;
    }

    public void setActionDescription(String description) {
        this.actionDescription = description;
    }

    @Override
    public String description() {
        return this.description;
    }

    public void description(String description) {
        this.description = description;
    }

    @Override
    public String guardDescription() {
        return this.guardDescription;
    }

    public void guardDescription(String description) {
        this.guardDescription = description;
    }

    @Override
    public boolean evaluate(O context, Event<E> event) {
        return event.type() == this.eventId() && (!this.hasGuard() || this.guard.test(context, event));
    }

    @Override
    public boolean execute(O context, Event<E> event) {
        boolean canBeFired = this.evaluate(context, event);
        if (canBeFired && this.hasAction()) {
            this.action.accept(context, event);
        }
        return canBeFired;
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("source=" + this.source.id()).add("target=" + this.target.id()).add("eventId=" + this.eventId).add("description=" + this.description).add("guardDescription=" + this.guardDescription).add("actionDescription=" + this.actionDescription).toString();
    }
}

