/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.fsm.imp;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringJoiner;
import net.tangly.fsm.Event;
import net.tangly.fsm.State;
import net.tangly.fsm.StateMachine;
import net.tangly.fsm.StateMachineEventHandler;
import net.tangly.fsm.Transition;
import net.tangly.fsm.imp.StateMachineEventHandlerHelper;
import org.jetbrains.annotations.NotNull;

class StateMachineImp<O, S extends Enum<S>, E extends Enum<E>>
implements StateMachine<O, S, E> {
    private final String name;
    private final State<O, S, E> root;
    private final O owner;
    private final StateMachineEventHandlerHelper<O, S, E> helper;
    private final Deque<State<O, S, E>> activeStates;
    private final Set<State<O, S, E>> history;

    StateMachineImp(String name, @NotNull State<O, S, E> root, O owner) {
        this.name = name;
        this.root = root;
        this.owner = owner;
        this.activeStates = new ArrayDeque<State<O, S, E>>();
        this.history = new HashSet<State<O, S, E>>();
        this.helper = new StateMachineEventHandlerHelper();
        this.reset();
    }

    @Override
    public void reset() {
        this.activeStates.clear();
        this.history.clear();
        this.activeStates.add(this.root);
        this.enterStatesFromCommonAncestor(null, this.root.initialStates());
        this.helper.wasReset();
    }

    @Override
    public boolean fire(Event<E> event) {
        this.helper.processEvent(event);
        boolean fired = this.fireLocalTransition(event);
        if (!fired) {
            fired = this.fireTransition(event);
        }
        return fired;
    }

    private boolean fireLocalTransition(@NotNull Event<E> event) {
        boolean fired = false;
        Iterator<State<O, S, E>> iter = this.activeStates.descendingIterator();
        block2: while (iter.hasNext()) {
            State<O, S, E> state = iter.next();
            for (Transition<O, S, E> transition : state.localTransitions()) {
                try {
                    if (!transition.evaluate(this.owner, event)) continue;
                    fired = true;
                    this.helper.fireLocalTransition(transition, event);
                    this.fireTransition(transition, event);
                    continue block2;
                }
                catch (Exception e) {
                    this.helper.throwException(transition, event, e);
                }
            }
        }
        return fired;
    }

    private boolean fireTransition(@NotNull Event<E> event) {
        boolean fired = false;
        Iterator<State<O, S, E>> iter = this.activeStates.descendingIterator();
        while (iter.hasNext()) {
            State<O, S, E> state = iter.next();
            for (Transition<O, S, E> transition : state.transitions()) {
                try {
                    if (!transition.evaluate(this.owner, event)) continue;
                    fired = true;
                    Deque<State<O, S, E>> hierarchy = this.getHierarchyUpToCommonAncestor(transition.target());
                    this.exitStatesToCommonAncestor(event, hierarchy.getFirst());
                    this.helper.fireTransition(transition, event);
                    this.fireTransition(transition, event);
                    this.enterStatesFromCommonAncestor(event, hierarchy);
                    this.initiateStateWithHistory(event, this.activeStates.getLast());
                    break;
                }
                catch (Exception e) {
                    this.helper.throwException(transition, event, e);
                }
            }
            if (!fired) continue;
            break;
        }
        return fired;
    }

    private void fireTransition(@NotNull Transition<O, S, E> transition, @NotNull Event<E> event) {
        try {
            transition.execute(this.owner, event);
        }
        catch (Exception e) {
            this.helper.throwException(transition, event, e);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public O context() {
        return this.owner;
    }

    @Override
    public boolean isAlive() {
        return this.activeStates.stream().filter(o -> o != this.root).noneMatch(State::isFinal);
    }

    @Override
    public void addEventHandler(StateMachineEventHandler<O, S, E> handler) {
        this.helper.addEventHandler(handler);
    }

    @Override
    public void removeEventHandler(StateMachineEventHandler<O, S, E> handler) {
        this.helper.removeEventHandler(handler);
    }

    @Override
    public boolean isRegistered(StateMachineEventHandler<O, S, E> handler) {
        return this.helper.isRegistered(handler);
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("name=" + this.name).add("activeStates=" + this.activeStates).add("history=" + this.history).toString();
    }

    Collection<State<O, S, E>> getActiveStates() {
        return Collections.unmodifiableCollection(this.activeStates);
    }

    Collection<State<O, S, E>> getHistoryStates() {
        return Collections.unmodifiableCollection(this.history);
    }

    private void exitStatesToCommonAncestor(Event<E> event, State<O, S, E> ancestor) {
        State<O, S, E> leaf = null;
        State<O, S, E> state = this.activeStates.getLast();
        while (state != ancestor) {
            this.helper.executeExitAction(state, event);
            try {
                state.executeExitAction(this.owner, event);
            }
            catch (Exception e) {
                this.helper.throwException(state, state.exitAction(), event, e);
            }
            this.helper.exitState(state);
            this.activeStates.removeLast();
            if (leaf != null && state.hasHistory()) {
                this.history.add(leaf);
                this.history.add(state);
            }
            leaf = state;
            state = this.activeStates.getLast();
        }
    }

    private void enterStatesFromCommonAncestor(Event<E> event, Deque<State<O, S, E>> hierarchy) {
        hierarchy.removeFirst();
        for (State<O, S, E> state : hierarchy) {
            this.helper.enterState(state);
            this.activeStates.addLast(state);
            this.helper.executeEntryAction(state, event);
            try {
                state.executeEntryAction(this.owner, event);
            }
            catch (Exception e) {
                this.helper.throwException(state, state.exitAction(), event, e);
            }
            this.history.remove(state);
        }
    }

    private void initiateStateWithHistory(@NotNull Event<E> event, @NotNull State<O, S, E> state) {
        State<O, S, E> node = state;
        while (node != null && node.isComposite()) {
            if (node.hasHistory()) {
                HashSet<State<O, S, E>> historyStates = new HashSet<State<O, S, E>>(node.substates());
                historyStates.retainAll(this.history);
                node = historyStates.isEmpty() ? node.initialState() : (State<O, S, E>)historyStates.iterator().next();
            } else {
                node = node.initialState();
            }
            if (node == null) continue;
            node.executeEntryAction(this.owner, event);
            this.activeStates.addLast(node);
            this.history.remove(node);
        }
    }

    private Deque<State<O, S, E>> getHierarchyUpToCommonAncestor(@NotNull State<O, S, E> state) {
        Deque<State<O, S, State<O, S, E>>> hierarchy = this.root.getHierarchyFor(state);
        State<O, S, E> ancestor = null;
        while (!hierarchy.isEmpty() && this.activeStates.contains(hierarchy.getFirst())) {
            ancestor = hierarchy.pollFirst();
        }
        if (ancestor != null) {
            hierarchy.addFirst(ancestor);
        }
        return hierarchy;
    }
}

