/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.fsm.imp;

import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.tangly.fsm.Event;
import net.tangly.fsm.State;
import net.tangly.fsm.StateMachineEventHandler;
import net.tangly.fsm.Transition;

class StateMachineEventHandlerHelper<O, S extends Enum<S>, E extends Enum<E>>
implements StateMachineEventHandler<O, S, E> {
    private final Set<StateMachineEventHandler<O, S, E>> handlers = new HashSet<StateMachineEventHandler<O, S, E>>();

    StateMachineEventHandlerHelper() {
    }

    void addEventHandler(StateMachineEventHandler<O, S, E> handler) {
        this.handlers.add(handler);
    }

    void removeEventHandler(StateMachineEventHandler<O, S, E> handler) {
        this.handlers.remove(handler);
    }

    boolean isRegistered(StateMachineEventHandler<O, S, E> handler) {
        return this.handlers.contains(handler);
    }

    @Override
    public void processEvent(Event<E> event) {
        this.handlers.forEach(handler -> handler.processEvent(event));
    }

    @Override
    public void wasReset() {
        this.handlers.forEach(StateMachineEventHandler::wasReset);
    }

    @Override
    public void fireLocalTransition(Transition<O, S, E> transition, Event<E> event) {
        this.handlers.forEach(handler -> handler.fireLocalTransition(transition, event));
    }

    @Override
    public void fireTransition(Transition<O, S, E> transition, Event<E> event) {
        this.handlers.forEach(handler -> handler.fireTransition(transition, event));
    }

    @Override
    public void executeEntryAction(State<O, S, E> state, Event<E> event) {
        this.handlers.forEach(handler -> handler.executeEntryAction(state, event));
    }

    @Override
    public void executeExitAction(State<O, S, E> state, Event<E> event) {
        this.handlers.forEach(handler -> handler.executeExitAction(state, event));
    }

    @Override
    public void enterState(State<O, S, E> state) {
        this.handlers.forEach(handler -> handler.enterState(state));
    }

    @Override
    public void exitState(State<O, S, E> state) {
        this.handlers.forEach(handler -> handler.exitState(state));
    }

    @Override
    public void throwException(Transition<O, S, E> transition, Event<E> event, Exception e) {
        this.handlers.forEach(handler -> handler.throwException(transition, event, e));
    }

    @Override
    public void throwException(State<O, S, E> state, BiConsumer<O, Event<E>> action, Event<E> event, Exception e) {
        this.handlers.forEach(handler -> handler.throwException(state, action, event, e));
    }
}

