/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.fsm.imp;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import net.tangly.fsm.Event;
import net.tangly.fsm.State;
import net.tangly.fsm.Transition;

class StateImp<O, S extends Enum<S>, E extends Enum<E>>
implements State<O, S, E> {
    private final S id;
    private boolean hasHistory;
    private boolean initial;
    private BiConsumer<O, Event<E>> entryAction;
    private BiConsumer<O, Event<E>> exitAction;
    private final Set<State<O, S, E>> substates;
    private final Set<Transition<O, S, E>> localTransitions;
    private final Set<Transition<O, S, E>> transitions;
    private String description;
    private String entryActionDescription;
    private String exitActionDescription;

    StateImp(S id) {
        this.id = id;
        this.substates = new HashSet<State<O, S, E>>();
        this.localTransitions = new HashSet<Transition<O, S, E>>();
        this.transitions = new HashSet<Transition<O, S, E>>();
    }

    @Override
    public S id() {
        return this.id;
    }

    @Override
    public boolean hasHistory() {
        return this.hasHistory;
    }

    void setHasHistory(boolean hasHistory) {
        this.hasHistory = hasHistory;
    }

    @Override
    public boolean isInitial() {
        return this.initial;
    }

    void setInitial(boolean initial) {
        this.initial = initial;
    }

    @Override
    public void executeEntryAction(O owner, Event<E> event) {
        if (this.entryAction != null) {
            this.entryAction.accept(owner, event);
        }
    }

    @Override
    public void executeExitAction(O owner, Event<E> event) {
        if (this.exitAction != null) {
            this.exitAction.accept(owner, event);
        }
    }

    void setEntryAction(BiConsumer<O, Event<E>> entryAction) {
        this.entryAction = entryAction;
    }

    @Override
    public BiConsumer<O, Event<E>> entryAction() {
        return this.entryAction;
    }

    void setExitAction(BiConsumer<O, Event<E>> exitAction) {
        this.exitAction = exitAction;
    }

    @Override
    public BiConsumer<O, Event<E>> exitAction() {
        return this.exitAction;
    }

    @Override
    public Set<State<O, S, E>> substates() {
        return Collections.unmodifiableSet(this.substates);
    }

    void addSubstate(State<O, S, E> substate) {
        this.substates.add(substate);
    }

    @Override
    public Set<Transition<O, S, E>> transitions() {
        return Collections.unmodifiableSet(this.transitions);
    }

    void addTransition(Transition<O, S, E> transition) {
        this.transitions.add(transition);
    }

    @Override
    public Set<Transition<O, S, E>> localTransitions() {
        return Collections.unmodifiableSet(this.localTransitions);
    }

    void addLocalTransition(Transition<O, S, E> transition) {
        this.localTransitions.add(transition);
    }

    @Override
    public String description() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String entryActionDescription() {
        return this.entryActionDescription;
    }

    void setEntryActionDescription(String description) {
        this.entryActionDescription = description;
    }

    @Override
    public String exitActionDescription() {
        return this.exitActionDescription;
    }

    void setExitActionDescription(String description) {
        this.exitActionDescription = description;
    }

    @Override
    public State<O, S, E> initialState() {
        return this.substates().stream().filter(State::isInitial).findAny().orElse(null);
    }

    @Override
    public Deque<State<O, S, E>> initialStates() {
        ArrayDeque<State<O, S, State<O, S, E>>> states = new ArrayDeque<State<O, S, State<O, S, E>>>();
        if (this.isInitial()) {
            states.addLast(this);
            for (State<O, S, E> initialState = this.initialState(); initialState != null; initialState = initialState.initialState()) {
                states.addLast(initialState);
            }
        }
        return states;
    }

    @Override
    public State<O, S, E> getStateFor(S stateId) {
        if (this.id == stateId) {
            return this;
        }
        for (State<O, S, E> candidate : this.substates()) {
            State<O, S, E> substate = candidate.getStateFor(stateId);
            if (substate == null) continue;
            return substate;
        }
        return null;
    }

    @Override
    public Deque<State<O, S, E>> getHierarchyFor(State<O, S, E> substate) {
        return this.getHierarchyFor(new ArrayDeque<State<O, S, E>>(), this, substate);
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("id=" + this.id).add("hasHistory=" + this.hasHistory).add("initial=" + this.initial).add("description=" + this.description).add("entryActionDescription=" + this.entryActionDescription).add("exitActionDescription=" + this.exitActionDescription).toString();
    }

    private Deque<State<O, S, E>> getHierarchyFor(Deque<State<O, S, E>> substates, State<O, S, E> compositeState, State<O, S, E> substate) {
        if (compositeState.substates().contains(substate)) {
            substates.addFirst(substate);
            substates.addFirst(this);
        } else {
            for (State<O, S, E> state : compositeState.substates()) {
                if (((StateImp)state).getHierarchyFor(substates, state, substate).isEmpty()) continue;
                substates.addFirst(compositeState);
                break;
            }
        }
        return substates;
    }
}

