/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.fsm.imp;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.tangly.fsm.Event;
import net.tangly.fsm.State;
import net.tangly.fsm.StateMachine;
import net.tangly.fsm.dsl.FsmBuilder;
import net.tangly.fsm.dsl.StateBuilder;
import net.tangly.fsm.dsl.SubStateBuilder;
import net.tangly.fsm.dsl.ToTransitionBuilder;
import net.tangly.fsm.dsl.TransitionBuilder;
import net.tangly.fsm.imp.StateImp;
import net.tangly.fsm.imp.StateMachineImp;
import net.tangly.fsm.imp.TransitionImp;

public class DefinitionBuilder<O, S extends Enum<S>, E extends Enum<E>>
implements FsmBuilder<O, S, E>,
StateBuilder<O, S, E>,
SubStateBuilder<O, S, E>,
ToTransitionBuilder<O, S, E>,
TransitionBuilder<O, S, E> {
    private final Map<S, StateImp<O, S, E>> states;
    private final StateImp<O, S, E> root;
    private StateImp<O, S, E> context;
    private E eventId;
    private TransitionImp<O, S, E> transition;

    public DefinitionBuilder(S rootId) {
        this.root = new StateImp(rootId);
        this.root.setInitial(true);
        this.states = new EnumMap(rootId.getClass());
    }

    @Override
    public State<O, S, E> definition() {
        this.resetContext();
        return this.root;
    }

    @Override
    public StateMachine<O, S, E> machine(String name, O owner) {
        return new StateMachineImp<O, S, E>(name, this.definition(), owner);
    }

    @Override
    public StateBuilder<O, S, E> in(S stateId) {
        if (!this.states.containsKey(stateId)) {
            throw new IllegalArgumentException();
        }
        this.resetContext();
        this.context = this.states.get(stateId);
        return this;
    }

    @Override
    public StateBuilder<O, S, E> root() {
        this.resetContext();
        this.context = this.root;
        return this;
    }

    @Override
    public SubStateBuilder<O, S, E> add(S stateId, String description) {
        if (this.states.containsKey(stateId)) {
            throw new IllegalArgumentException();
        }
        StateImp state = new StateImp(stateId);
        state.setDescription(description);
        this.states.put(stateId, state);
        this.context.addSubstate(state);
        this.context = state;
        return this;
    }

    @Override
    public TransitionBuilder<O, S, E> to(S stateId, String description) {
        if (!this.states.containsKey(stateId) || this.eventId == null) {
            throw new IllegalArgumentException();
        }
        this.transition = new TransitionImp<O, S, E>(this.context, this.states.get(stateId), this.eventId);
        this.transition.description(description);
        this.context.addTransition(this.transition);
        return this;
    }

    @Override
    public ToTransitionBuilder<O, S, E> on(E eventId) {
        this.eventId = eventId;
        return this;
    }

    @Override
    public TransitionBuilder<O, S, E> onLocal(E eventId, String description) {
        this.eventId = eventId;
        this.transition = new TransitionImp<O, S, E>(this.context, this.context, eventId);
        this.transition.description(description);
        this.context.addLocalTransition(this.transition);
        return this;
    }

    @Override
    public TransitionBuilder<O, S, E> onlyIf(BiPredicate<O, Event<E>> guard, String description) {
        this.transition.guard(guard);
        this.transition.guardDescription(description);
        return this;
    }

    @Override
    public TransitionBuilder<O, S, E> execute(BiConsumer<O, Event<E>> action, String description) {
        this.transition.action(action);
        this.transition.setActionDescription(description);
        return this;
    }

    @Override
    public SubStateBuilder<O, S, E> hasHistory(boolean hasHistory) {
        this.context.setHasHistory(hasHistory);
        return this;
    }

    @Override
    public SubStateBuilder<O, S, E> isInitial() {
        return this.isInitial(true);
    }

    @Override
    public SubStateBuilder<O, S, E> isInitial(boolean initial) {
        this.context.setInitial(initial);
        return this;
    }

    @Override
    public SubStateBuilder<O, S, E> onEntry(BiConsumer<O, Event<E>> action, String description) {
        this.context.setEntryAction(action);
        this.context.setEntryActionDescription(description);
        return this;
    }

    @Override
    public SubStateBuilder<O, S, E> onExit(BiConsumer<O, Event<E>> action, String description) {
        this.context.setExitAction(action);
        this.context.setExitActionDescription(description);
        return this;
    }

    private void resetContext() {
        this.context = null;
        this.eventId = null;
        this.transition = null;
    }
}

