/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.fsm.actors;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.tangly.fsm.Event;
import net.tangly.fsm.actors.Actor;
import net.tangly.fsm.actors.Actors;
import net.tangly.fsm.actors.LocalActor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalActors<E extends Enum<E>>
implements Actors<E> {
    private static final Logger log = LoggerFactory.getLogger(LocalActors.class);
    private static final LocalActors<?> instance = new LocalActors();
    private final Map<String, Actor<E>> actors = new ConcurrentHashMap<String, Actor<E>>();
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public static LocalActors instance() {
        return instance;
    }

    @Override
    public void sendEventTo(@NotNull Event<E> event, @NotNull String name) {
        Object actor = this.getActorNamed(name);
        if (actor != null) {
            actor.receive(event);
        }
    }

    @Override
    public <T extends Actor<E>> T getActorNamed(@NotNull String name) {
        return (T)this.actors.get(name);
    }

    @Override
    public <T extends Actor<E>> void register(@NotNull T actor) {
        this.actors.put(actor.name(), actor);
        this.executor.submit((LocalActor)actor);
    }

    @Override
    public <T extends Actor<E>> void awaitCompletion(@NotNull T actor, int intervalInMilliseconds) {
        this.awaitCompletion(Collections.singleton(actor), intervalInMilliseconds);
    }

    @Override
    public <T extends Actor<E>> void awaitCompletion(@NotNull Set<T> actors, int intervalInMilliseconds) {
        while (actors.stream().anyMatch(Actor::isAlive)) {
            try {
                Thread.sleep(intervalInMilliseconds);
            }
            catch (InterruptedException e) {
                log.error("LocalActors encountered interrupted exception {}", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

