/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.fsm.actors;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.tangly.fsm.Event;
import net.tangly.fsm.StateMachine;
import net.tangly.fsm.actors.Actor;
import net.tangly.fsm.actors.LocalActors;
import net.tangly.fsm.dsl.FsmBuilder;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalActor<O extends LocalActor, S extends Enum<S>, E extends Enum<E>>
implements Actor<E>,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(LocalActor.class);
    private final BlockingQueue<Event<E>> events;
    private final StateMachine<O, S, E> fsm;

    public LocalActor(@NotNull FsmBuilder<O, S, E> builder, @NotNull String name) {
        this.fsm = builder.machine(name, this);
        this.events = new LinkedBlockingQueue<Event<E>>();
        LocalActors.instance().register(this);
    }

    @Override
    public String name() {
        return this.fsm.name();
    }

    @Override
    public boolean isAlive() {
        return this.fsm.isAlive();
    }

    @Override
    public void receive(@NotNull Event<E> event) {
        try {
            this.events.put(event);
            log.info("Actor {} received event {}", (Object)this.name(), event);
        }
        catch (InterruptedException e) {
            log.error("Actor {} encountered interrupted exception {}", (Object)this.name(), (Object)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void run() {
        while (this.fsm.isAlive()) {
            try {
                Event<E> event = this.events.take();
                this.fsm.fire(event);
            }
            catch (InterruptedException e) {
                log.error("Actor {} encountered interrupted exception {}", (Object)this.name(), (Object)e);
                Thread.currentThread().interrupt();
            }
        }
    }
}

