/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.fsm;

import java.util.Deque;
import java.util.Set;
import java.util.function.BiConsumer;
import net.tangly.fsm.Event;
import net.tangly.fsm.Transition;
import org.jetbrains.annotations.NotNull;

public interface State<O, S extends Enum<S>, E extends Enum<E>>
extends Comparable<State<O, S, E>> {
    @Override
    default public int compareTo(@NotNull State<O, S, E> other) {
        return ((Enum)this.id()).compareTo(other.id());
    }

    public S id();

    public boolean hasHistory();

    public boolean isInitial();

    default public boolean isFinal() {
        return this.localTransitions().isEmpty() && this.transitions().isEmpty();
    }

    default public boolean isComposite() {
        return !this.substates().isEmpty();
    }

    public void executeEntryAction(O var1, Event<E> var2);

    public void executeExitAction(O var1, Event<E> var2);

    public Set<State<O, S, E>> substates();

    public Set<Transition<O, S, E>> transitions();

    public Set<Transition<O, S, E>> localTransitions();

    public BiConsumer<O, Event<E>> entryAction();

    public BiConsumer<O, Event<E>> exitAction();

    public State<O, S, E> getStateFor(S var1);

    public State<O, S, E> initialState();

    public Deque<State<O, S, E>> initialStates();

    public Deque<State<O, S, E>> getHierarchyFor(State<O, S, E> var1);

    public String description();

    public String entryActionDescription();

    public String exitActionDescription();
}

