/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.fsm;

import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;

public class Event<E extends Enum<E>> {
    private final E type;
    private final List<Object> parameters;

    public Event(E type, List<Object> parameters) {
        this.type = type;
        this.parameters = parameters != null ? List.copyOf(parameters) : Collections.emptyList();
    }

    public Event(E type, Object ... parameters) {
        this(type, List.of(parameters));
    }

    public Event(E type) {
        this.type = type;
        this.parameters = Collections.emptyList();
    }

    public E type() {
        return this.type;
    }

    public List<Object> parameters() {
        return this.parameters;
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "[", "]").add("type=" + this.type).add("parameters=" + this.parameters).toString();
    }
}

