/*
 * Decompiled with CFR 0.152.
 */
package net.subnoize.qcat;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import net.subnoize.qcat.Provider;
import net.subnoize.qcat.Qcat;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.proxy.Factory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan(basePackages={"net.subnoize.qcat"})
public class QcatConfiguration {
    private static Logger log = LoggerFactory.getLogger(QcatConfiguration.class);
    @Autowired
    private ApplicationContext context;

    @PostConstruct
    public void init() throws ClassNotFoundException {
        Map beans = this.context.getBeansWithAnnotation(Qcat.class);
        for (Object target : beans.values()) {
            Qcat qcat;
            Class<?> klass = target.getClass();
            List<Class<?>> interfaces = Arrays.asList(klass.getInterfaces());
            if (interfaces.contains(Factory.class) || interfaces.contains(SpringProxy.class) || interfaces.contains(Advised.class)) {
                klass = klass.getSuperclass();
            }
            if (StringUtils.isNotBlank((CharSequence)(qcat = klass.getAnnotation(Qcat.class)).value())) {
                ((Provider)this.context.getBean(qcat.value(), Provider.class)).registerListener(klass);
                continue;
            }
            log.error("@Qcat used with blank service reference: {}", (Object)klass.getName());
        }
    }
}

