/**
 * (c)opyright 2020 subnoize llc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.subnoize.qcat.send;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Marks a lister method as having the ability to send the return value as a
 * object as a message to the next queue;
 * 
 * <pre>
 * <code>
 * &#64;Component
 * public class MyListeners {	
 *   &#64;ListenTo(value = "${examples.say.hello.queue}")
 *   &#64;SendTo("${examples.say.hello.result.queue}")
 *   public String sayHello(String msg) {
 *     return "Hello, "+msg;
 *   }
 * }
 * </code>
 * </pre>
 * 
 * 
 * @author John Bryant
 *
 */
@Retention(RUNTIME)
@Target(METHOD)
public @interface SendTo {

	/**
	 * The queue to send the return value too. Can be overridden by the Session
	 * object./
	 * 
	 * @return
	 */
	String value() default "";
}
