/*
 * Decompiled with CFR 0.152.
 */
package net.streamok.lib.download;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.lang.ref.SoftReference;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.zip.ZipInputStream;
import net.streamok.lib.download.BinaryCoordinates;
import net.streamok.lib.download.FileDownloadException;
import net.streamok.lib.download.UnsupportedCompressionFormatException;
import net.streamok.lib.process.Command;
import net.streamok.lib.process.ProcessManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.slf4j.LoggerFactory;

public class DownloadManager
implements GroovyObject {
    private static final Object LOG;
    private final ProcessManager processManager;
    private final File downloadDirectory;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    public DownloadManager(ProcessManager processManager, File file) {
        void downloadDirectory;
        void processManager2;
        MetaClass metaClass;
        CallSite[] callSiteArray = DownloadManager.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var5_5 = processManager2;
        this.processManager = (ProcessManager)ScriptBytecodeAdapter.castToType((Object)var5_5, ProcessManager.class);
        void var6_6 = downloadDirectory;
        this.downloadDirectory = (File)ScriptBytecodeAdapter.castToType((Object)var6_6, File.class);
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[0].callCurrent((GroovyObject)this);
        } else {
            this.initialize();
        }
    }

    private Object initialize() {
        CallSite[] callSiteArray = DownloadManager.$getCallSiteArray();
        return callSiteArray[1].call((Object)this.downloadDirectory);
    }

    public void download(BinaryCoordinates coordinates) {
        CallSite[] callSiteArray = DownloadManager.$getCallSiteArray();
        callSiteArray[2].call(Validate.class, callSiteArray[3].call((Object)coordinates), (Object)"Source URL cannot be null.");
        callSiteArray[4].call(Validate.class, callSiteArray[5].call((Object)coordinates), (Object)"Please indicate the name of the target file.");
        callSiteArray[6].call(LOG, (Object)"About to download file using the following coordinates: {}", (Object)coordinates);
        Object targetFile = callSiteArray[7].callCurrent((GroovyObject)this, callSiteArray[8].callGroovyObjectGetProperty((Object)coordinates));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].call(targetFile))) {
            callSiteArray[10].call(LOG, (Object)"File {} does not exist - downloading...", callSiteArray[11].callGetProperty(targetFile));
            Object tmpFile = callSiteArray[12].callStatic(File.class, (Object)"streamok", (Object)"download");
            try {
                callSiteArray[13].callStatic(IOUtils.class, callSiteArray[14].call(callSiteArray[15].call((Object)coordinates)), callSiteArray[16].callConstructor(FileOutputStream.class, tmpFile));
            }
            catch (UnknownHostException e) {
                throw (Throwable)callSiteArray[17].callConstructor(FileDownloadException.class, callSiteArray[18].callGetProperty(targetFile), (Object)e);
            }
            callSiteArray[19].call(callSiteArray[20].callGetProperty(targetFile));
            callSiteArray[21].call(tmpFile, targetFile);
            callSiteArray[22].call(LOG, (Object)"Saved downloaded file to {}.", callSiteArray[23].callGetProperty(targetFile));
        } else {
            callSiteArray[24].call(LOG, (Object)"File {} exists - download skipped.", targetFile);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[25].callGroovyObjectGetProperty((Object)coordinates), null)) {
            Object extractedImage = callSiteArray[26].callCurrent((GroovyObject)this, callSiteArray[27].callGroovyObjectGetProperty((Object)coordinates));
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].call(extractedImage))) {
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[29].call(callSiteArray[30].callGetProperty(targetFile), (Object)".zip"))) {
                    Object zip = callSiteArray[31].callConstructor(ZipInputStream.class, callSiteArray[32].callConstructor(FileInputStream.class, targetFile));
                    callSiteArray[33].callGetProperty(zip);
                    callSiteArray[34].call(IOUtils.class, zip, callSiteArray[35].callConstructor(FileOutputStream.class, extractedImage));
                    callSiteArray[36].call(zip);
                } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[37].call(callSiteArray[38].callGetProperty(targetFile), (Object)".tar.gz"))) {
                    callSiteArray[39].call(extractedImage);
                    callSiteArray[40].call((Object)this.processManager, callSiteArray[41].callStatic(Command.class, (Object)new GStringImpl(new Object[]{targetFile, extractedImage}, new String[]{"tar xvpf ", " -C ", ""})));
                } else {
                    throw (Throwable)callSiteArray[42].callConstructor(UnsupportedCompressionFormatException.class, callSiteArray[43].callGetProperty(targetFile));
                }
            }
        }
    }

    public File downloadDirectory() {
        CallSite[] callSiteArray = DownloadManager.$getCallSiteArray();
        return this.downloadDirectory;
    }

    public File downloadedFile(String name) {
        CallSite[] callSiteArray = DownloadManager.$getCallSiteArray();
        callSiteArray[44].call(Validate.class, (Object)name, (Object)"Name of the downloaded file cannot be blank.");
        return (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[45].callConstructor(File.class, (Object)this.downloadDirectory, (Object)name), File.class);
    }

    public File fileFromExtractedDirectory(String extractedDirectoryName, String filename) {
        CallSite[] callSiteArray = DownloadManager.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].call(callSiteArray[47].call(Paths.class, callSiteArray[48].callGetProperty(callSiteArray[49].callCurrent((GroovyObject)this, (Object)extractedDirectoryName)), (Object)filename)), File.class);
        }
        return (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].call(callSiteArray[51].call(Paths.class, callSiteArray[52].callGetProperty((Object)this.downloadedFile(extractedDirectoryName)), (Object)filename)), File.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DownloadManager.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object;
        LOG = object = DownloadManager.$getCallSiteArray()[53].callStatic(LoggerFactory.class, DownloadManager.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "initialize";
        stringArray[1] = "mkdirs";
        stringArray[2] = "notNull";
        stringArray[3] = "source";
        stringArray[4] = "notNull";
        stringArray[5] = "fileName";
        stringArray[6] = "debug";
        stringArray[7] = "downloadedFile";
        stringArray[8] = "fileName";
        stringArray[9] = "exists";
        stringArray[10] = "debug";
        stringArray[11] = "absolutePath";
        stringArray[12] = "createTempFile";
        stringArray[13] = "copyLarge";
        stringArray[14] = "openStream";
        stringArray[15] = "source";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "name";
        stringArray[19] = "mkdirs";
        stringArray[20] = "parentFile";
        stringArray[21] = "renameTo";
        stringArray[22] = "debug";
        stringArray[23] = "absolutePath";
        stringArray[24] = "debug";
        stringArray[25] = "extractedFileName";
        stringArray[26] = "downloadedFile";
        stringArray[27] = "extractedFileName";
        stringArray[28] = "exists";
        stringArray[29] = "endsWith";
        stringArray[30] = "name";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "nextEntry";
        stringArray[34] = "copyLarge";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "close";
        stringArray[37] = "endsWith";
        stringArray[38] = "name";
        stringArray[39] = "mkdirs";
        stringArray[40] = "execute";
        stringArray[41] = "cmd";
        stringArray[42] = "<$constructor$>";
        stringArray[43] = "name";
        stringArray[44] = "notBlank";
        stringArray[45] = "<$constructor$>";
        stringArray[46] = "toFile";
        stringArray[47] = "get";
        stringArray[48] = "absolutePath";
        stringArray[49] = "downloadedFile";
        stringArray[50] = "toFile";
        stringArray[51] = "get";
        stringArray[52] = "absolutePath";
        stringArray[53] = "getLogger";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[54];
        DownloadManager.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DownloadManager.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DownloadManager.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

