/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.coercion.target;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.GenericArrayType;
import net.stickycode.coercion.CoercionTarget;
import net.stickycode.coercion.target.CoercionTargets;

public class ParameterizedArrayCoercionTarget
implements CoercionTarget {
    private final GenericArrayType type;
    private Class<?> owner;
    private CoercionTarget parent;
    private final String name;

    public ParameterizedArrayCoercionTarget(GenericArrayType genericType, Class<?> owner, CoercionTarget parent, String name) {
        this.owner = owner;
        this.type = genericType;
        this.parent = parent;
        this.name = name;
    }

    @Override
    public Class<?> getType() {
        throw new UnsupportedOperationException("Generic array types don't have a type");
    }

    @Override
    public boolean hasComponents() {
        return true;
    }

    @Override
    public CoercionTarget[] getComponentCoercionTypes() {
        return new CoercionTarget[]{CoercionTargets.find(this.type.getGenericComponentType(), this.owner, this.name)};
    }

    @Override
    public boolean isArray() {
        return true;
    }

    public int hashCode() {
        return 31 * this.type.getGenericComponentType().getClass().getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterizedArrayCoercionTarget other = (ParameterizedArrayCoercionTarget)obj;
        if (this.type == null && other.type != null) {
            return false;
        }
        return CoercionTargets.find(this.type.getGenericComponentType(), this.owner, this.name).equals(CoercionTargets.find(other.type.getGenericComponentType(), this.owner, this.name));
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public Class<?> boxedType() {
        throw new UnsupportedOperationException("No boxed type here, move along please");
    }

    @Override
    public boolean canBeAnnotated() {
        return false;
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        throw new UnsupportedOperationException("Arrays cannot be annotated directly");
    }

    @Override
    public Class<?> getOwner() {
        return this.owner;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.type + "}";
    }

    @Override
    public CoercionTarget getParent() {
        return this.parent;
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

