/*
 * Decompiled with CFR 0.152.
 */
package net.stickycode.coercion.target;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import net.stickycode.coercion.CoercionTarget;
import net.stickycode.coercion.target.AbstractCoercionTarget;
import net.stickycode.coercion.target.CoercionTargets;

public class ParameterizedCoercionTarget
extends AbstractCoercionTarget {
    private ParameterizedType parameterizedType;
    private AnnotatedElement annotatedElement;

    public ParameterizedCoercionTarget(ParameterizedType genericType, AnnotatedElement element, Class<?> owner, CoercionTarget parent) {
        super((Class)genericType.getRawType(), owner, parent);
        this.parameterizedType = genericType;
        this.annotatedElement = element;
    }

    @Override
    public boolean hasComponents() {
        return true;
    }

    @Override
    public CoercionTarget[] getComponentCoercionTypes() {
        Type[] actualTypeArguments = this.parameterizedType.getActualTypeArguments();
        CoercionTarget[] targets = new CoercionTarget[actualTypeArguments.length];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = CoercionTargets.find((Class)this.parameterizedType.getRawType(), actualTypeArguments[i], this.annotatedElement, this.owner, this.parent);
        }
        return targets;
    }

    public int hashCode() {
        return 33 * this.getType().getClass().getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterizedCoercionTarget other = (ParameterizedCoercionTarget)obj;
        if (this.parameterizedType == null && other.parameterizedType != null) {
            return false;
        }
        if (this.parameterizedType.getRawType() != other.parameterizedType.getRawType()) {
            return false;
        }
        if (this.parameterizedType.getOwnerType() != other.parameterizedType.getOwnerType()) {
            return false;
        }
        return Arrays.deepEquals(this.parameterizedType.getActualTypeArguments(), other.parameterizedType.getActualTypeArguments());
    }

    @Override
    public boolean canBeAnnotated() {
        return this.annotatedElement != null;
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.annotatedElement;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.annotatedElement + " on " + this.owner.getSimpleName() + "}";
    }
}

